/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.tree;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.tree.TreeDataHandler;
import com.oracle.cie.common.tree.BasicTree;
import com.oracle.cie.common.tree.XMLTreeData;
import com.oracle.cie.common.tree.XMLTreeDataFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.SAXException;

public class TreeDataHandlerSpiImpl
extends DataHandlerSpi {
    public static final String SCHEMA_LOCATIONS_FILE = "com/oracle/cie/common/dao/tree/schema-locations";
    private static final Logger _log = Logger.getLogger(TreeDataHandlerSpiImpl.class.getName());
    private static Object _schemaInfoLoader;
    private static HashMap<ClassLoader, Collection<String>> schemaLocationCache;

    @Override
    public IDataHandler create(String namespace, String id, ClassLoader classloader) {
        return new TreeDataHandler(new BasicTree(id, new XMLTreeData()), id, TreeDataHandlerSpiImpl.getTypeName(id, namespace, classloader), namespace, classloader);
    }

    @Override
    public IDataHandler create(String namespace, String id, File file, ClassLoader classloader) throws DataHandlerException {
        try {
            return this.create(namespace, id, new FileInputStream(file), classloader);
        }
        catch (FileNotFoundException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, InputStream is, ClassLoader classloader) throws DataHandlerException {
        try {
            return new TreeDataHandler(XMLTreeDataFactory.create(is), id, TreeDataHandlerSpiImpl.getTypeName(id, namespace, classloader), namespace, classloader);
        }
        catch (IOException e) {
            throw new DataHandlerException(e);
        }
        catch (ParserConfigurationException e) {
            throw new DataHandlerException(e);
        }
        catch (SAXException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, String s, ClassLoader classloader) throws DataHandlerException {
        try {
            return new TreeDataHandler(XMLTreeDataFactory.create(new StringReader(s)), id, TreeDataHandlerSpiImpl.getTypeName(id, namespace, classloader), namespace, classloader);
        }
        catch (IOException e) {
            throw new DataHandlerException(e);
        }
        catch (ParserConfigurationException e) {
            throw new DataHandlerException(e);
        }
        catch (SAXException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, URL url, ClassLoader classloader) throws DataHandlerException {
        try {
            return new TreeDataHandler(XMLTreeDataFactory.create(url), id, TreeDataHandlerSpiImpl.getTypeName(id, namespace, classloader), namespace, classloader);
        }
        catch (IOException e) {
            throw new DataHandlerException(e);
        }
        catch (ParserConfigurationException e) {
            throw new DataHandlerException(e);
        }
        catch (SAXException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public IDataHandler create(String namespace, String id, SAXSource source, ClassLoader classloader) throws DataHandlerException {
        throw new DataHandlerException("The ability to create a data handler from a SAXSource is currently not supported.");
    }

    static void populateTypeInfo(TreeDataHandler dataHandler, String namespace, ClassLoader classloader) {
        if (TreeDataHandlerSpiImpl.createSchemaInfoLoader(classloader)) {
            TreeDataHandlerSpiImpl.populateTypeInfo(dataHandler, namespace);
        }
    }

    static String getTypeName(String elementName, String namespace, ClassLoader classloader) {
        block3: {
            if (TreeDataHandlerSpiImpl.createSchemaInfoLoader(classloader)) {
                try {
                    Class<?> infoLoader = _schemaInfoLoader.getClass();
                    Method m = infoLoader.getMethod("getTypeName", String.class, String.class);
                    return (String)m.invoke(_schemaInfoLoader, elementName, namespace);
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.FINE)) break block3;
                    _log.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private static boolean createSchemaInfoLoader(ClassLoader classloader) {
        block8: {
            if (_schemaInfoLoader == null) {
                Collection<String> schemaLocations = null;
                if (classloader == null) {
                    classloader = TreeDataHandlerSpiImpl.class.getClassLoader();
                    if (schemaLocations == null) {
                        schemaLocations = TreeDataHandlerSpiImpl.getSchemaLocations(classloader);
                    }
                }
                if (classloader != TreeDataHandlerSpiImpl.class.getClassLoader()) {
                    schemaLocations = TreeDataHandlerSpiImpl.getSchemaLocations(classloader);
                }
                if (schemaLocations != null && !schemaLocations.isEmpty()) {
                    try {
                        classloader.loadClass("com.sun.tools.internal.xjc.ModelLoader");
                        Class<?> infoLoader = classloader.loadClass("com.oracle.cie.common.dao.SchemaInfoLoader");
                        _schemaInfoLoader = infoLoader.getConstructor(Collection.class, ClassLoader.class).newInstance(schemaLocations, classloader);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        if (!_log.isLoggable(Level.FINE)) break block8;
                        _log.log(Level.FINE, e.getMessage(), e);
                    }
                }
            }
        }
        return _schemaInfoLoader != null;
    }

    private static void populateTypeInfo(TreeDataHandler dataHandler, String namespace) {
        block3: {
            if (_schemaInfoLoader != null) {
                try {
                    Class<?> infoLoader = _schemaInfoLoader.getClass();
                    Method m = infoLoader.getMethod("getAttributeNames", String.class, String.class, String.class);
                    String[] names = (String[])m.invoke(_schemaInfoLoader, dataHandler.getElement(), dataHandler.getType(), namespace);
                    dataHandler.setAttributeNames(names);
                    m = infoLoader.getMethod("getSimpleElementNames", String.class, String.class, String.class);
                    names = (String[])m.invoke(_schemaInfoLoader, dataHandler.getElement(), dataHandler.getType(), namespace);
                    dataHandler.setSimpleNames(names);
                    m = infoLoader.getMethod("getComplexElementNames", String.class, String.class, String.class);
                    names = (String[])m.invoke(_schemaInfoLoader, dataHandler.getElement(), dataHandler.getType(), namespace);
                    dataHandler.setComplexNames(names);
                    m = infoLoader.getMethod("getComplexTypeNames", String.class, String.class, String.class);
                    Map typeNames = (Map)m.invoke(_schemaInfoLoader, dataHandler.getElement(), dataHandler.getType(), namespace);
                    dataHandler.setComplexTypes(typeNames);
                    m = infoLoader.getMethod("getDefaultAttributeValues", String.class, String.class, String.class);
                    Map defaultVals = (Map)m.invoke(_schemaInfoLoader, dataHandler.getElement(), dataHandler.getType(), namespace);
                    dataHandler.setDefaultAttributeValues(defaultVals);
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.FINE)) break block3;
                    _log.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getSchemaLocations(ClassLoader classloader) {
        Collection<String> schemaLocations = schemaLocationCache.get(classloader);
        if (schemaLocations != null) {
            return schemaLocations;
        }
        schemaLocations = new LinkedHashSet<String>();
        Enumeration<URL> locationdefs = null;
        try {
            locationdefs = classloader.getResources(SCHEMA_LOCATIONS_FILE);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (locationdefs != null) {
            while (locationdefs.hasMoreElements()) {
                URL locationdef = locationdefs.nextElement();
                InputStream is = null;
                InputStreamReader isr = null;
                BufferedReader br = null;
                try {
                    String line;
                    is = locationdef.openStream();
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        schemaLocations.add(line);
                    }
                }
                catch (IOException e) {
                    if (!_log.isLoggable(Level.FINE)) continue;
                    _log.log(Level.FINE, "Error loading data from schema-locations file: " + locationdef, e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {}
                    }
                    if (br == null) continue;
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        schemaLocationCache.put(classloader, schemaLocations);
        return schemaLocations;
    }

    static {
        schemaLocationCache = new HashMap();
    }
}

