/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.xbean;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.DataHandlerSpi;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.xbean.XBeanDataHandler;
import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXSource;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;

public class XBeanDataHandlerSpiImpl
extends DataHandlerSpi {
    @Override
    public IDataHandler create(String namespace, String id, ClassLoader classloader) {
        SchemaTypeLoader typeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)(classloader != null ? classloader : XBeanDataHandlerSpiImpl.class.getClassLoader()));
        SchemaType schemaType = typeLoader.findType(new QName(namespace, id + "Type"));
        return new XBeanDataHandler(schemaType.getTypeSystem().newInstance(schemaType, null), id);
    }

    @Override
    public IDataHandler create(String namespace, String id, File file, ClassLoader classloader) throws DataHandlerException {
        XmlObject obj;
        SchemaType schemaType = this.getSchemaType(namespace, id, classloader);
        try {
            obj = schemaType.getTypeSystem().parse(file, schemaType, XBeanDataHandler.getXmlOptions());
            if (schemaType.isDocumentType()) {
                obj = this.getNonDocumentObject(obj, id);
            }
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
        return new XBeanDataHandler(obj, id);
    }

    @Override
    public IDataHandler create(String namespace, String id, InputStream is, ClassLoader classloader) throws DataHandlerException {
        XmlObject obj;
        SchemaType schemaType = this.getSchemaType(namespace, id, classloader);
        try {
            obj = schemaType.getTypeSystem().parse(is, schemaType, XBeanDataHandler.getXmlOptions());
            if (schemaType.isDocumentType()) {
                obj = this.getNonDocumentObject(obj, id);
            }
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
        return new XBeanDataHandler(obj, id);
    }

    @Override
    public IDataHandler create(String namespace, String id, String s, ClassLoader classloader) throws DataHandlerException {
        XmlObject obj;
        SchemaType schemaType = this.getSchemaType(namespace, id, classloader);
        if (schemaType == null) {
            throw new DataHandlerException("Unable to locate xbean schema type system for id=" + id + " namespace=" + namespace);
        }
        try {
            obj = schemaType.getTypeSystem().parse(s, schemaType, XBeanDataHandler.getXmlOptions());
            if (schemaType.isDocumentType()) {
                obj = this.getNonDocumentObject(obj, id);
            }
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
        return new XBeanDataHandler(obj, id);
    }

    @Override
    public IDataHandler create(String namespace, String id, URL url, ClassLoader classloader) throws DataHandlerException {
        XmlObject obj;
        SchemaType schemaType = this.getSchemaType(namespace, id, classloader);
        try {
            obj = schemaType.getTypeSystem().parse(url, schemaType, XBeanDataHandler.getXmlOptions());
            if (schemaType.isDocumentType()) {
                obj = this.getNonDocumentObject(obj, id);
            }
        }
        catch (Exception e) {
            throw new DataHandlerException(e);
        }
        return new XBeanDataHandler(obj, id);
    }

    @Override
    public IDataHandler create(String namespace, String id, SAXSource source, ClassLoader classloader) throws DataHandlerException {
        throw new DataHandlerException("The ability to create a data handler from a SAXSource is currently not supported.");
    }

    private SchemaType getSchemaType(String namespace, String id, ClassLoader classloader) {
        SchemaTypeLoader typeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)(classloader != null ? classloader : XBeanDataHandlerSpiImpl.class.getClassLoader()));
        SchemaType schemaType = typeLoader.findDocumentType(new QName(namespace, id));
        if (schemaType == null) {
            schemaType = typeLoader.findType(new QName(namespace, id + "Type"));
        }
        return schemaType;
    }

    private XmlObject getNonDocumentObject(XmlObject obj, String id) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = obj.getClass().getMethod(this.getGetterMethod(id), new Class[0]);
        return (XmlObject)method.invoke((Object)obj, new Object[0]);
    }

    private String getGetterMethod(String id) {
        int index;
        while ((index = id.indexOf("-")) != -1) {
            id = id.substring(0, index) + StringUtil.capitalize(id.substring(index + 1));
        }
        return "get" + StringUtil.capitalize(id);
    }
}

