/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.jni.dispatch;

import com.oracle.cie.common.jni.dispatch.CPointer;

public class CFunction
extends CPointer {
    private static final int CONV_C = 0;
    private static final int CONV_JNI = 1;
    private int conv;

    private native long find(String var1, String var2);

    private static native void initIDs();

    private void translateConv(String convname) {
        if (convname.equals("C")) {
            this.conv = 0;
        } else if (convname.equals("JNI")) {
            this.conv = 1;
        } else {
            throw new IllegalArgumentException("unrecognized calling convention: " + convname);
        }
    }

    public CFunction(String lib, String fname, String conv) {
        this.translateConv(conv);
        this.peer = this.find(lib, fname);
    }

    public CFunction(String lib, String fname) {
        this.translateConv("C");
        this.peer = this.find(lib, fname);
    }

    public CFunction(CPointer ptr, String conv) {
        this.translateConv(conv);
        this.peer = ptr.peer;
    }

    public native int callInt(Object[] var1);

    public native void callVoid(Object[] var1);

    public native float callFloat(Object[] var1);

    public native double callDouble(Object[] var1);

    public native CPointer callCPointer(Object[] var1);

    private CFunction() {
    }

    static {
        CFunction.initIDs();
    }
}

