/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.logging.xml;

import com.oracle.cie.common.logging.xml.DestinationRefType;
import com.oracle.cie.common.logging.xml.LevelType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerType {
    protected List<DestinationRefType> _destinationRef;
    protected String _loggerName;
    protected LevelType _level;
    protected Boolean _useDefaultLogger;

    public LoggerType(String loggerName) {
        this._loggerName = loggerName;
    }

    public boolean addDestinationRef(DestinationRefType destRef) {
        if (this._destinationRef == null) {
            this._destinationRef = new ArrayList<DestinationRefType>();
        }
        return this._destinationRef.add(destRef);
    }

    public List<DestinationRefType> getDestinationRef() {
        return this._destinationRef;
    }

    public String getLoggerName() {
        return this._loggerName;
    }

    public LevelType getLevel() {
        return this._level;
    }

    public void setLevel(LevelType value) {
        this._level = value;
    }

    public boolean isUseDefaultLogger() {
        if (this._useDefaultLogger == null) {
            return true;
        }
        return this._useDefaultLogger;
    }

    public void setUseDefaultLogger(boolean value) {
        this._useDefaultLogger = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this._destinationRef != null) {
            for (DestinationRefType destRef : this.getDestinationRef()) {
                builder.append(" Destination Reference Name: ");
                builder.append(destRef.getName());
            }
        }
        builder.append(" Logger Name: ");
        builder.append(this.getLoggerName());
        if (this.getLevel() != null) {
            builder.append(" Level Name: ");
            builder.append(this.getLevel().name());
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._level == null ? 0 : this._level.hashCode());
        result = 31 * result + (this._loggerName == null ? 0 : this._loggerName.hashCode());
        result = 31 * result + (this._useDefaultLogger == null ? 0 : this._useDefaultLogger.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoggerType other = (LoggerType)obj;
        if (this._level != other._level) {
            return false;
        }
        if (this._loggerName == null ? other._loggerName != null : !this._loggerName.equals(other._loggerName)) {
            return false;
        }
        return !(this._useDefaultLogger == null ? other._useDefaultLogger != null : !this._useDefaultLogger.equals(other._useDefaultLogger));
    }
}

