/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.TreeFilter;
import com.oracle.cie.common.tree.TreeIterator;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import java.util.Stack;

public class DepthFirstTreeIterator
implements TreeIterator {
    private Stack<Tree> _stack = new Stack();
    private TreeFilter _filter = null;

    public DepthFirstTreeIterator(Tree t) {
        this(t, null);
    }

    public DepthFirstTreeIterator(Tree t, TreeFilter filter) {
        this._filter = filter;
        this.pushSubtrees(t);
    }

    @Override
    public boolean hasNext() {
        return !this._stack.empty();
    }

    public Object next() {
        Tree top;
        try {
            top = this._stack.pop();
            this.pushSubtrees(top);
        }
        catch (EmptyStackException esx) {
            throw new NoSuchElementException("No elements in iterator!");
        }
        return top;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("DepthFirstTreeIterator");
    }

    @Override
    public Tree peek() {
        Tree t = null;
        if (!this._stack.isEmpty()) {
            t = this._stack.peek();
        }
        return t;
    }

    private void pushSubtrees(Tree t) {
        int childCount = this._filter == null ? t.getChildCount() : this._filter.getChildCount(t);
        for (int i = childCount - 1; i >= 0; --i) {
            Tree child = this._filter == null ? t.getChild(i) : this._filter.getChild(t, i);
            this._stack.push(child);
        }
    }
}

