/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.tree;

import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.TreeFilter;
import java.util.ArrayList;
import java.util.List;

public abstract class TreeFilterAdapter
implements TreeFilter {
    @Override
    public List<Tree> getChildren(Tree parent) {
        return this.getAcceptableChildren(parent);
    }

    @Override
    public Tree getChild(Tree parent, int index) {
        int i;
        int count = 0;
        for (i = 0; i < parent.getChildCount() && index > count - 1; ++i) {
            Tree t = parent.getChild(i);
            if (!this.isAccepted(t)) continue;
            ++count;
        }
        return index == count - 1 ? parent.getChild(i - 1) : null;
    }

    @Override
    public int getChildCount(Tree t) {
        return this.getAcceptableChildCount(t);
    }

    @Override
    public int getIndexOfChild(Tree parent, Tree child) {
        int index = -1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Tree t = parent.getChild(i);
            if (!this.isAccepted(t)) continue;
            ++index;
            if (t != child) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Tree t) {
        return this.getAcceptableChildCount(t) == 0;
    }

    @Override
    public abstract boolean isAccepted(Tree var1);

    private int getAcceptableChildCount(Tree t) {
        int count = 0;
        for (int i = 0; i < t.getChildCount(); ++i) {
            Tree c = t.getChild(i);
            if (!this.isAccepted(c)) continue;
            ++count;
        }
        return count;
    }

    private List<Tree> getAcceptableChildren(Tree t) {
        ArrayList<Tree> children = new ArrayList<Tree>();
        for (int i = 0; i < t.getChildCount(); ++i) {
            Tree c = t.getChild(i);
            if (!this.isAccepted(c)) continue;
            children.add(c);
        }
        return children;
    }
}

