/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;

public class GUIUtilities {
    private static WeakHashMap s_icons = new WeakHashMap();
    public static final int MNEMONIC_INDEX_NONE = -1;
    private static final char _MNEMONIC_INDICATOR = '&';

    public static void centerOnScreen(Component c) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension cdim = c.getSize();
        int x = (dim.width - cdim.width) / 2;
        int y = (dim.height - cdim.height) / 2;
        c.setLocation(x, y);
    }

    public static void centerInParent(Component parent, Component c) {
        if (parent != null && c != null && parent.isVisible()) {
            Point topLeft = parent.getLocationOnScreen();
            Dimension parentSize = parent.getSize();
            Dimension mySize = c.getSize();
            int x = parentSize.width > mySize.width ? (parentSize.width - mySize.width) / 2 + topLeft.x : topLeft.x;
            int y = parentSize.height > mySize.height ? (parentSize.height - mySize.height) / 2 + topLeft.y : topLeft.y;
            c.setLocation(x, y);
        }
    }

    public static void sameSizeButtons(final JButton[] buttons) {
        if (buttons == null) {
            return;
        }
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setMinimumSize(null);
            buttons[i].setMaximumSize(null);
            buttons[i].setPreferredSize(null);
            maxWidth = Math.max(maxWidth, buttons[i].getPreferredSize().width);
            maxHeight = Math.max(maxHeight, buttons[i].getPreferredSize().height);
        }
        final Dimension d = new Dimension(maxWidth, maxHeight);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < buttons.length; ++i) {
                    buttons[i].setPreferredSize(d);
                    buttons[i].setMaximumSize(d);
                    buttons[i].setMinimumSize(d);
                    buttons[i].invalidate();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public static final Border makeTitledBorder(String title) {
        return GUIUtilities.makeTitledBorder(title, null, null);
    }

    public static final Border makeTitledBorder(String title, Insets insets) {
        return GUIUtilities.makeTitledBorder(title, insets, null);
    }

    public static final Border makeTitledBorder(String title, Insets insets, Font font) {
        if (insets == null) {
            insets = new Insets(3, 3, 3, 3);
        }
        return font == null ? BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), " " + title + " ", 0, 0), BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right)) : BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), " " + title + " ", 0, 0, font), BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    public static ImageIcon loadIcon(String name) {
        return GUIUtilities.loadIcon(name, null);
    }

    public static ImageIcon loadIcon(String name, ClassLoader loader) {
        ImageIcon img;
        if (loader == null) {
            loader = GUIUtilities.class.getClassLoader();
        }
        if ((img = (ImageIcon)s_icons.get(name)) == null) {
            try {
                URL url = loader.getResource(name);
                if (url != null) {
                    img = new ImageIcon(url);
                    s_icons.put(name, img);
                } else {
                    Logger.getLogger(GUIUtilities.class.getName()).severe("Unable to find icon resource: " + name);
                }
            }
            catch (Exception x) {
                Logger.getLogger(GUIUtilities.class.getName()).log(Level.SEVERE, "Unable to load icon: " + name, x);
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon loadIconFromJar(String name, File file) {
        if (name == null) {
            throw new IllegalArgumentException("Name of icon must be non-null!");
        }
        if (file == null) {
            throw new IllegalArgumentException("File must be non-null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist!");
        }
        ImageIcon icon = null;
        JarFile jar = null;
        InputStream is = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry(name);
            if (entry != null && (is = jar.getInputStream(entry)) != null) {
                icon = GUIUtilities.loadIconFromStream(name, is);
            }
        }
        catch (Exception x) {
            Logger.getLogger(GUIUtilities.class.getName()).log(Level.SEVERE, "Unable to load icon: " + name, x);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iox) {}
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iox) {}
            is = null;
            jar = null;
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon loadIconFromStream(String name, InputStream is) {
        if (name == null) {
            throw new IllegalArgumentException("Name of icon must be non-null!");
        }
        if (is == null) {
            throw new IllegalArgumentException("InputStream must be non-null!");
        }
        ImageIcon icon = null;
        ByteArrayOutputStream baos = null;
        byte[] buffer = null;
        try {
            int i;
            buffer = new byte[100000];
            baos = new ByteArrayOutputStream();
            while ((i = is.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
            icon = new ImageIcon(baos.toByteArray(), name);
            if (icon.getImageLoadStatus() != 8) {
                icon = null;
            }
        }
        catch (Exception x) {
            Logger.getLogger(GUIUtilities.class.getName()).log(Level.SEVERE, "Unable to load icon: " + name, x);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException iox) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iox) {}
            buffer = null;
            baos = null;
        }
        return icon;
    }

    public static void expandAll(JTree tree, boolean expand) {
        GUIUtilities.expandAll(tree, new TreePath(tree.getModel().getRoot()), expand);
    }

    public static void expandAll(JTree tree, TreePath parent, boolean expand) {
        Object treeNode = parent.getLastPathComponent();
        int childCount = tree.getModel().getChildCount(parent.getLastPathComponent());
        Object t = null;
        TreePath treePath = null;
        for (int i = 0; i < childCount; ++i) {
            t = tree.getModel().getChild(treeNode, i);
            treePath = parent.pathByAddingChild(t);
            GUIUtilities.expandAll(tree, treePath, expand);
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static Color colorFromHex(String value) {
        try {
            return new Color(Integer.parseInt(value, 16));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static void setButtonMnemonic(AbstractButton btn, String mnemonic) {
        GUIUtilities.setButtonMnemonic(btn, mnemonic, null);
    }

    public static void setButtonMnemonic(AbstractButton btn, String mnemonic, String mnemonicIndex) {
        if (mnemonic != null && !mnemonic.isEmpty()) {
            btn.setMnemonic(mnemonic.charAt(0));
            if (mnemonicIndex != null && !mnemonicIndex.isEmpty()) {
                try {
                    int idx = Integer.parseInt(mnemonicIndex);
                    String text = btn.getText();
                    if (idx >= 0 && idx < text.length() && mnemonic.charAt(0) == text.charAt(idx)) {
                        btn.setDisplayedMnemonicIndex(idx);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static void configureButton(AbstractButton button, String text) {
        GUIUtilities.configureButton(button, text, null);
    }

    public static void configureButton(AbstractButton button, String text, String tooltip) {
        button.setText(GUIUtilities.stripMnemonic(text));
        button.setMnemonic(GUIUtilities.getMnemonicKeyCode(text));
        button.setToolTipText(tooltip);
    }

    public static String insertMnemonic(String text, String mnemonic) {
        if (mnemonic == null || mnemonic == "") {
            return text;
        }
        int indexOfMnemonic = text.indexOf(mnemonic, 0);
        if (indexOfMnemonic >= 0) {
            text = text.substring(0, indexOfMnemonic).concat("&").concat(text.substring(indexOfMnemonic, text.length()));
        }
        return text;
    }

    public static int getMnemonicKeyCode(String text) {
        int index;
        if (text == null) {
            return 0;
        }
        int lengthMinusOne = text.length() - 1;
        int i = 0;
        while (i < lengthMinusOne && (index = text.indexOf(38, i)) != -1 && index < lengthMinusOne) {
            char ch = text.charAt(index + 1);
            if (ch != '&') {
                return Character.toUpperCase(ch);
            }
            i = index + 2;
        }
        return 0;
    }

    public static String stripMnemonic(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length <= 1) {
            return text;
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            int index = text.indexOf(38, i);
            if (index == length - 1) {
                if (buffer == null) {
                    buffer = new StringBuffer(length - 1);
                }
                buffer.append(text.substring(i, index));
                break;
            }
            if (index < 0 || index > length - 1) {
                if (buffer == null) break;
                buffer.append(text.substring(i));
                break;
            }
            if (buffer == null) {
                if (index == 0 && text.charAt(1) != '&') {
                    text = text.substring(1);
                    --length;
                    continue;
                }
                buffer = new StringBuffer(length - 1);
            }
            buffer.append(text.substring(i, index));
            buffer.append(text.charAt(index + 1));
            i = index + 2;
        }
        if (buffer == null) {
            return text;
        }
        return new String(buffer);
    }

    public static HTMLEditorKit getHTMLEditorKit(boolean boldFont) {
        Font font = UIManager.getFont("Label.font");
        HTMLEditorKit kit = (HTMLEditorKit)JTextPane.createEditorKitForContentType("text/html");
        HTMLDocument document = (HTMLDocument)kit.createDefaultDocument();
        StyleSheet styleSheet = document.getStyleSheet();
        styleSheet.addRule("body {font-size : " + font.getSize() + "; font-family :" + font.getFamily() + "; font-weight :" + (boldFont ? "bold" : "normal") + " ;}");
        kit.setStyleSheet(styleSheet);
        return kit;
    }

    public static void configureAction(Action action, String text) {
        GUIUtilities.configureAction(action, text, null, null);
    }

    public static void configureAction(Action action, String text, String tooltip, ImageIcon icon) {
        action.putValue("Name", GUIUtilities.stripMnemonic(text));
        action.putValue("MnemonicKey", GUIUtilities.getMnemonicKeyCode(text));
        action.putValue("ShortDescription", tooltip);
        action.putValue("SmallIcon", icon);
    }
}

