/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.ui.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SplashWindow {
    private ImageBackgroundPanel _imagePanel = null;
    private boolean _painted = false;

    public SplashWindow(Frame owner, URL splashImageURL, String title, String copyrightText) throws IOException, URISyntaxException {
        if (splashImageURL == null) {
            throw new IllegalArgumentException("Splash image location can't be null!");
        }
        BufferedImage splashImage = ImageIO.read(splashImageURL);
        this._imagePanel = new ImageBackgroundPanel(splashImage);
        this._imagePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel(title);
        label.setFont(new Font("Dialog", 1, 17));
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 40;
        gbc.insets.top = 80;
        gbc.insets.right = 10;
        this._imagePanel.add((Component)label, gbc);
        Font copyrightFont = new Font("SansSerif", 0, 9);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributes, copyrightFont.getFamily());
        StyleConstants.setFontSize(attributes, copyrightFont.getSize());
        StyleConstants.setAlignment(attributes, 0);
        JTextPane pane = new JTextPane();
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setContentType("text/html");
        pane.setText(copyrightText);
        StyledDocument doc = pane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attributes, true);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets.top = 16;
        gbc.insets.bottom = 16;
        this._imagePanel.add((Component)pane, gbc);
        Window window = new Window(owner);
        window.add(this._imagePanel);
        int imgWidth = splashImage.getWidth(window);
        int imgHeight = splashImage.getHeight(window);
        window.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        window.toFront();
        window.setVisible(true);
    }

    public void update(Graphics g) {
        g.setColor(this._imagePanel.getForeground());
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        this._imagePanel.paintComponent(g);
        if (!this._painted) {
            this._painted = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(URL splashImageUrl, String title, String copyrightText) {
        Frame frame = new Frame();
        SplashWindow sw = null;
        try {
            sw = new SplashWindow(frame, splashImageUrl, title, copyrightText);
        }
        catch (Exception e) {
            return frame;
        }
        if (!EventQueue.isDispatchThread()) {
            SplashWindow splashWindow = sw;
            synchronized (splashWindow) {
                while (!sw._painted) {
                    try {
                        sw.wait();
                    }
                    catch (InterruptedException ix) {}
                }
            }
        }
        return frame;
    }

    class ImageBackgroundPanel
    extends JPanel {
        Image _splashImage;

        ImageBackgroundPanel(Image image) {
            this._splashImage = image;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this._splashImage, 0, 0, this);
        }
    }
}

