/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DirectoryRestore {
    public static int s_bufferSize = 8192;
    public static final Logger s_logger = Logger.getLogger(DirectoryRestore.class.getName());

    public static void performUnZip(File zip, File directory, ZipObservable observable) throws IOException {
        DirectoryRestore.performUnZip(zip, directory, null, observable);
    }

    public static void performUnZip(File zip, File directory, List<String> entryNames, ZipObservable observable) throws IOException {
        if (zip == null || !zip.exists()) {
            throw new IllegalArgumentException("You must provide a existing valid zip file.");
        }
        directory.mkdirs();
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid extraction directory.");
        }
        List<ZipEntry> entryList = DirectoryRestore.getEntries(zip, entryNames);
        DirectoryRestore.performUnZip(entryList, zip, directory, observable);
    }

    public static void performUnZip(List<ZipEntry> entryList, File zip, File directory, ZipObservable observable) throws IOException {
        HashMap<ZipEntry, String> entryMap = new HashMap<ZipEntry, String>();
        for (ZipEntry entry : entryList) {
            entryMap.put(entry, entry.getName());
        }
        DirectoryRestore.performUnZip(entryMap, zip, directory, observable);
    }

    public static void performUnZip(Map<ZipEntry, String> entryMap, File zip, File directory, ZipObservable observable) throws IOException {
        if (entryMap == null) {
            throw new IllegalArgumentException("You must provide a list of entries.");
        }
        if (zip == null || !zip.exists()) {
            throw new IllegalArgumentException("You must provide a existing valid zip file.");
        }
        if (directory == null) {
            throw new IllegalArgumentException("You must provide a valid non-null extraction directory.");
        }
        directory.mkdirs();
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("You must provide a valid extraction directory.");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            byte[] buff = new byte[s_bufferSize];
            for (Map.Entry<ZipEntry, String> entry : entryMap.entrySet()) {
                int bytesRead;
                File f = new File(directory, entry.getValue());
                if (observable != null) {
                    observable.setChanged();
                    observable.notifyObservers(entry.getKey());
                }
                if (entry.getKey().isDirectory()) {
                    if (s_logger.isLoggable(Level.FINE)) {
                        s_logger.fine("Creating directory: " + f.getAbsolutePath());
                    }
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                InputStream is = zipFile.getInputStream(entry.getKey());
                FileOutputStream fos = new FileOutputStream(f);
                if (s_logger.isLoggable(Level.FINE)) {
                    s_logger.fine("Writing file: " + f.getAbsolutePath());
                }
                while ((bytesRead = is.read(buff)) != -1) {
                    fos.write(buff, 0, bytesRead);
                }
                fos.flush();
                fos.close();
                is.close();
            }
            if (observable != null) {
                observable.setChanged();
                observable.notifyObservers(zipFile);
            }
        }
        catch (IOException iox) {
            s_logger.log(Level.SEVERE, iox.getMessage(), iox);
            if (observable != null) {
                observable.setChanged();
                observable.notifyObservers(iox);
            }
            throw iox;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static List<ZipEntry> getEntries(File zip) {
        return DirectoryRestore.getEntries(zip, null);
    }

    public static List<ZipEntry> getEntries(File zip, List<String> entryNames) {
        if (zip == null || !zip.exists()) {
            throw new IllegalArgumentException("You must provide a zip file.");
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("Listing zip entries in: " + zip.getAbsolutePath());
        }
        ArrayList<ZipEntry> entryList = new ArrayList<ZipEntry>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            if (entryNames == null) {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry z = enumeration.nextElement();
                    entryList.add(z);
                }
            } else {
                for (String name : entryNames) {
                    entryList.add(zipFile.getEntry(name));
                }
            }
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalArgumentException("You must provide a valid zip file.");
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ioe) {}
            }
        }
        return entryList;
    }

    public static long calculateBytes(List<ZipEntry> entryList) {
        long totalBytes = 0L;
        if (entryList != null && !entryList.isEmpty()) {
            for (ZipEntry z : entryList) {
                totalBytes += z.getSize();
            }
        }
        return totalBytes;
    }

    public static class ZipObservable
    extends Observable {
        @Override
        protected void setChanged() {
            super.setChanged();
        }
    }
}

