/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileCopy {
    public static final Logger s_logger = Logger.getLogger(FileCopy.class.getName());
    public static final int MAX_COPY_BYTE_COUNT = 67076096;

    public static void copy(File from, File to) throws IOException {
        FileCopy.copy(from, to, true);
    }

    public static void copy(File from, File to, boolean mkdirs) throws IOException {
        File parent;
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.fine("File copy: " + from.getPath() + " to " + to.getPath());
        }
        if (from == null) {
            throw new NullPointerException("The source file was null.");
        }
        if (to == null) {
            throw new NullPointerException("The destination file was null.");
        }
        if (from.isDirectory()) {
            throw new IOException("The source file was a directory, FileCopy does not support directory copies.");
        }
        if (to.isDirectory()) {
            to = new File(to, from.getName());
        }
        if (mkdirs && (parent = to.getParentFile()) != null) {
            parent.mkdirs();
        }
        FileInputStream in = new FileInputStream(from);
        FileChannel fin = in.getChannel();
        FileOutputStream out = new FileOutputStream(to);
        FileChannel fout = out.getChannel();
        long size = fin.size();
        for (long position = 0L; position < size; position += fin.transferTo(position, 67076096L, fout)) {
        }
        fin.close();
        in.close();
        fout.close();
        out.close();
    }
}

