/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileLockService {
    private static final Logger _log = Logger.getLogger(FileLockService.class.getName());
    private static Map<File, FileLockHolder> _fileLockHolders = new HashMap<File, FileLockHolder>();

    public static boolean getFileLock(File file) throws IOException {
        return FileLockService._getLock(file, true, false);
    }

    public static boolean getFileLockWithLimitedWait(File file, int attempts, int waitTime) throws IOException {
        return FileLockService._getLockWithLimitedWait(file, attempts, waitTime, false);
    }

    private static boolean _getLockWithLimitedWait(File file, int attempts, int waitTime, boolean shared) throws IOException {
        try {
            boolean result = false;
            int n = attempts = attempts <= 0 ? 1 : attempts;
            while (attempts-- > 0) {
                result = FileLockService._getLock(file, false, shared);
                if (result) {
                    return true;
                }
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException ie) {
                    _log.finer("Thread was interrupted. Will start processing again");
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (OverlappingFileLockException e) {
            _log.warning(StringUtil.getStackTrace(e));
            return false;
        }
        return false;
    }

    public static boolean getFileLock(File file, boolean wait) throws IOException {
        return FileLockService._getLock(file, wait, false);
    }

    private static boolean _getLock(File file, boolean wait, boolean shared) throws IOException {
        _log.finer("Attempting to lock file: " + file + " wait: " + wait + " shared: " + shared);
        boolean result = FileLockService.getFileLockHolder(file, true).lockFile(wait, shared);
        _log.finer("File locking result for file:" + file + " result: " + result);
        return result;
    }

    public static boolean getSharedLock(File file) throws IOException {
        return FileLockService._getLock(file, true, true);
    }

    public static boolean getSharedLock(File file, boolean wait) throws IOException {
        return FileLockService._getLock(file, wait, true);
    }

    public static boolean getSharedLockWithLimitedWait(File file, int attempts, int waitTime) throws IOException {
        return FileLockService._getLockWithLimitedWait(file, attempts, waitTime, true);
    }

    public static void releaseFileLock(File file) throws IOException {
        _log.finer("Attempting to release file lock for file: " + file);
        FileLockHolder lockHolder = FileLockService.getFileLockHolder(file, false);
        if (lockHolder != null) {
            lockHolder.releaseFile();
            _log.finer("Released file lock for file: " + file);
        } else {
            _log.finer("File lock not being kept for file: " + file + ", nothing was done.");
        }
    }

    public static void resetFileLocks() throws IOException {
        _log.finer("Attempting to release all file locks");
        for (File lock : _fileLockHolders.keySet()) {
            FileLockService.releaseFileLock(lock);
        }
    }

    public static RandomAccessFile getRandomAccessFile(File file) throws IOException {
        return FileLockService.getFileLockHolder(file, true).getRandomAccessFile();
    }

    public static void closeRandomAccessFile(File file) throws IOException {
        FileLockHolder flh = FileLockService.getFileLockHolder(file, false);
        if (flh != null) {
            flh.closeRandomAccessFile();
        }
    }

    protected static synchronized FileLockHolder getFileLockHolder(File file, boolean create) {
        FileLockHolder lockHolder = _fileLockHolders.get(file);
        if (create && lockHolder == null) {
            lockHolder = new FileLockHolder(file);
            _fileLockHolders.put(file, lockHolder);
        }
        return lockHolder;
    }

    static class FileLockHolder {
        private File _file;
        private RandomAccessFile _raf;
        private FileLock _lock;

        FileLockHolder(File file) {
            this._file = file;
        }

        public File getFile() {
            return this._file;
        }

        public boolean lockFile(boolean wait) throws IOException {
            return this.lockFile(wait, false);
        }

        public synchronized boolean lockFile(boolean wait, boolean shared) throws IOException {
            if (this._lock == null || !this._lock.isValid()) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Locking file: " + this.getFile() + (shared ? " shared" : " exclusive"));
                }
                RandomAccessFile raf = this.getRandomAccessFile();
                this._lock = wait ? raf.getChannel().lock(0L, Long.MAX_VALUE, shared) : raf.getChannel().tryLock(0L, Long.MAX_VALUE, shared);
                return this._lock != null;
            }
            if (this._lock.isShared()) {
                _log.finer("This JVM already holds a shared lock on file " + this.getFile());
                if (shared) {
                    return true;
                }
                _log.warning("Can't get an exclusive lock because this JVM already holds a shared lock");
                return false;
            }
            _log.finer("This JVM already holds an exclusive lock on file " + this.getFile());
            return true;
        }

        public synchronized void releaseFile() throws IOException {
            if (this._lock != null) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Releasing lock for file: " + this.getFile());
                }
                this._lock.release();
                this._lock = null;
            }
            this.closeRandomAccessFile();
        }

        public RandomAccessFile getRandomAccessFile() throws IOException {
            if (this._raf == null) {
                File file = this.getFile();
                file.getParentFile().mkdirs();
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Creating random access file for: " + file);
                }
                this._raf = new RandomAccessFile(this.getFile(), "rw");
            }
            return this._raf;
        }

        public void closeRandomAccessFile() throws IOException {
            if (this._raf != null) {
                if (_log.isLoggable(Level.FINER)) {
                    _log.finer("Closing random access file for: " + this.getFile());
                }
                this._raf.close();
                this._raf = null;
            }
        }
    }
}

