/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.ReflectionHelper;
import com.oracle.cie.common.util.RuntimeExec;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.crlf.FixCRLF;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class JarHelper {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int UPDATE = 2;
    public static final int MERGE = 3;
    private static final Logger _logger = Logger.getLogger(JarHelper.class.getName());
    public static final String META_INF_DIR = "META-INF/";
    private JarFile _jar = null;
    private InputStream _tarArchiveInputStream = null;
    private boolean _isTarFile = false;
    private String _jarName;
    private File _jarFile;
    private int _mode;
    private Manifest _manifest = null;
    private Long _manifestTime = null;
    private JarOutputStream _jos = null;
    private BufferedOutputStream _fos = null;
    private long _current = 0L;
    private long _size = 0L;
    private boolean _closed = true;
    private boolean _preserve = false;
    private LinkedHashSet<String> _entries = null;
    private Collection<String> _contentEntries = null;
    private ArrayList<File> _extractedFiles = null;
    private final int _bufferSize = 65536;
    private final byte[] _buffer = new byte[65536];
    private final char[] _charBuffer = new char[65536];
    private File _tmpJarFile = null;
    private final String TAR_EXTENSION = ".tar";

    public JarHelper(String jarPath) throws IllegalArgumentException, IOException {
        this(new File(jarPath), 0);
    }

    public JarHelper(File jarPath) throws IllegalArgumentException, IOException {
        this(jarPath, 0);
    }

    public JarHelper(String jarPath, int mode) throws IllegalArgumentException, IOException {
        this(new File(jarPath), mode);
    }

    public JarHelper(File jarPath, int mode) throws IllegalArgumentException, IOException {
        this._jarName = jarPath.getPath();
        this._mode = mode;
        this._jarFile = jarPath;
        this.open();
    }

    public JarHelper(File jarPath, int mode, Manifest manifest) throws IllegalArgumentException, IOException {
        this(jarPath, mode, manifest, null);
    }

    public JarHelper(File jarPath, int mode, Manifest manifest, Long manifestTime) throws IllegalArgumentException, IOException {
        this._jarName = jarPath.getPath();
        this._mode = mode;
        this._jarFile = jarPath;
        this._manifest = manifest;
        this._manifestTime = manifestTime;
        this.open();
    }

    public void open() throws IllegalArgumentException, IOException {
        if (!this._closed) {
            return;
        }
        switch (this._mode) {
            case 0: {
                if (this._jarFile.exists()) {
                    this._entries = new LinkedHashSet();
                    this._extractedFiles = new ArrayList();
                    if (this._jarName.contains(".tar.") || this._jarName.endsWith(".tar")) {
                        this._isTarFile = true;
                        if (!this._jarName.endsWith(".tar")) break;
                        FileInputStream inputstream = null;
                        try {
                            inputstream = new FileInputStream(this._jarFile);
                            this._tarArchiveInputStream = (InputStream)ReflectionHelper.createObject("org.apache.commons.compress.archivers.tar.TarArchiveInputStream", new Class[]{InputStream.class}, new Object[]{inputstream}, null);
                            Object entry = ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", this._tarArchiveInputStream, "getNextTarEntry", null, null);
                            while (entry != null) {
                                String entryName = ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", entry, "getName", null, null).toString();
                                this._entries.add(entryName);
                                entry = ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", this._tarArchiveInputStream, "getNextTarEntry", null, null);
                            }
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (NoSuchMethodException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (SecurityException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (IllegalAccessException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (InvocationTargetException e) {
                            throw new IOException(e.getCause());
                        }
                        catch (InstantiationException e) {
                            throw new IOException(e.getCause());
                        }
                        finally {
                            if (inputstream != null) {
                                ((InputStream)inputstream).close();
                            }
                        }
                    }
                    this._jar = new JarFile(this._jarName);
                    Enumeration<JarEntry> e = this._jar.entries();
                    while (e.hasMoreElements()) {
                        JarEntry je = e.nextElement();
                        this._entries.add(je.getName().replace('\\', '/'));
                        this._size += je.getSize();
                    }
                    break;
                }
                throw new FileNotFoundException(this._jarName);
            }
            case 1: {
                if (!this._jarFile.exists()) {
                    this._entries = new LinkedHashSet();
                    this._fos = new BufferedOutputStream(new FileOutputStream(this._jarFile));
                    this._jos = this.getJarOutputStream();
                    break;
                }
                throw new IOException("JarFile " + this._jarName + " already exists.");
            }
            case 2: {
                if (this._jarFile.exists()) {
                    this._jar = new JarFile(this._jarName);
                    this._entries = new LinkedHashSet();
                    Enumeration<JarEntry> e = this._jar.entries();
                    while (e.hasMoreElements()) {
                        this._entries.add(e.nextElement().getName().replace('\\', '/'));
                    }
                    break;
                }
                throw new FileNotFoundException("JarFile " + this._jarName + " doesn't exist.");
            }
            case 3: {
                if (this._jarFile.exists()) {
                    this._jar = new JarFile(this._jarName);
                    this._entries = new LinkedHashSet();
                    Enumeration<JarEntry> e = this._jar.entries();
                    while (e.hasMoreElements()) {
                        this._entries.add(e.nextElement().getName().replace('\\', '/'));
                    }
                    break;
                }
                throw new FileNotFoundException("JarFile " + this._jarName + " doesn't exist.");
            }
            default: {
                throw new IllegalArgumentException(this._mode + "");
            }
        }
        this._current = 0L;
        this._closed = false;
    }

    protected JarOutputStream getJarOutputStream() throws IOException {
        if (this._manifest != null) {
            if (this._manifestTime != null) {
                return new JarHelperOutputStream(this._fos, this._manifest, this._manifestTime);
            }
            return new JarOutputStream((OutputStream)this._fos, this._manifest);
        }
        return new JarOutputStream(this._fos);
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean deleteTmpFile) {
        byte[] byArray = this._buffer;
        synchronized (this._buffer) {
            this._closed = true;
            this._entries.clear();
            this._current = 0L;
            if (this._jos != null) {
                try {
                    this._jos.close();
                }
                catch (IOException iox) {
                    // empty catch block
                }
                this._jos = null;
            }
            if (this._fos != null) {
                try {
                    this._fos.close();
                }
                catch (IOException iox) {
                    // empty catch block
                }
                this._fos = null;
            }
            if (this._jar != null) {
                try {
                    this._jar.close();
                }
                catch (IOException iox) {
                    // empty catch block
                }
                this._jar = null;
            }
            if (this._tarArchiveInputStream != null) {
                try {
                    ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveInputStream", this._tarArchiveInputStream, "close", null, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._tarArchiveInputStream = null;
            }
            if (deleteTmpFile && this._tmpJarFile != null && !this._tmpJarFile.delete()) {
                this._tmpJarFile.deleteOnExit();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setLevel(int level) throws IOException {
        if (this._mode != 1) {
            throw new IOException("Jar must be opened using WRITE mode to set compression level.");
        }
        if (this._closed) {
            this.open();
        }
        this._jos.setLevel(level);
    }

    public JarFile getJar() {
        return this._jar;
    }

    public JarEntry getJarEntry(String jarEntry) {
        return this._jar.getJarEntry(jarEntry);
    }

    public Manifest getManifest() throws IOException {
        if (this._manifest != null) {
            return this._manifest;
        }
        return this._jar.getManifest();
    }

    public InputStream getInputStream(String jarEntry) throws IOException {
        if (this._mode != 0) {
            throw new IOException("Jar must be opened using READ mode to get input stream.");
        }
        return new BufferedInputStream(this._jar.getInputStream(this.getJarEntry(jarEntry)));
    }

    public Collection<String> getEntries() {
        return this._entries;
    }

    public Collection<File> getExtractedFiles() {
        return this._extractedFiles;
    }

    public long getCurrent() {
        return this._current;
    }

    protected void setCurrent(long current) {
        this._current = current;
    }

    public void resetCurrent() {
        this.setCurrent(0L);
    }

    public long getSize() {
        return this._size;
    }

    public void setPreserve(boolean preserve) {
        this._preserve = preserve;
    }

    public void extract() throws IllegalArgumentException, IOException {
        this.extract(System.getProperty("user.dir"));
    }

    public void extract(String dir) throws IllegalArgumentException, IOException {
        this.extract(new File(dir));
    }

    public void extract(File dir) throws IllegalArgumentException, IOException {
        this.extract(dir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void extract(File dir, FileFilter filter) throws IllegalArgumentException, IOException {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("Extraction directory must exist:" + dir.getPath());
        }
        if (!this._isTarFile) {
            Iterator it = this._entries.iterator();
            while (it.hasNext()) {
                String je = (String)it.next();
                File file = new File(dir, je);
                if (filter != null && !filter.accept(file)) continue;
                this.extract(je, file);
            }
            return;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this._jarFile);
            if (!this._jarName.endsWith(".tar")) {
                File tmpTar = File.createTempFile(this._jarName, ".tar");
                tmpTar.deleteOnExit();
                Object cis = null;
                Object compressorFactory = ReflectionHelper.createObject("org.apache.commons.compress.compressors.CompressorStreamFactory", new Class[0], new Object[0], null);
                if (this._jarName.endsWith(".bz2") || this._jarName.endsWith(".bzip2")) {
                    cis = ReflectionHelper.process("org.apache.commons.compress.compressors.CompressorStreamFactory", compressorFactory, "createCompressorInputStream", new Class[]{String.class, InputStream.class}, new Object[]{"bzip2", inputStream});
                }
                if (this._jarName.endsWith(".gz")) {
                    cis = ReflectionHelper.process("org.apache.commons.compress.compressors.CompressorStreamFactory", compressorFactory, "createCompressorInputStream", new Class[]{String.class, InputStream.class}, new Object[]{"gz", inputStream});
                }
                FileOutputStream tarFOS = null;
                FilterOutputStream bos = null;
                try {
                    int i;
                    tarFOS = new FileOutputStream(tmpTar);
                    bos = new BufferedOutputStream(tarFOS);
                    byte[] byArray = this._buffer;
                    // MONITORENTER : this._buffer
                    while (!this._closed && (i = Integer.parseInt(ReflectionHelper.process("org.apache.commons.compress.compressors.CompressorStreamFactory", cis, "read", new Class[]{byte[].class}, new Object[]{this._buffer}).toString())) != -1) {
                        ((BufferedOutputStream)bos).write(this._buffer, 0, i);
                        this._current += (long)i;
                    }
                    // MONITOREXIT : byArray
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                    if (tarFOS != null) {
                        tarFOS.close();
                    }
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                inputStream = new FileInputStream(tmpTar);
            }
            this._tarArchiveInputStream = (InputStream)ReflectionHelper.createObject("org.apache.commons.compress.archivers.tar.TarArchiveInputStream", new Class[]{InputStream.class}, new Object[]{inputStream}, null);
            Object entry = ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", this._tarArchiveInputStream, "getNextTarEntry", null, null);
            while (entry != null) {
                String entryName = ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", entry, "getName", null, null).toString();
                File file = new File(dir, entryName);
                if (filter == null || filter.accept(file)) {
                    Date modTime = (Date)ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", entry, "getModTime", null, null);
                    boolean isDirectory = Boolean.parseBoolean(ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", entry, "isDirectory", null, null).toString());
                    long size = Long.parseLong(ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", entry, "getRealSize", null, null).toString());
                    this.extract(this._tarArchiveInputStream, file, false, null, modTime.getTime(), size, isDirectory);
                }
                entry = ReflectionHelper.process("org.apache.commons.compress.archivers.tar.TarArchiveEntry", this._tarArchiveInputStream, "getNextTarEntry", null, null);
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    public void extract(String jarEntry, String file) throws IllegalArgumentException, IOException {
        this.extract(this._jar.getJarEntry(jarEntry), new File(file));
    }

    public void extract(String jarEntry, String file, boolean crlf) throws IllegalArgumentException, IOException {
        this.extract(this._jar.getJarEntry(jarEntry), new File(file), crlf, null);
    }

    public void extract(String jarEntry, String file, boolean crlf, String encoding) throws IllegalArgumentException, IOException {
        this.extract(this._jar.getJarEntry(jarEntry), new File(file), crlf, encoding);
    }

    public void extract(JarEntry jarEntry, String file) throws IllegalArgumentException, IOException {
        this.extract(jarEntry, new File(file));
    }

    public void extract(JarEntry jarEntry, String file, boolean crlf) throws IllegalArgumentException, IOException {
        this.extract(jarEntry, new File(file), crlf, null);
    }

    public void extract(JarEntry jarEntry, String file, boolean crlf, String encoding) throws IllegalArgumentException, IOException {
        this.extract(jarEntry, new File(file), crlf, encoding);
    }

    public void extract(String jarEntry, File file) throws IllegalArgumentException, IOException {
        this.extract(this._jar.getJarEntry(jarEntry), file);
    }

    public void extract(String jarEntry, File file, boolean crlf) throws IllegalArgumentException, IOException {
        this.extract(this._jar.getJarEntry(jarEntry), file, crlf, null);
    }

    public void extract(String jarEntry, File file, boolean crlf, String encoding) throws IllegalArgumentException, IOException {
        this.extract(this._jar.getJarEntry(jarEntry), file, crlf, encoding);
    }

    public void extract(JarEntry jarEntry, File file) throws IllegalArgumentException, IOException {
        this.extract(jarEntry, file, false, null);
    }

    public void extract(JarEntry jarEntry, File file, boolean crlf) throws IllegalArgumentException, IOException {
        this.extract(jarEntry, file, crlf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(JarEntry jarEntry, File file, boolean crlf, String encoding) throws IllegalArgumentException, IOException {
        if (jarEntry == null) {
            throw new IllegalArgumentException("JarEntry must not be null.");
        }
        InputStream in = null;
        try {
            in = this._jar.getInputStream(jarEntry);
            this.extract(in, file, crlf, encoding, jarEntry.getTime(), jarEntry.getSize(), jarEntry.isDirectory());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iox) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void extract(InputStream in, File file, boolean crlf, String encoding, long modTime, long entrySize, boolean isDirectory) throws IllegalArgumentException, IOException {
        block46: {
            if (this._mode != 0) {
                throw new IOException("Jar must be opened using READ mode to extract.");
            }
            if (this._closed) {
                this.open();
            }
            if (in == null) {
                throw new IllegalArgumentException("JarEntry must not be null.");
            }
            if ("".equals(encoding)) {
                encoding = null;
            }
            if (encoding != null && !Charset.isSupported(encoding)) {
                throw new IllegalArgumentException("Encoding specified is not supported! " + encoding);
            }
            if (isDirectory) {
                if (file.exists()) return;
                file.mkdirs();
                if (this._preserve && modTime > 0L) {
                    file.setLastModified(modTime);
                }
                this._extractedFiles.add(file);
                return;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
                this._extractedFiles.add(file.getParentFile());
            }
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            BufferedReader isr = null;
            OutputStreamWriter osw = null;
            BufferedWriter bw = null;
            try {
                int i;
                if (crlf) {
                    FixCRLF fixcrlf = new FixCRLF();
                    fixcrlf.processStream(new BufferedInputStream(in), file, encoding);
                    this._current += entrySize;
                    break block46;
                }
                if (encoding == null) {
                    fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos);
                    byte[] fixcrlf = this._buffer;
                    // MONITORENTER : this._buffer
                } else {
                    int i2;
                    isr = new BufferedReader(new InputStreamReader(in, encoding));
                    fos = new FileOutputStream(file);
                    osw = new OutputStreamWriter((OutputStream)fos, encoding);
                    bw = new BufferedWriter(osw);
                    byte[] fixcrlf = this._buffer;
                    // MONITORENTER : this._buffer
                    while (!this._closed && (i2 = isr.read(this._charBuffer)) != -1) {
                        bw.write(this._charBuffer, 0, i2);
                    }
                    bw.flush();
                    this._current += entrySize;
                    // MONITOREXIT : fixcrlf
                    break block46;
                }
                while (!this._closed && (i = in.read(this._buffer)) != -1) {
                    bos.write(this._buffer, 0, i);
                    this._current += (long)i;
                }
                // MONITOREXIT : fixcrlf
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iox) {}
                }
                if (bos != null) {
                    try {
                        bos.flush();
                        bos.close();
                    }
                    catch (IOException iox) {}
                }
                if (fos != null) {
                    try {
                        fos.flush();
                        fos.close();
                    }
                    catch (IOException iox) {}
                }
                if (osw != null) {
                    try {
                        osw.flush();
                        osw.close();
                    }
                    catch (IOException iox) {}
                }
                if (bw != null) {
                    try {
                        bw.flush();
                        bw.close();
                    }
                    catch (IOException iox) {}
                }
            }
        }
        if (this._preserve && modTime > 0L) {
            file.setLastModified(modTime);
        }
        this._extractedFiles.add(file);
    }

    public void append(File path) throws IOException {
        this.append(path, true);
    }

    public void append(File path, boolean includeParent) throws IOException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getPath());
        }
        if (!path.isDirectory()) {
            this.append(path.getName(), path);
            return;
        }
        String dir = path.getPath().replace('\\', '/');
        int trim = includeParent ? dir.lastIndexOf("/") + 1 : dir.length() + 1;
        if (trim == -1) {
            trim = 0;
        }
        this.append(path, trim);
    }

    public void append(JarFile jar) throws IOException {
        this.append(jar, null);
    }

    public void append(JarHelper jar) throws IOException {
        this.append(jar.getJar(), null);
    }

    public void append(JarFile jar, FileFilter filter) throws IOException {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            String entryName = e.nextElement().getName();
            if (this._manifest != null && (META_INF_DIR.equals(entryName) || "META-INF/MANIFEST.MF".equals(entryName))) continue;
            final JarEntry je = new JarEntry(entryName);
            File f = new File(entryName){

                @Override
                public boolean isDirectory() {
                    return je.isDirectory();
                }

                @Override
                public boolean isFile() {
                    return !this.isDirectory();
                }
            };
            if (filter != null && !filter.accept(f)) continue;
            this.append(je, jar.getInputStream(je));
        }
    }

    private void append(File path, int trim) throws IOException {
        FileInputStream fis = null;
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    this.append(file, trim);
                }
            } else {
                JarEntry entry = new JarEntry(path.getPath().substring(trim).replace('\\', '/') + "/");
                if (this._preserve) {
                    entry.setTime(path.lastModified());
                }
                this.append(entry, (InputStream)fis);
            }
        } else {
            fis = new FileInputStream(path);
            JarEntry entry = new JarEntry(path.getPath().substring(trim).replace('\\', '/'));
            if (this._preserve) {
                entry.setTime(path.lastModified());
            }
            this.append(entry, (InputStream)fis);
        }
    }

    public void append(String jarEntry, File file) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
        JarEntry entry = new JarEntry(jarEntry);
        if (this._preserve) {
            entry.setTime(file.lastModified());
        }
        this.append(entry, (InputStream)fis);
    }

    public void append(String jarEntry, InputStream is) throws IOException {
        this.append(new JarEntry(jarEntry), is);
    }

    public void append(JarEntry jarEntry, InputStream is) throws IOException {
        String entry;
        if (this._mode != 1) {
            throw new IOException("Jar must be opened using WRITE mode to append.");
        }
        if (this._closed) {
            this.open();
        }
        if (this._entries.contains(entry = jarEntry.getName().replace('\\', '/'))) {
            return;
        }
        if (!jarEntry.isDirectory()) {
            int index;
            int prevIndex = 0;
            while ((index = entry.indexOf("/", prevIndex)) != -1) {
                String parent = entry.substring(0, index + 1);
                if (!this._entries.contains(parent)) {
                    this._entries.add(parent);
                    this.appendEntry(new JarEntry(parent), null);
                }
                prevIndex = index + 1;
            }
        }
        this._entries.add(entry);
        this.appendEntry(jarEntry, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void appendEntry(JarEntry jarEntry, InputStream is) throws IOException {
        if (this._manifest != null && "META-INF/MANIFEST.MF".equals(jarEntry.getName())) {
            throw new IOException("Cannot append META-INF/MANIFEST.MF to jar if it was explicitly defined via the JarHelper constructor.");
        }
        JarEntry newEntry = new JarEntry(jarEntry.getName());
        this._jos.putNextEntry(newEntry);
        if (!jarEntry.isDirectory()) {
            byte[] byArray = this._buffer;
            // MONITORENTER : this._buffer
            while (true) {
                int i;
                if ((i = is.read(this._buffer)) == -1) {
                    // MONITOREXIT : byArray
                    is.close();
                    this._jos.flush();
                    break;
                }
                this._jos.write(this._buffer, 0, i);
                this._current += (long)i;
            }
        }
        this._jos.closeEntry();
    }

    public void update(String jarEntry, File file) throws IOException {
        HashMap<String, File> hm = new HashMap<String, File>(1);
        hm.put(jarEntry, file);
        this.update(hm);
    }

    public void update(JarEntry jarEntry, File file) throws IOException {
        HashMap<String, File> hm = new HashMap<String, File>();
        hm.put(jarEntry.getName(), file);
        this.update(hm);
    }

    public synchronized void update(HashMap<String, File> files) throws IOException {
        if (this._mode != 2) {
            throw new IOException("Jar must be opened using UPDATE mode to update.");
        }
        if (this._closed) {
            this.open();
        }
        this._tmpJarFile = File.createTempFile("jarHelper", ".jar", this._jarFile.getParentFile());
        this._fos = new BufferedOutputStream(new FileOutputStream(this._tmpJarFile));
        this._jos = this.getJarOutputStream();
        Iterator<String> it = files.keySet().iterator();
        while (it.hasNext()) {
            String tmpEntry = it.next().replace('\\', '/');
            if (!this._entries.contains(tmpEntry)) continue;
            this._entries.remove(tmpEntry);
        }
        for (String tmpEntry : this._entries) {
            JarEntry je = this._jar.getJarEntry(tmpEntry);
            this.appendEntry(new JarEntry(je.getName()), this._jar.getInputStream(je));
        }
        for (String tmpEntry : files.keySet()) {
            File file = files.get(tmpEntry);
            if (file == null) continue;
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            JarEntry entry = new JarEntry(tmpEntry);
            if (this._preserve) {
                entry.setTime(file.lastModified());
            }
            this.appendEntry(entry, fis);
            this._entries.add(tmpEntry);
            fis.close();
        }
        boolean empty = this._entries.isEmpty();
        this.close(false);
        if (!this._jarFile.delete()) {
            this._tmpJarFile.delete();
            throw new IOException(this._jarName + " did not get updated. Unable to delete.");
        }
        if (empty) {
            this._tmpJarFile.delete();
        } else {
            this._tmpJarFile.renameTo(this._jarFile);
            this.open();
        }
    }

    public void merge(String mergeJar) throws IOException {
        this.merge(mergeJar, this._jarFile);
    }

    public void merge(File mergeJar) throws IOException {
        this.merge(mergeJar, this._jarFile);
    }

    public void merge(JarHelper mergeJar) throws IOException {
        this.merge(mergeJar, this._jarFile);
    }

    public void merge(String mergeJar, File outputJar) throws IOException {
        this.merge(new File(mergeJar), outputJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(File mergeJar, File outputJar) throws IOException {
        JarHelper jh = null;
        try {
            jh = new JarHelper(mergeJar);
            this.merge(jh, outputJar);
        }
        finally {
            if (jh != null) {
                jh.close();
            }
        }
    }

    public void merge(JarHelper mergeJar, File outputJar) throws IOException {
        this.merge(mergeJar, outputJar, null);
    }

    public void merge(JarHelper mergeJar, File outputJar, MergeConflictResolver conflictResolver) throws IOException {
        File parent;
        if (this._mode != 3) {
            throw new IOException("Jar must be opened using MERGE mode to merge jars.");
        }
        if (outputJar == null) {
            throw new IOException("The merge output jar specified was null.");
        }
        if (this._closed) {
            this.open();
        }
        if (conflictResolver == null) {
            conflictResolver = new DefaultMergeConflictResolver();
        }
        if ((parent = outputJar.getParentFile()) != null) {
            parent.mkdirs();
        }
        if (outputJar.exists()) {
            this._tmpJarFile = File.createTempFile("jarHelper", ".jar", parent);
            this._fos = new BufferedOutputStream(new FileOutputStream(this._tmpJarFile));
        } else {
            this._tmpJarFile = null;
            this._fos = new BufferedOutputStream(new FileOutputStream(outputJar));
        }
        this._jos = this.getJarOutputStream();
        ArrayList<String> existingEntries = new ArrayList<String>(this._entries);
        ArrayList<String> mergeEntries = new ArrayList<String>(mergeJar.getEntries());
        if (this._manifest != null) {
            existingEntries.remove("META-INF/MANIFEST.MF");
            existingEntries.remove(META_INF_DIR);
            mergeEntries.remove("META-INF/MANIFEST.MF");
            mergeEntries.remove(META_INF_DIR);
        }
        for (String entry : existingEntries) {
            int index = mergeEntries.indexOf(entry);
            if (index != -1) {
                InputStream is = conflictResolver.resolve(this.getJar(), mergeJar.getJar(), entry);
                if (is != null) {
                    this.appendEntry(new JarEntry(entry), is);
                }
                mergeEntries.remove(index);
                continue;
            }
            JarEntry je = this._jar.getJarEntry(entry);
            this.appendEntry(new JarEntry(entry), this._jar.getInputStream(je));
        }
        for (String mergeEntry : mergeEntries) {
            JarEntry je = mergeJar.getJar().getJarEntry(mergeEntry);
            this.appendEntry(new JarEntry(je.getName()), mergeJar.getJar().getInputStream(je));
        }
        this.close(false);
        if (outputJar.equals(new File(mergeJar.getJar().getName()))) {
            mergeJar.close();
        }
        if (this._tmpJarFile != null) {
            if (outputJar.exists() && !outputJar.delete()) {
                this._tmpJarFile.delete();
                throw new IOException(outputJar.getPath() + " did not get updated. Unable to delete existing jar.");
            }
            this._tmpJarFile.renameTo(outputJar);
        }
        this.open();
        mergeJar.open();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isClosed() {
        return this._closed;
    }

    public synchronized boolean update(File jarDirectoryStructure, String javaHome) throws IOException {
        if (this._mode != 2) {
            throw new IOException("Jar must be opened using UPDATE mode to update.");
        }
        this.close();
        boolean updated = true;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getJarLocation(javaHome));
        command.add("-uvf");
        command.add(this._jarFile.getPath());
        String[] list = jarDirectoryStructure.list();
        if (list != null && list.length > 0) {
            Collections.addAll(command, list);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream errOutput = new PrintStream(err);
        PrintStream output = new PrintStream(out);
        try {
            RuntimeExec.exec(command, null, jarDirectoryStructure, null, output, errOutput, false);
        }
        catch (Exception e) {
            throw new IOException("Failed to update jar " + this._jarFile + " using command: " + command + e.getMessage());
        }
        if (!StringUtil.isNullOrEmpty(err.toString())) {
            throw new IOException(err.toString());
        }
        for (String jarentry : jarDirectoryStructure.list()) {
            if (out.toString().contains(jarentry)) continue;
            updated = false;
        }
        return updated;
    }

    private String getJarLocation(String javaHome) throws IOException {
        String jdk = javaHome + File.separator + "..";
        if (StringUtil.isNullOrEmpty(javaHome)) {
            jdk = System.getProperty("java.home") + File.separator + "..";
        }
        String jarLoc = jdk + File.separator + "bin" + File.separator;
        jarLoc = System.getProperty("os.name").startsWith("Win") ? jarLoc + "jar.exe" : jarLoc + "jar";
        if (!new File(jarLoc).exists()) {
            throw new IOException("JDK was not provided, jar files can not be updated.");
        }
        return jarLoc;
    }

    public boolean isSignedJar() {
        this.populateConentEntries();
        return this.getEntries().size() != this._contentEntries.size();
    }

    public void populateConentEntries() {
        if (this._contentEntries == null) {
            this._contentEntries = JarHelper.getContentEntries(this.getEntries(), "", true, false);
        }
    }

    public static Collection<String> getContentEntries(Collection<String> entries, String jarFileName, boolean includeManifest, boolean diffManifest) {
        HashSet<String> signatures = new HashSet<String>();
        HashSet<String> manifestPath = new HashSet<String>();
        ArrayList<String> signedPaths = new ArrayList<String>();
        boolean sf = false;
        boolean rsa = false;
        boolean dsa = false;
        boolean ec = false;
        boolean mf = false;
        LinkedHashSet<String> contentEntries = new LinkedHashSet<String>(entries);
        for (String entry : contentEntries) {
            boolean signed = false;
            if (mf && (sf && rsa || sf && dsa || sf && ec)) break;
            if (!entry.contains(META_INF_DIR)) continue;
            if (entry.matches(".*META-INF/MANIFEST\\.MF")) {
                if (!includeManifest && !diffManifest) {
                    mf = true;
                    manifestPath.add(entry);
                }
            } else if (entry.matches(".*META-INF/.*\\.SF")) {
                sf = true;
                signed = true;
                signedPaths.add("" + entry.substring(0, entry.lastIndexOf("META-INF")));
            } else if (entry.matches(".*META-INF/.*\\.RSA")) {
                rsa = true;
                signed = true;
            } else if (entry.matches(".*META-INF/.*\\.DSA")) {
                dsa = true;
                signed = true;
            } else if (entry.matches(".*META-INF/.*\\.EC")) {
                ec = true;
                signed = true;
            }
            if (!signed) continue;
            String signature = entry.substring(entry.indexOf("/") + 1, entry.lastIndexOf("."));
            signatures.add(signature);
        }
        for (String manifest : manifestPath) {
            String manifestDirectory = manifest.substring(0, manifest.length() - "MANIFEST.MF".length());
            if (!contentEntries.remove(manifest)) {
                _logger.warning("Failed to remove manifest files " + manifest + " from " + jarFileName + " to perform carbdiff.");
            }
            contentEntries.remove(manifestDirectory);
        }
        for (String signature : signatures) {
            for (String signedPath : signedPaths) {
                if (!(contentEntries.remove(signedPath + META_INF_DIR + signature + ".RSA") || contentEntries.remove(signedPath + META_INF_DIR + signature + ".DSA") || contentEntries.remove(signedPath + META_INF_DIR + signature + ".EC"))) {
                    _logger.warning("Failed to remove signature block or it was not found at " + jarFileName);
                }
                if (contentEntries.remove(signedPath + META_INF_DIR + signature + ".SF")) continue;
                _logger.warning("Signature file not found at " + jarFileName);
            }
        }
        return contentEntries;
    }

    class JarHelperOutputStream
    extends JarOutputStream {
        public JarHelperOutputStream(OutputStream out, Manifest man, long manifestTime) throws IOException {
            super(out);
            if (man == null) {
                throw new NullPointerException("The manifest provided was null.");
            }
            ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
            e.setTime(manifestTime);
            this.putNextEntry(e);
            man.write(new BufferedOutputStream(this));
            this.closeEntry();
        }
    }

    public static class DefaultMergeConflictResolver
    implements MergeConflictResolver {
        @Override
        public InputStream resolve(JarFile destJar, JarFile mergeJar, String jarEntry) throws IOException {
            JarEntry je = mergeJar.getJarEntry(jarEntry);
            return mergeJar.getInputStream(je);
        }
    }

    public static interface MergeConflictResolver {
        public InputStream resolve(JarFile var1, JarFile var2, String var3) throws IOException;
    }
}

