/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.JRockitDetector;
import com.oracle.cie.common.util.ManifestInfo;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;

public class JdkHelper {
    public static final String HOTSPOT = "HotSpot";
    public static final String JROCKIT = "JRockit";
    public static final double JDK_VERSION_1_8 = 1.8;
    public static final String JDK_D64_OPTION = "-d64";
    public static final String JDK_MAX_PERM_SIZE_OPTION = "-XX:MaxPermSize";
    public static final String JDK_MAX_MEMORY_OPTION = "-Xmx";

    public static boolean isJavaHome(String javaHome) {
        if (javaHome == null || "".equals(javaHome)) {
            return false;
        }
        return JdkHelper.isJavaHome(new File(javaHome));
    }

    public static boolean isJRVE(String jrve) {
        if (jrve == null || "".equals(jrve)) {
            return false;
        }
        return JdkHelper.isJRVE(new File(jrve));
    }

    public static boolean isJRVE(File jrve) {
        if (jrve == null || !jrve.exists()) {
            return false;
        }
        return jrve.getAbsolutePath().endsWith("jrockitve.bin");
    }

    public static boolean isJavaHome(File javaHome) {
        File rtJar;
        if (javaHome == null || !javaHome.exists()) {
            return false;
        }
        File jreFile = javaHome;
        if (new File(javaHome, "jre").exists()) {
            jreFile = new File(javaHome, "jre");
        }
        return (rtJar = new File(jreFile, "lib/rt.jar")).exists() || (rtJar = new File(jreFile, "lib/core.jar")).exists() || new File(jreFile, "release").exists();
    }

    public static String getJdkVendor(String javaHome) {
        if (javaHome == null || "".equals(javaHome)) {
            return "Unknown";
        }
        return JdkHelper.getJdkVendor(new File(javaHome));
    }

    public static String getJdkVendor(File javaHome) {
        File rtFile;
        if (javaHome == null || !javaHome.exists()) {
            return "Unknown";
        }
        String vendor = null;
        File jreFile = javaHome;
        if (new File(javaHome, "jre").exists()) {
            jreFile = new File(javaHome, "jre");
        }
        if (!(rtFile = new File(jreFile, "/lib/rt.jar")).exists()) {
            rtFile = new File(jreFile, "/lib/core.jar");
        }
        if (rtFile.exists()) {
            try {
                if (JRockitDetector.isJrockit(javaHome.getPath())) {
                    vendor = "Oracle";
                } else {
                    JarFile rtJar = new JarFile(rtFile);
                    vendor = ManifestInfo.getAttributeValue(rtJar, "Implementation-Vendor");
                    if (vendor != null && !vendor.equals("") && vendor.indexOf(" ") != -1) {
                        vendor = vendor.substring(0, vendor.indexOf(" "));
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if ("Hewlett-Packard".equalsIgnoreCase(vendor)) {
            vendor = "HP";
        }
        return vendor == null ? "Unknown" : vendor;
    }

    public static String getVMType(File javaHome) {
        String vendor = JdkHelper.getJdkVendor(javaHome);
        if (vendor != null && vendor.equalsIgnoreCase("Oracle")) {
            if (javaHome != null && JRockitDetector.isJrockit(javaHome.getPath())) {
                return JROCKIT;
            }
            return HOTSPOT;
        }
        if (vendor != null && vendor.equalsIgnoreCase("Sun")) {
            return HOTSPOT;
        }
        return "";
    }

    public static String getJdkVersion(String javaHome) {
        if (javaHome == null || "".equals(javaHome)) {
            return "";
        }
        return JdkHelper.getJdkVersion(new File(javaHome));
    }

    public static String getJdkVersion(File javaHome) {
        File rtFile;
        if (javaHome == null || !javaHome.exists()) {
            return "";
        }
        String version = "";
        File jreFile = javaHome;
        if (new File(javaHome, "jre").exists()) {
            jreFile = new File(javaHome, "jre");
        }
        if (!(rtFile = new File(jreFile, "/lib/rt.jar")).exists()) {
            rtFile = new File(jreFile, "/lib/core.jar");
        }
        if (rtFile.exists()) {
            try {
                JarFile rtJar = new JarFile(rtFile);
                version = ManifestInfo.getAttributeValue(rtJar, "Implementation-Version");
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return version == null ? "" : version;
    }

    public static double getCurrentJavaVersion() {
        String version = System.getProperty("java.version");
        String versionPrefix = "99999999";
        String[] elements = version.split("[^0-9\\.]");
        if (elements.length > 0) {
            String[] majorMinorSecurity = elements[0].split("\\.");
            if (majorMinorSecurity.length > 1) {
                versionPrefix = majorMinorSecurity[0] + "." + majorMinorSecurity[1];
            } else if (majorMinorSecurity.length > 0) {
                versionPrefix = majorMinorSecurity[0];
            }
        }
        return Double.parseDouble(versionPrefix);
    }

    public static boolean isD64Required() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        return !(!osName.startsWith("sunos") && !osName.startsWith("solaris") && !osName.startsWith("hp") && !osName.startsWith("mac") || !osArch.contains("64") && !osArch.contains("sparcv9"));
    }

    public static boolean isMaxPermSizeSupported() {
        return JdkHelper.getCurrentJavaVersion() < 1.8;
    }
}

