/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.ICommonConstants;
import com.oracle.cie.common.util.ResourceBundleManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdkVersion {
    private static final String DEFAULT_VERSION_PATTERN = "(\\d+)[.](\\d+)(?:\\.(\\d+)(?:[._](\\d+))?)?(?:-(.+))?";
    private static Logger s_log = Logger.getLogger(JdkVersion.class.getName());
    private static Pattern s_versionPattern;
    private static int s_major_pattern_group;
    private static int s_minor_pattern_group;
    private static int s_micro_pattern_group;
    private static int s_service_pattern_group;
    private static int s_special_pattern_group;
    private boolean _valid = true;
    private int _major = 0;
    private int _minor = 0;
    private int _micro = 0;
    private int _service = 0;
    private String _special = null;
    private String _jdk = null;

    public JdkVersion(String jdk) {
        this._jdk = jdk;
        if (jdk != null) {
            Matcher m = s_versionPattern.matcher(jdk);
            if (m.matches()) {
                String group = m.group(s_major_pattern_group);
                if (group != null) {
                    try {
                        this._major = Integer.parseInt(group);
                    }
                    catch (NumberFormatException ex) {
                        s_log.log(Level.SEVERE, "Unable to parse major version", ex);
                    }
                }
                if ((group = m.group(s_minor_pattern_group)) != null) {
                    try {
                        this._minor = Integer.parseInt(group);
                    }
                    catch (NumberFormatException ex) {
                        s_log.log(Level.SEVERE, "Unable to parse minor version", ex);
                    }
                }
                if ((group = m.group(s_micro_pattern_group)) != null) {
                    try {
                        this._micro = Integer.parseInt(group);
                    }
                    catch (NumberFormatException ex) {
                        s_log.log(Level.SEVERE, "Unable to parse micro version", ex);
                    }
                }
                if ((group = m.group(s_service_pattern_group)) != null) {
                    try {
                        this._service = Integer.parseInt(group);
                    }
                    catch (NumberFormatException ex) {
                        s_log.log(Level.SEVERE, "Unable to parse service version", ex);
                    }
                }
                if ((group = m.group(s_special_pattern_group)) != null) {
                    this._special = group;
                }
            } else {
                s_log.severe("Given JDK version [" + jdk + "] doesn't match the jdk version pattern [" + s_versionPattern.pattern() + "]");
                this._valid = false;
            }
        } else {
            s_log.warning("JDK version is null.");
        }
    }

    public boolean equals(Object o) {
        String s;
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JdkVersion version = (JdkVersion)o;
        if (this._major != version.getMajor() || this._minor != version.getMinor() || this._micro != version.getMicro() || this._service != version.getService()) {
            return false;
        }
        return this._special == null || (s = version.getSpecial()) != null && this._special.equals(s);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this._major + this._minor + this._micro + this._service + (null == this._special ? 0 : this._special.hashCode());
        return hash;
    }

    public boolean greaterThan(JdkVersion version) {
        if (this._major > version.getMajor()) {
            return true;
        }
        if (this._major < version.getMajor()) {
            return false;
        }
        if (this._minor > version.getMinor()) {
            return true;
        }
        if (this._minor < version.getMinor()) {
            return false;
        }
        if (this._micro > version.getMicro()) {
            return true;
        }
        if (this._micro < version.getMicro()) {
            return false;
        }
        if (this._service > version.getService()) {
            return true;
        }
        return this._service >= version.getService();
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getMicro() {
        return this._micro;
    }

    public int getService() {
        return this._service;
    }

    public String getSpecial() {
        return this._special;
    }

    public String getJdk() {
        return this._jdk;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._major).append(".").append(this._minor).append(".").append(this._micro);
        if (this._service > 0) {
            sb.append("_");
            if (this._service < 10) {
                sb.append("0");
            }
            sb.append(this._service);
        }
        if (this._special != null) {
            sb.append("-").append(this._special);
        }
        return sb.toString();
    }

    public boolean isVersionValid() {
        return this._valid;
    }

    static {
        ResourceBundleManager.manageBundles("comdev", ICommonConstants.COMMON_BUNDLES);
        try {
            s_versionPattern = Pattern.compile(ResourceBundleManager.getString("comdev", "jdkversion.pattern"));
            s_major_pattern_group = Integer.parseInt(ResourceBundleManager.getString("comdev", "jdkversion.pattern_group.major"));
            s_minor_pattern_group = Integer.parseInt(ResourceBundleManager.getString("comdev", "jdkversion.pattern_group.minor"));
            s_micro_pattern_group = Integer.parseInt(ResourceBundleManager.getString("comdev", "jdkversion.pattern_group.micro"));
            s_service_pattern_group = Integer.parseInt(ResourceBundleManager.getString("comdev", "jdkversion.pattern_group.service"));
            s_special_pattern_group = Integer.parseInt(ResourceBundleManager.getString("comdev", "jdkversion.pattern_group.special"));
        }
        catch (Exception ex) {
            s_versionPattern = Pattern.compile(DEFAULT_VERSION_PATTERN);
            s_major_pattern_group = 1;
            s_minor_pattern_group = 2;
            s_micro_pattern_group = 3;
            s_service_pattern_group = 4;
            s_special_pattern_group = 5;
        }
    }
}

