/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.services.ClassLoaderService;
import com.oracle.cie.common.util.DirectoryBackup;
import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class LibPaths {
    private static File _lib;
    public static final Logger s_logger;

    public static List<String> getLibraryFiles(File pathname) {
        ArrayList<String> libFiles = new ArrayList<String>();
        LibPaths.populateLibFiles(pathname, libFiles);
        return libFiles;
    }

    private static void populateLibFiles(File currentFile, List<String> libFiles) {
        if (currentFile.isDirectory()) {
            for (File child : currentFile.listFiles()) {
                LibPaths.populateLibFiles(child, libFiles);
            }
        } else if (currentFile.getName().endsWith(".jar")) {
            libFiles.add(currentFile.getName());
        }
    }

    public static File getLibsPath(String ouiLib, String ouiLibariesDirectory) {
        if (_lib == null) {
            _lib = LibPaths.computeLibPath(ouiLib, ouiLibariesDirectory);
        }
        return _lib;
    }

    private static File getLibFolder(File path, final String ouiLibariesDirectory) {
        File[] libs = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname != null && pathname.isDirectory() && pathname.getName().startsWith(ouiLibariesDirectory);
            }
        });
        if (libs != null && libs.length > 0) {
            return libs[0];
        }
        return null;
    }

    private static File computeLibPath(String ouiLib, String ouiLibariesDirectory) {
        if (!StringUtil.isNullOrEmpty(ouiLib, true)) {
            return new File(ouiLib);
        }
        File path = LibPaths.getLibFolder(LibPaths.getClassJarDir(), ouiLibariesDirectory);
        if (path != null) {
            s_logger.info("Auto computing the oui library location : " + path.getAbsolutePath());
        }
        return path;
    }

    private static File getClassJarDir() {
        File ouiDir;
        File workingJar = ClassLoaderService.getInstance().locateClass(LibPaths.class);
        if (workingJar.getName().endsWith(".jar") && (ouiDir = workingJar.getParentFile()) != null) {
            return ouiDir;
        }
        return new File(System.getProperty("user.dir")).getAbsoluteFile();
    }

    static {
        s_logger = Logger.getLogger(DirectoryBackup.class.getName());
    }
}

