/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreValueNotFoundException;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ObjectStore
implements IObjectStore {
    protected final Map _map = new HashMap(100);
    protected String _namespace = "public";
    protected boolean _validating = false;
    protected IObjectStore _self = this;
    protected IObjectStore _backingStore = null;

    ObjectStore(String namespace) {
        this(namespace, null);
    }

    ObjectStore(String namespace, IObjectStore backingStore) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("Namespace must be non-null!");
        }
        this._map.putAll(System.getProperties());
        this._map.put("/", File.separator);
        this._namespace = namespace;
        this._backingStore = backingStore;
    }

    @Override
    public String getNamespace() {
        return this._namespace;
    }

    @Override
    public void setBackingStore(IObjectStore backingStore) {
        this._backingStore = backingStore;
    }

    @Override
    public IObjectStore getBackingStore() {
        return this._backingStore;
    }

    @Override
    public String substitute(String var) {
        return this.substitute(var, "$", "$");
    }

    @Override
    public String substitute(String var, String startDelim, String endDelim) {
        return this.substitute(var, startDelim, endDelim, false);
    }

    @Override
    public String substitute(String var, String startDelim, String endDelim, boolean preserveUnresolvedVariables) {
        String sub;
        if (var == null) {
            return "";
        }
        if (startDelim == null || endDelim == null) {
            return var;
        }
        int firstIndex = var.indexOf(startDelim);
        if (firstIndex == -1) {
            return var;
        }
        int secondIndex = var.indexOf(endDelim, firstIndex + startDelim.length());
        if (secondIndex == -1) {
            return var;
        }
        StringBuffer stringStart = new StringBuffer(var.substring(0, firstIndex));
        String delimVariable = var.substring(firstIndex + startDelim.length(), secondIndex);
        if (preserveUnresolvedVariables) {
            try {
                sub = this.getString(delimVariable, true);
            }
            catch (ObjectStoreValueNotFoundException e) {
                sub = startDelim + delimVariable + endDelim;
            }
        } else {
            sub = this._self.getString(delimVariable);
        }
        String stringEnd = var.substring(secondIndex + endDelim.length(), var.length());
        stringStart.append(sub);
        stringStart.append(stringEnd.indexOf(startDelim) == -1 ? stringEnd : this._self.substitute(stringEnd, startDelim, endDelim, preserveUnresolvedVariables));
        return stringStart.toString();
    }

    @Override
    public String getString(String key) {
        return this.getString(key, false);
    }

    @Override
    public String getString(String key, boolean forceValidating) {
        Object obj = this._map.get(key);
        if (obj == null && this._backingStore != null) {
            try {
                obj = this._backingStore.getString(key, forceValidating);
            }
            catch (ObjectStoreValueNotFoundException e) {
                // empty catch block
            }
        }
        if (obj == null && (this._validating || forceValidating)) {
            throw new ObjectStoreValueNotFoundException("Unable to locate object store key " + key);
        }
        return obj == null ? "" : obj.toString();
    }

    @Override
    public Object removeObject(Object key) {
        return this._map.remove(key);
    }

    @Override
    public Object retrieveObject(Object key) {
        Object obj = this._map.get(key);
        if (obj == null && this._backingStore != null) {
            obj = this._backingStore.retrieveObject(key);
        }
        if (this._validating && obj == null) {
            throw new ObjectStoreValueNotFoundException("Unable to locate object store key " + key);
        }
        return obj;
    }

    @Override
    public Object storeObject(Object key, Object value) {
        return this._map.put(key, value);
    }

    @Override
    public void storeAll(Map map) {
        this._map.putAll(map);
    }

    @Override
    public void storeNew(Map map) {
        for (Object key : map.keySet()) {
            Object value;
            Object namespaceValue = this._map.put(key, value = map.get(key));
            if (namespaceValue == null) continue;
            this._map.put(key, namespaceValue);
        }
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void setSelf(Object obj) {
        this._self = (IObjectStore)obj;
    }

    @Override
    public Iterator keyIterator() {
        if (this._backingStore == null) {
            return this._map.keySet().iterator();
        }
        final Iterator myIterator = this._map.keySet().iterator();
        return new Iterator(){
            private Iterator[] _itArr;
            private int _current;
            {
                this._itArr = new Iterator[]{myIterator, ObjectStore.this._backingStore.keyIterator()};
                this._current = 0;
            }

            @Override
            public boolean hasNext() {
                return this._itArr[this._current].hasNext() || this._current < this._itArr.length - 1 && this._itArr[++this._current].hasNext();
            }

            public Object next() {
                try {
                    return this._itArr[this._current].next();
                }
                catch (NoSuchElementException nse) {
                    if (this._current < this._itArr.length - 1) {
                        return this._itArr[++this._current].next();
                    }
                    throw nse;
                }
            }

            @Override
            public void remove() {
                this._itArr[this._current].remove();
            }
        };
    }

    @Override
    public void setValidating(boolean validate) {
        this._validating = validate;
    }
}

