/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.ResourceBundleManager;
import java.text.MessageFormat;

public class PublishedMessage {
    private static String _htmlPattern;
    private String _prefix;
    private String _code;
    private Type _type;
    private String _name;
    private String _text;
    private String _cause;
    private String _action;
    private String _category;
    private int _level;
    private boolean _documented;
    private Object[] _params;

    protected static String getHTMLPattern() {
        if (_htmlPattern == null && (_htmlPattern = ResourceBundleManager.getString("comdev", "PublishedMessage.htmlFormat.pattern")) == null) {
            _htmlPattern = "";
        }
        return _htmlPattern.isEmpty() ? null : _htmlPattern;
    }

    public PublishedMessage(String prefix, String code, Type type, String name, String text, String cause, String action) {
        this(prefix, code, type, name, text, cause, action, "Configuration", 1, false);
    }

    public PublishedMessage(String prefix, String code, Type type, String name, String text, String cause, String action, String category, int level, boolean documented) {
        this._prefix = prefix;
        this._code = code;
        this._type = type;
        this._name = name;
        this._text = text;
        this._cause = cause;
        this._action = action;
        this._category = category;
        this._level = level;
        this._documented = documented;
    }

    public void setParams(Object ... params) {
        this._params = params;
    }

    public String getMessageId() {
        return this._prefix == null ? this._code : this._prefix + "-" + this._code;
    }

    public String getMessageText() {
        StringBuilder messageText = new StringBuilder(this.getMessageId()).append(": ");
        if (this._text != null && !this._text.isEmpty() && this._params != null && this._params.length > 0) {
            try {
                messageText.append(MessageFormat.format(this._text, this._params)).toString();
            }
            catch (IllegalArgumentException e) {
                messageText.append(this._text).toString();
            }
        } else {
            messageText.append(this._text).toString();
        }
        return messageText.toString();
    }

    public String getSubstitutedText() {
        return this.getSubstituted(this._text);
    }

    public String getSubstitutedCause() {
        return this.getSubstituted(this._cause);
    }

    public String getSubstitutedAction() {
        return this.getSubstituted(this._action);
    }

    private String getSubstituted(String text) {
        if (text == null || text.isEmpty() || this._params == null || this._params.length == 0) {
            return text;
        }
        try {
            return MessageFormat.format(text, this._params);
        }
        catch (IllegalArgumentException ex) {
            return text;
        }
    }

    public String getFullMessage() {
        StringBuilder sb = new StringBuilder(this.getMessageText());
        sb.append('\n').append(this.getMessageId()).append(": ").append(this.getSubstitutedCause());
        sb.append('\n').append(this.getMessageId()).append(": ").append(this.getSubstitutedAction());
        return sb.toString();
    }

    public String getFullMessage(String htmlPattern) {
        if (htmlPattern != null) {
            try {
                return MessageFormat.format(htmlPattern, this.getMessageId(), this.getSubstitutedText(), this.getSubstitutedCause(), this.getSubstitutedAction());
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder("<html><b>");
        sb.append(this.getMessageText()).append("<br/>CAUSE: </b> ");
        sb.append(this.getSubstitutedCause()).append("<br/><b>ACTION: </b>");
        sb.append(this.getSubstitutedAction());
        return sb.toString();
    }

    public String getFullHTMLMessage() {
        if (PublishedMessage.getHTMLPattern() != null) {
            try {
                return MessageFormat.format(PublishedMessage.getHTMLPattern(), this.getMessageId(), this.getSubstitutedText(), this.getSubstitutedCause(), this.getSubstitutedAction());
            }
            catch (Throwable ex) {
                _htmlPattern = "";
            }
        }
        StringBuilder sb = new StringBuilder("<html><b>");
        sb.append(this.getMessageText()).append("</b><br>\n");
        sb.append("&nbsp;&nbsp;").append(this.getSubstitutedCause()).append("<br>\n");
        sb.append("&nbsp;&nbsp;").append(this.getSubstitutedAction());
        return sb.toString();
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getCode() {
        return this._code;
    }

    public Type getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getText() {
        return this._text;
    }

    public String getCause() {
        return this._cause;
    }

    public String getAction() {
        return this._action;
    }

    public String getCategory() {
        return this._category;
    }

    public int getLevel() {
        return this._level;
    }

    public boolean isDocumented() {
        return this._documented;
    }

    public Object[] getParams() {
        return this._params == null ? new Object[]{} : this._params;
    }

    public static enum Type {
        TRACE,
        NOTIFICATION,
        WARNING,
        ERROR,
        FAULT;

    }
}

