/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class WildcardFileFilter
implements FileFilter {
    private ArrayList _wildcards = new ArrayList();
    private boolean _recurse = true;
    private boolean _matchDirectories = false;

    public WildcardFileFilter(String wildcards) {
        this(wildcards, true);
    }

    public WildcardFileFilter(String wildcards, boolean recurse) {
        this.setVars(wildcards);
        this._recurse = recurse;
    }

    public WildcardFileFilter(String[] wildcards) {
        this.setVars(wildcards);
    }

    public void setMatchDirectories(boolean match) {
        this._matchDirectories = match;
    }

    public void addDef(String def) {
        this._wildcards.add(this.getDef(def));
    }

    private void setVars(String wildcards) {
        if (wildcards.indexOf(",") != -1) {
            StringTokenizer toke = new StringTokenizer(wildcards, ",");
            while (toke.hasMoreTokens()) {
                this.addDef(toke.nextToken());
            }
        } else {
            this.addDef(wildcards);
        }
    }

    private void setVars(String[] wildcards) {
        for (int i = 0; i < wildcards.length; ++i) {
            this.addDef(wildcards[i]);
        }
    }

    private WildcardFilterDef getDef(String wildcard) {
        String after;
        String before;
        int index = wildcard.indexOf("*");
        if (index == -1) {
            before = null;
            after = null;
        } else {
            before = wildcard.substring(0, index);
            after = wildcard.substring(index + 1, wildcard.length());
            if (before.equals("")) {
                before = null;
            }
            if (after.equals("")) {
                after = null;
            }
        }
        return new WildcardFilterDef(wildcard, before, after);
    }

    @Override
    public boolean accept(File file) {
        String name;
        if (file.isDirectory()) {
            if (this._recurse && !this._matchDirectories) {
                return true;
            }
            if (!this._recurse) {
                return false;
            }
        }
        if ((name = file.getName()).equals("")) {
            return false;
        }
        for (int x = 0; x < this._wildcards.size(); ++x) {
            WildcardFilterDef wdef = (WildcardFilterDef)this._wildcards.get(x);
            if (!(wdef._before == null && wdef._after == null ? wdef._wildcard.equals("*") || name.equals(wdef._wildcard) : (wdef._before != null && wdef._after != null ? name.startsWith(wdef._before) && name.endsWith(wdef._after) : (wdef._before != null ? name.startsWith(wdef._before) : wdef._after != null && name.endsWith(wdef._after))))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this._wildcards != null && this._wildcards.size() > 0) {
            StringBuffer sb = new StringBuffer();
            WildcardFilterDef wdef = (WildcardFilterDef)this._wildcards.get(0);
            sb.append(wdef._wildcard);
            for (int x = 1; x < this._wildcards.size(); ++x) {
                wdef = (WildcardFilterDef)this._wildcards.get(x);
                sb.append("," + wdef._wildcard);
            }
            return sb.toString();
        }
        return "";
    }

    class WildcardFilterDef {
        public String _wildcard = null;
        public String _before = null;
        public String _after = null;

        public WildcardFilterDef(String wildcard, String before, String after) {
            this._wildcard = wildcard;
            this._before = before;
            this._after = after;
        }
    }
}

