/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingConfig {
    String log_file_location;
    String default_level;
    List<Logger> root_logger = new ArrayList<Logger>();
    List<Property> log_file_name = new ArrayList<Property>();
    private static final boolean _debug = EnvironmentUtil.isDebugMode();

    public String getLogFileLocation() {
        return this.log_file_location;
    }

    public void setLogFileLocation(String in) {
        this.log_file_location = in;
    }

    public String getDefaultLevel() {
        return this.default_level;
    }

    public void setDefaultLevel(String in) {
        this.default_level = in;
    }

    public List<Logger> getRootLoggers() {
        return this.root_logger;
    }

    public Logger getNewLogger() {
        Logger logger = new Logger();
        if (this.root_logger == null) {
            this.root_logger = new ArrayList<Logger>();
        }
        this.root_logger.add(logger);
        return logger;
    }

    public List<Property> getProperties() {
        return this.log_file_name;
    }

    public Property getNewProperty() {
        Property prop = new Property();
        if (this.log_file_name == null) {
            this.log_file_name = new ArrayList<Property>();
        }
        this.log_file_name.add(prop);
        return prop;
    }

    public void printToSystemOut() {
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "LoggingConfig "));
        LogFactory.addLogRecord(new LogRecord(Level.INFO, " default-level = " + this.getDefaultLevel()));
        LogFactory.addLogRecord(new LogRecord(Level.INFO, " log-file-location = " + this.getLogFileLocation()));
        if (this.getProperties() != null) {
            for (Property p : this.getProperties()) {
                System.out.println(p);
            }
        }
        if (this.getRootLoggers() != null) {
            for (Logger l : this.getRootLoggers()) {
                System.out.println(l);
            }
        }
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "end of LoggingConfig "));
    }

    public boolean validate() {
        if (this.getRootLoggers() == null || this.getRootLoggers().isEmpty()) {
            if (_debug) {
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG Invalid config: none of loggers are configured! "));
            }
            return false;
        }
        return true;
    }

    public class Property {
        String invoked_by_method;
        String invoked_by_class;
        String file_name;

        public String getInvokedByMethod() {
            return this.invoked_by_method;
        }

        public void setInvokedByMethod(String in) {
            this.invoked_by_method = in;
        }

        public String getInvokedByClass() {
            return this.invoked_by_class;
        }

        public void setInvokedByClass(String in) {
            this.invoked_by_class = in;
        }

        public String getFileName() {
            return this.file_name;
        }

        public void setFileName(String in) {
            this.file_name = in;
        }

        public boolean isAnythingMissing() {
            if (this.invoked_by_method == null || this.invoked_by_class == null || this.file_name == null) {
                return true;
            }
            return this.invoked_by_method.trim().length() == 0 || this.invoked_by_class.trim().length() == 0 || this.file_name.trim().length() == 0;
        }

        public boolean isMain() {
            if (this.isAnythingMissing()) {
                return false;
            }
            return "main".equals(this.invoked_by_method);
        }

        public boolean isCaller() {
            if (this.isAnythingMissing()) {
                return false;
            }
            return !"main".equals(this.invoked_by_method);
        }

        public boolean isDefault() {
            return !(this.invoked_by_method != null && this.invoked_by_method.trim().length() != 0 || this.invoked_by_class != null && this.invoked_by_class.trim().length() != 0 || this.file_name == null || this.file_name.trim().length() == 0);
        }

        public String toString() {
            String type = "invalid";
            if (this.isMain()) {
                type = "main";
            }
            if (this.isCaller()) {
                type = "caller";
            }
            if (this.isDefault()) {
                type = "default";
            }
            return " property:" + type + " invoked_by_class= " + this.invoked_by_class + " invoked_by_method= " + this.invoked_by_method + " file_name=" + this.file_name;
        }
    }

    public class Destination {
        String level = null;
        String destination = null;

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String in) {
            this.level = in;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String in) {
            this.destination = in;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Logger {
        String name = null;
        List<Destination> level_destination = null;

        public String getName() {
            return this.name;
        }

        public void setName(String in) {
            this.name = in;
        }

        public List<Destination> getDestinations() {
            return this.level_destination;
        }

        public Destination getNewDestination() {
            Destination dest = new Destination();
            if (this.level_destination == null) {
                this.level_destination = new ArrayList<Destination>();
            }
            this.level_destination.add(dest);
            return dest;
        }

        public String toString() {
            StringBuilder out = new StringBuilder(" LoggingConfig.Logger: name= ");
            out.append(this.name).append("  destination-levels: ");
            for (Destination d : this.level_destination) {
                out.append("\n    destination= ").append(d.destination).append(" level= ").append(d.level);
            }
            return out.toString();
        }
    }
}

