/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.jackson;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.oracle.cie.common.util.reporting.CommonReporter;
import com.oracle.cie.common.util.reporting.ReportLevel;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.ReporterTypes;
import com.oracle.cie.common.util.reporting.jackson.ObjectMapperFactory;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JacksonReporter
extends CommonReporter {
    private static final Logger _log = Logger.getLogger(JacksonReporter.class.getName());
    private ObjectWriter _objectWriter;

    public JacksonReporter(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public ReporterType getType() {
        return ReporterTypes.jackson;
    }

    protected synchronized String writeObject(Object object) {
        if (this._objectWriter == null) {
            try {
                this.configureGenerator();
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Failed to configure jackson generator.", e);
            }
        }
        if (this._objectWriter != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this._objectWriter.writeValue((OutputStream)baos, object);
                return baos.toString();
            }
            catch (IOException e) {
                _log.log(Level.WARNING, "Failed to write report message via jackson reporter.", e);
            }
        }
        return null;
    }

    @Override
    protected String writeReportMessage(ReportLevel level, ReportMessage reportMessage) {
        return this.writeObject(reportMessage);
    }

    @Override
    protected String writeReport(ReportLevel level, Report report) {
        return this.writeObject(report);
    }

    private synchronized void configureGenerator() throws IOException {
        if (this._objectWriter == null) {
            this._objectWriter = this.isFormatOutput() ? ObjectMapperFactory.getObjectMapper().writer(SerializationFeature.INDENT_OUTPUT) : ObjectMapperFactory.getObjectMapper().writer();
        }
    }

    @Override
    public synchronized void setFormatOutput(boolean formatOutput) {
        if (this._objectWriter != null && this.isFormatOutput() ^ formatOutput) {
            this._objectWriter = null;
        }
        super.setFormatOutput(formatOutput);
    }
}

