/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.jaxb;

import com.oracle.cie.common.util.reporting.CommonReporter;
import com.oracle.cie.common.util.reporting.ReportLevel;
import com.oracle.cie.common.util.reporting.ReporterType;
import com.oracle.cie.common.util.reporting.ReporterTypes;
import com.oracle.cie.common.util.reporting.jaxb.messages.CompletionWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.InitiationWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.MessageWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.ProgressWrapper;
import com.oracle.cie.common.util.reporting.jaxb.messages.ReportWrapper;
import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.namespace.QName;

public class JaxbReporter
extends CommonReporter {
    private static final Logger _log = Logger.getLogger(JaxbReporter.class.getName());
    private static Marshaller _marshaller;

    public JaxbReporter(OutputStream out) {
        super(out);
    }

    @Override
    public ReporterType getType() {
        return ReporterTypes.jaxb;
    }

    @Override
    protected String writeReportMessage(ReportLevel level, ReportMessage reportMessage) {
        if (_marshaller == null) {
            this.configureMarshaller();
        }
        if (reportMessage != null) {
            try {
                JAXBElement root;
                switch (reportMessage.getType()) {
                    case initiation: {
                        QName qName = new QName("", "initiation");
                        root = new JAXBElement(qName, InitiationWrapper.class, (Object)new InitiationWrapper((Initiation)reportMessage));
                        break;
                    }
                    case message: {
                        QName qName = new QName("", "message");
                        root = new JAXBElement(qName, MessageWrapper.class, (Object)new MessageWrapper((Message)reportMessage));
                        break;
                    }
                    case progress: {
                        QName qName = new QName("", "progress");
                        root = new JAXBElement(qName, ProgressWrapper.class, (Object)new ProgressWrapper((Progress)reportMessage));
                        break;
                    }
                    case completion: {
                        QName qName = new QName("", "completion");
                        root = new JAXBElement(qName, CompletionWrapper.class, (Object)new CompletionWrapper((Completion)reportMessage));
                        break;
                    }
                    default: {
                        _log.log(Level.WARNING, "Report message was an unsupported type: " + reportMessage);
                        return null;
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                _marshaller.marshal((Object)root, (OutputStream)baos);
                return baos.toString();
            }
            catch (JAXBException e) {
                _log.log(Level.WARNING, "Failed to write report message via jaxb reporter.", e);
            }
        }
        return null;
    }

    @Override
    protected String writeReport(ReportLevel level, Report report) {
        if (_marshaller == null) {
            this.configureMarshaller();
        }
        if (report != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                _marshaller.marshal((Object)new ReportWrapper(report), (OutputStream)baos);
                return baos.toString();
            }
            catch (JAXBException e) {
                _log.log(Level.WARNING, "Failed to write report message via jaxb reporter.", e);
            }
        }
        return null;
    }

    private synchronized void configureMarshaller() {
        if (_marshaller == null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ReportWrapper.class});
                _marshaller = context.createMarshaller();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Failed to configure jaxb marshaller.", e);
            }
        }
        if (this.isFormatOutput()) {
            try {
                _marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (PropertyException e) {
                // empty catch block
            }
        }
        try {
            _marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }
}

