/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.di;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.utils.OraparamException;

public class Property
extends AbstractDataHandlerWrapper {
    public Property(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Property(String name) {
        super(DistributionInfoHelper.getInstance().create("property"));
        this.setName(name);
    }

    public void setName(String value) {
        this.setAttribute("name", value);
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    private String getValueAttribute() {
        return this.getStringAttribute("valueAttribute");
    }

    public void setValues(String[] values) {
        this.getDataHandler().setSimpleValue("value", values);
    }

    public String getValue() {
        String values = "";
        IDataHandler[] valueList = this.getDataHandler().getComplexValue("value");
        if (valueList.length == 0) {
            values = this.getValueAttribute();
        } else {
            for (IDataHandler value : valueList) {
                String val = value.getObject().toString();
                val = val.replaceAll("\r\n|\r|\n", " ");
                val = val.replaceAll("\t", "");
                val = val.trim();
                values = values + val + ",";
            }
            values = values.substring(0, values.lastIndexOf(","));
        }
        return values;
    }

    public boolean equals(Object p) {
        if (this == p) {
            return true;
        }
        if (p == null || !p.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        Property property = (Property)p;
        String name = this.getName();
        String theirName = property.getName();
        return !(name != null ? !name.equals(theirName) : theirName != null);
    }

    public int hashCode() {
        return 31 * (this.getName() != null ? this.getName().hashCode() : 0);
    }

    public void validate() throws OraparamException {
        IDataHandler[] valueList;
        if (StringUtil.isNullOrEmpty(this.getName())) {
            throw new OraparamException("Property name must be set at " + this);
        }
        if (this.getDataHandler().getComplexValue("value").length == 0 && StringUtil.isNullOrEmpty(this.getValueAttribute())) {
            throw new OraparamException("Property value must be set for " + this.getName());
        }
        for (IDataHandler value : valueList = this.getDataHandler().getComplexValue("value")) {
            if (!StringUtil.isNullOrEmpty(value.getObject().toString())) continue;
            throw new OraparamException("Property value must be set for " + this.getName());
        }
    }
}

