/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.dao.cpi.ComponentInfo;
import com.oracle.cie.gdr.dao.cpi.FileMapTarget;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.gdr.helpers.LocaleInfoHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.OraparamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ComponentInfoHelper
extends DaoHelper<ComponentInfo> {
    private static final Logger _log = Logger.getLogger(ComponentInfoHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/cpi";
    public static final String COMPONENT_INFO = "component-info";
    public static final String COMPONENT_INFO_DIR = "components/info";
    private static final ComponentInfoHelper _instance = new ComponentInfoHelper();

    public static ComponentInfoHelper getInstance() {
        return _instance;
    }

    private ComponentInfoHelper() {
        super(ComponentInfo.class);
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getRootElement() {
        return COMPONENT_INFO;
    }

    @Override
    public String getPath() {
        return COMPONENT_INFO_DIR;
    }

    public ComponentInfo getComponentInfo(File metaDataHome, String componentName, String componentVersion) throws GdrException {
        try {
            return this.getComponentInfo(this.getComponentInfoFile(metaDataHome, componentName, componentVersion));
        }
        catch (FileNotFoundException e) {
            throw new GdrException("Unable to locate component-info file for " + componentName + " " + componentVersion + " under " + metaDataHome, e);
        }
    }

    public ComponentInfo getComponentInfo(File componentInfoFile) throws GdrException {
        return this.getComponentInfo(componentInfoFile, true);
    }

    public ComponentInfo getComponentInfo(File componentInfoFile, boolean validateFileName) throws GdrException {
        ComponentInfo componentInfo;
        if (componentInfoFile == null) {
            throw new OraparamException("The component info file specified was null.");
        }
        try {
            componentInfo = (ComponentInfo)this.getRootWrapper(componentInfoFile);
        }
        catch (FileNotFoundException e) {
            throw new GdrException("Unable to locate component-info file " + componentInfoFile, e);
        }
        catch (IOException e) {
            throw new GdrException("Unable read component-info file " + componentInfoFile, e);
        }
        catch (DataHandlerException e) {
            throw new GdrException("Unable to parse component-info file " + componentInfoFile, e);
        }
        this.validateComponentInfo(componentInfo, componentInfoFile, validateFileName);
        return componentInfo;
    }

    public void validateComponentInfo(ComponentInfo componentInfo, File componentInfoFile, boolean validateFileName) throws GdrException {
        if (componentInfo == null) {
            throw new GdrException("The component info was null.");
        }
        if (validateFileName && !componentInfoFile.getName().equals(this.getComponentInfoFileName(componentInfo))) {
            GdrException ex = new GdrException("The internal component info name and version is incorrect.  File name should be: " + this.getComponentInfoFileName(componentInfo) + " File name is: " + componentInfoFile.getName());
            _log.throwing(ComponentInfoHelper.class.getName(), "validateComponentInfo", ex);
            throw ex;
        }
        List<FileMapTarget> targets = componentInfo.getFileMapTargets();
        boolean allEmpty = true;
        if (targets != null && !targets.isEmpty()) {
            Set<String> locales;
            Set<String> platforms;
            for (FileMapTarget target : targets) {
                platforms = target.getPlatforms();
                for (String platform : platforms) {
                    if (PlatformInfoHelper.getInstance().isSupportedPlatformOrGroup(platform)) continue;
                    GdrException ex = new GdrException("Encountered unsupported platform or group value " + platform + " in component info " + componentInfoFile);
                    _log.throwing(ComponentInfoHelper.class.getName(), "validateComponentInfo", ex);
                    throw ex;
                }
                locales = target.getLocales();
                for (String locale : locales) {
                    if (LocaleInfoHelper.getInstance().isSupportedLocale(locale)) continue;
                    GdrException ex = new GdrException("Encountered unsupported locale value " + locale + " in component info " + componentInfoFile);
                    _log.throwing(ComponentInfoHelper.class.getName(), "validateComponentInfo", ex);
                    throw ex;
                }
            }
            for (FileMapTarget target : targets) {
                platforms = target.getPlatforms();
                locales = target.getLocales();
                if (platforms.isEmpty() && locales.isEmpty()) continue;
                allEmpty = false;
                break;
            }
        }
        if (allEmpty && !componentInfo.isGeneric()) {
            GdrException ex = new GdrException("The component info was not generic and contained no target values: " + componentInfo);
            _log.throwing(ComponentInfoHelper.class.getName(), "validateComponentInfo", ex);
            throw ex;
        }
    }

    public String getComponentInfoFileName(ComponentInfo componentInfo) {
        return this.getComponentInfoFileName(componentInfo.getName(), componentInfo.getVersion());
    }

    public String getComponentInfoFileName(String name, String version) {
        return name.replaceAll(" ", "_") + "_" + version + ".xml";
    }

    public File getComponentInfoFile(File metadataHome, String name, String version) throws FileNotFoundException {
        return this.getComponentInfoPath(NioHelper.getInstance().getPath(metadataHome), name, version).toFile();
    }

    public Path getComponentInfoPath(Path metadataHome, String name, String version) throws FileNotFoundException {
        return this.getFileLocatorService(metadataHome).getPath(this.getPath(), this.getComponentInfoFileName(name, version));
    }

    public List<File> getComponentInfoFiles(File metaDataDir) {
        List<Path> paths = this.getComponentInfoPaths(NioHelper.getInstance().getPath(metaDataDir));
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public List<Path> getComponentInfoPaths(Path metaDataDir) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (metaDataDir != null && Files.isDirectory(metaDataDir, new LinkOption[0])) {
            paths.addAll(this.getFileLocatorService(metaDataDir).getPathsUnderPath(this.getPath()));
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".xml")) continue;
                it.remove();
            }
        }
        return paths;
    }
}

