/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.pli.Alias;
import com.oracle.cie.gdr.dao.pli.Group;
import com.oracle.cie.gdr.dao.pli.Platform;
import com.oracle.cie.gdr.dao.pli.PlatformInfo;
import com.oracle.cie.gdr.dao.pli.PlatformProperties;
import com.oracle.cie.gdr.helpers.DaoHelper;
import com.oracle.cie.gdr.platform.GroupInfoHolder;
import com.oracle.cie.gdr.platform.InfoHolder;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import com.oracle.cie.gdr.services.EncodingService;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformInfoHelper
extends DaoHelper<PlatformInfo> {
    private static final Logger _log = Logger.getLogger(PlatformInfoHelper.class.getName());
    public static final String NAMESPACE = "http://xmlns.oracle.com/cie/gdr/pli";
    public static final String PLATFORM_INFO = "platform-info";
    public static final String PLATFORM_INFO_FILE_NAME = "platform-info.xml";
    public static final String PLATFORM_INFO_RESOURCE = "/resources/platform-info.xml";
    public static final String PLATFORM_INFO_LOCATION_PROPERTY = "platform.info.xml.location";
    public static final String CURRENT_PLATFORM_PROPERTY = "oracle.installer.platform";
    public static final int UNKNOWN_PLATFORM = 0;
    public static final int WINDOWS_GROUP = -3;
    public static final int GENERIC = 2000;
    public static final String ALL_PLATFORMS = "ALL_PLATFORMS";
    public static final String[] INVALID_NAME_CHARACTERS = new String[]{"."};
    public static final String PLATFORM_ENCODING_PREFIX = "p_";
    private static final PlatformInfoHelper _instance = new PlatformInfoHelper();
    private Map<Integer, PlatformInfoHolder> _platformInfoHolders;
    private Map<Integer, GroupInfoHolder> _groupInfoHolders;
    private static int _currentId = -1;

    public static PlatformInfoHelper getInstance() {
        return _instance;
    }

    private PlatformInfoHelper() {
        super(PlatformInfo.class);
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getRootElement() {
        return PLATFORM_INFO;
    }

    @Override
    public String getPath() {
        return "";
    }

    public PlatformInfo getPlatformInfo(File platformInfoFile) throws IOException, DataHandlerException, GdrException {
        if (platformInfoFile == null || !platformInfoFile.isFile()) {
            GdrException ex = new GdrException("Platform info file specified was invalid: " + platformInfoFile);
            _log.throwing(PlatformInfoHelper.class.getName(), "getPlatformInfo", ex);
            throw ex;
        }
        PlatformInfo platformInfo = (PlatformInfo)this.getRootWrapper(platformInfoFile);
        this.validatePlatformInfo(platformInfo);
        return platformInfo;
    }

    public PlatformInfo getPlatformInfo() throws IOException, DataHandlerException, GdrException {
        String infoLocation = System.getProperty(PLATFORM_INFO_LOCATION_PROPERTY);
        if (infoLocation == null) {
            return this.getPlatformInfo(PlatformInfoHelper.class.getResourceAsStream(PLATFORM_INFO_RESOURCE));
        }
        File platformInfoFile = new File(infoLocation);
        return this.getPlatformInfo(platformInfoFile);
    }

    public PlatformInfo getPlatformInfo(InputStream is) throws IOException, DataHandlerException, GdrException {
        if (is == null) {
            GdrException ex = new GdrException("Platform info input stream specified was invalid.");
            _log.throwing(PlatformInfoHelper.class.getName(), "getPlatformInfo", ex);
            throw ex;
        }
        PlatformInfo platformInfo = (PlatformInfo)this.getRootWrapper(is);
        this.validatePlatformInfo(platformInfo);
        return platformInfo;
    }

    private void validatePlatformInfo(PlatformInfo platformInfo) throws GdrException {
        List<Group> groups;
        if (platformInfo == null) {
            throw new GdrException("The platform info was null.");
        }
        List<Platform> platforms = platformInfo.getPlatforms();
        if (platforms != null && !platforms.isEmpty()) {
            for (Platform platform : platforms) {
                ArrayList<Platform> tmpPlatforms = new ArrayList<Platform>(platforms);
                tmpPlatforms.remove(platform);
                for (String platformName : this.getPlatformNames(platform)) {
                    this.validateName(platformName, platform);
                    for (Platform p : tmpPlatforms) {
                        for (String pn : this.getPlatformNames(p)) {
                            if (!platformName.equalsIgnoreCase(pn)) continue;
                            throw new GdrException("Platform names and aliases must be unique (case insensitive) " + platform + " : " + p);
                        }
                    }
                }
            }
        }
        if ((groups = platformInfo.getGroups()) != null && !groups.isEmpty()) {
            Iterator<Group> it = groups.iterator();
            while (it.hasNext()) {
                Group group = it.next();
                it.remove();
                String name = group.getName();
                this.validateName(name, group);
                for (Group g : groups) {
                    if (!name.equalsIgnoreCase(g.getName())) continue;
                    throw new GdrException("Group names must be unique (case insensitive)" + group + " : " + g);
                }
                if (platforms == null || platforms.isEmpty()) continue;
                for (Platform p : platforms) {
                    for (String pn : this.getPlatformNames(p)) {
                        if (!name.equalsIgnoreCase(pn)) continue;
                        throw new GdrException("Group and platform names/aliases must be unique (case insensitive) " + group + " : " + p);
                    }
                }
            }
        }
    }

    private List<String> getPlatformNames(Platform platform) {
        ArrayList<String> platformNames = new ArrayList<String>();
        String name = platform.getName();
        platformNames.add(name);
        List<Alias> aliases = platform.getAliases();
        if (aliases != null && !aliases.isEmpty()) {
            for (Alias alias : aliases) {
                platformNames.add(alias.getName());
            }
        }
        return platformNames;
    }

    private void validateName(String name, Object entry) throws GdrException {
        if (StringUtil.isNullOrEmpty(name)) {
            throw new GdrException(entry.getClass().getSimpleName() + " name was not defined : " + entry);
        }
        if (Character.isDigit(name.charAt(0))) {
            throw new GdrException(entry.getClass().getSimpleName() + " name may not start with a digit : " + entry);
        }
        for (String c : INVALID_NAME_CHARACTERS) {
            if (!name.contains(c)) continue;
            throw new GdrException(entry.getClass().getSimpleName() + " name contained invalid character \"" + c + "\" : " + entry);
        }
    }

    public int getLegacyPlatformId(PlatformInfo platformInfo, String legacyName) {
        int id = 0;
        if (!StringUtil.isNullOrEmpty(legacyName)) {
            List<Platform> platforms = platformInfo.getPlatforms();
            for (Platform platform : platforms) {
                if (!legacyName.equals(platform.getLegacyName())) continue;
                id = platform.getId();
                break;
            }
        }
        return id;
    }

    public int getLegacyGroupId(PlatformInfo platformInfo, String legacyName) {
        int id = 0;
        if (!StringUtil.isNullOrEmpty(legacyName)) {
            List<Group> groups = platformInfo.getGroups();
            for (Group group : groups) {
                if (!legacyName.equals(group.getLegacyName())) continue;
                id = group.getId();
                break;
            }
        }
        return id;
    }

    public int getGroupId(PlatformInfo platformInfo, String name) {
        int id = 0;
        if (!StringUtil.isNullOrEmpty(name)) {
            List<Group> groups = platformInfo.getGroups();
            for (Group group : groups) {
                if (!name.equals(group.getName())) continue;
                id = group.getId();
                break;
            }
        }
        return id;
    }

    public Platform getPlatform(PlatformInfo platformInfo, int id) {
        List<Platform> platforms = platformInfo.getPlatforms();
        for (Platform platform : platforms) {
            if (id != platform.getId()) continue;
            return platform;
        }
        return null;
    }

    public int getPlatformIdByName(String name) {
        if (name != null) {
            name = name.trim();
            try {
                Map<Integer, PlatformInfoHolder> holders = this.getPlatformInfoHolders();
                for (PlatformInfoHolder holder : holders.values()) {
                    if (!holder.isMatchingNameOrAlias(name)) continue;
                    return holder.getId();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error getting platform info.", e);
            }
        }
        return 0;
    }

    public boolean isSupportedPlatformOrGroup(String name) {
        return this.getPlatformIdByName(name) != 0 || this.getGroupInfoHolder(name) != null;
    }

    public String getPlatformName(int id) {
        if (id > -1) {
            try {
                return this.getPlatformInfoHolders().get(id).getName();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error getting platform info.", e);
            }
        }
        return null;
    }

    public Set<String> getPlatformNames() {
        return this.getPlatformNames(this.getPlatformIds());
    }

    public Set<String> getPlatformNames(Collection<Integer> platforms) {
        HashSet<String> names = new HashSet<String>();
        if (platforms != null && !platforms.isEmpty()) {
            for (Integer platform : platforms) {
                PlatformInfoHolder holder = this.getPlatformInfoHolder(platform);
                if (holder != null) {
                    names.add(holder.getName());
                    continue;
                }
                _log.warning("Unable to find platform with id " + platform);
            }
        }
        return names;
    }

    public Collection<Integer> getGroupsForPlatform(int id) {
        HashSet<Integer> groups = new HashSet<Integer>();
        try {
            for (GroupInfoHolder group : this.getGroupInfoHolders().values()) {
                if (!group.hasPlatform(id)) continue;
                groups.add(group.getId());
                groups.addAll(this.getGroupsForGroup(group.getId()));
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
        }
        return groups;
    }

    public Collection<Integer> getGroupsForGroup(int id) {
        HashSet<Integer> groups = new HashSet<Integer>();
        GroupInfoHolder group = this.getGroupInfoHolder(id);
        if (group != null) {
            groups.add(group.getId());
            Collection<Integer> subGroups = group.getGroups();
            for (Integer i : subGroups) {
                groups.addAll(this.getGroupsForGroup(i));
            }
        }
        return groups;
    }

    public PlatformInfoHolder getPlatformInfoHolder(int id) {
        try {
            return this.getPlatformInfoHolders().get(id);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
            return null;
        }
    }

    public PlatformInfoHolder getPlatformInfoHolderByAruId(int id) {
        try {
            for (PlatformInfoHolder platformInfoHolder : this.getPlatformInfoHolders().values()) {
                if (platformInfoHolder.getARUId() != id) continue;
                return platformInfoHolder;
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
        }
        return null;
    }

    public Set<PlatformInfoHolder> getPlatformInfoHolders(int id) {
        LinkedHashSet<PlatformInfoHolder> holders = new LinkedHashSet<PlatformInfoHolder>();
        try {
            PlatformInfoHolder holder = this.getPlatformInfoHolders().get(id);
            if (holder != null) {
                holders.add(holder);
            } else {
                GroupInfoHolder groupInfoHolder = this.getGroupInfoHolder(id);
                if (groupInfoHolder != null) {
                    holders.addAll(this.getPlatformInfoHoldersById(groupInfoHolder.getPlatforms()));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
        }
        return holders;
    }

    public PlatformInfoHolder getPlatformInfoHolder(String name) {
        try {
            return this.getPlatformInfoHolders().get(this.getPlatformIdByName(name));
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
            return null;
        }
    }

    public GroupInfoHolder getGroupInfoHolder(int id) {
        try {
            return this.getGroupInfoHolders().get(id);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
            return null;
        }
    }

    public GroupInfoHolder getGroupInfoHolder(String name) {
        if (!StringUtil.isNullOrEmpty(name, true)) {
            try {
                for (GroupInfoHolder holder : this.getGroupInfoHolders().values()) {
                    if (!holder.getName().equalsIgnoreCase(name)) continue;
                    return holder;
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error getting platform info group.", e);
            }
        }
        return null;
    }

    public boolean isInWindowsGroup(int platform) {
        return this.getGroupsForPlatform(platform).contains(-3);
    }

    public Map<Integer, PlatformInfoHolder> getPlatformInfoHolders() throws GdrException, IOException, DataHandlerException {
        if (this._platformInfoHolders == null) {
            this.loadInfoHolders(this.getPlatformInfo());
        }
        return this._platformInfoHolders;
    }

    public Map<Integer, GroupInfoHolder> getGroupInfoHolders() throws GdrException, IOException, DataHandlerException {
        if (this._groupInfoHolders == null) {
            this.loadInfoHolders(this.getPlatformInfo());
        }
        return this._groupInfoHolders;
    }

    public void loadInfoHolders(PlatformInfo platformInfo) throws GdrException {
        String name;
        int id;
        if (platformInfo == null) {
            GdrException ex = new GdrException("The platform info was null.");
            _log.throwing(PlatformInfoHelper.class.getName(), "loadInfoHolders", ex);
            throw ex;
        }
        List<Platform> platforms = platformInfo.getPlatforms();
        List<Group> groups = platformInfo.getGroups();
        if (platforms == null || groups == null) {
            GdrException ex = new GdrException("The platform info was invalid.");
            _log.throwing(PlatformInfoHelper.class.getName(), "loadInfoHolders", ex);
            throw ex;
        }
        this._groupInfoHolders = new LinkedHashMap<Integer, GroupInfoHolder>();
        HashMap<String, GroupInfoHolder> groupNameMap = new HashMap<String, GroupInfoHolder>();
        for (Group group : groups) {
            id = group.getId();
            name = group.getName();
            GroupInfoHolder holder = new GroupInfoHolder(id, name, group.isTopLevel());
            this._groupInfoHolders.put(id, holder);
            groupNameMap.put(name, holder);
            List<String> subGroups = group.getSubGroups();
            if (subGroups == null || subGroups.isEmpty()) continue;
            for (String string : subGroups) {
                int subId = this.getGroupId(platformInfo, string);
                if (subId < 0) {
                    holder.addGroup(subId);
                    continue;
                }
                throw new GdrException("Unable to locate platform group with the name " + string + " which is referenced by group " + group);
            }
        }
        this._platformInfoHolders = new LinkedHashMap<Integer, PlatformInfoHolder>();
        for (Platform platform : platforms) {
            List<String> list;
            id = platform.getId();
            name = platform.getName();
            PlatformProperties baseProps = platform.getBaseProperties();
            PlatformInfoHolder holder = new PlatformInfoHolder(id, name, platform.getDirectoryName(), baseProps.getOsName(), baseProps.getOsArch(), baseProps.getOsVer(), baseProps.getWordType(), baseProps.getMiscInfo(), baseProps.getDataModel(), baseProps.getOsNamePrefix(), baseProps.getOsArchSuffix(), platform.getARUId(), platform.getARUDescription());
            this._platformInfoHolders.put(id, holder);
            List<PlatformProperties> extraProps = platform.getExtraProperties();
            if (extraProps != null && !extraProps.isEmpty()) {
                for (PlatformProperties extraProp : extraProps) {
                    PlatformInfoHolder extraInfo = new PlatformInfoHolder(id, name, extraProp.getDirectoryName(), extraProp.getOsName(), extraProp.getOsArch(), extraProp.getOsVer(), extraProp.getWordType(), extraProp.getMiscInfo(), extraProp.getDataModel(), extraProp.getOsNamePrefix(), extraProp.getOsArchSuffix());
                    holder.addExtraHolder(extraInfo);
                }
            }
            if ((list = platform.getGroups()) != null && !list.isEmpty()) {
                for (String group : list) {
                    if (StringUtil.isNullOrEmpty(group, true)) continue;
                    GroupInfoHolder groupHolder = (GroupInfoHolder)groupNameMap.get(group);
                    if (groupHolder != null) {
                        groupHolder.addPlatform(id);
                        continue;
                    }
                    throw new GdrException("Unable to locate platform group with the name " + group + " which is referenced by platform " + platform);
                }
            }
            holder.setAliases(platform.getAliases());
        }
    }

    public int getCurrentPlatformId() {
        return this.getCurrentPlatformId(false);
    }

    public int getCurrentPlatformId(boolean recheck) {
        if (!recheck && _currentId > -1) {
            return _currentId;
        }
        String override = System.getProperty(CURRENT_PLATFORM_PROPERTY);
        if (!StringUtil.isNullOrEmpty(override, true)) {
            _currentId = this.getPlatformIdByName(override);
            _log.fine("Using current platform override id " + _currentId);
        }
        if (_currentId < 1) {
            try {
                Map<Integer, PlatformInfoHolder> holders = this.getPlatformInfoHolders();
                String osname = System.getProperty("os.name", "");
                String osarch = System.getProperty("os.arch", "");
                String osver = System.getProperty("os.version", "");
                String osdatamodel = System.getProperty("sun.arch.data.model", "");
                ArrayList<PlatformInfoHolder> matches = new ArrayList<PlatformInfoHolder>();
                for (PlatformInfoHolder info : holders.values()) {
                    if (!info.matchesOsName(osname, true)) continue;
                    matches.add(info);
                }
                if (matches.size() == 1) {
                    _currentId = ((PlatformInfoHolder)matches.get(0)).getId();
                } else if (matches.size() > 1) {
                    PlatformInfoHolder info;
                    Iterator it = matches.iterator();
                    while (it.hasNext()) {
                        info = (PlatformInfoHolder)it.next();
                        if (!info.hasOsArch() || info.matchesOsArch(osarch, true)) continue;
                        it.remove();
                    }
                    if (matches.size() > 1) {
                        it = matches.iterator();
                        while (it.hasNext()) {
                            info = (PlatformInfoHolder)it.next();
                            if (!info.hasOsVersion() || info.matchesOsVersion(osver)) continue;
                            it.remove();
                        }
                    }
                    if (matches.size() > 1) {
                        it = matches.iterator();
                        while (it.hasNext()) {
                            info = (PlatformInfoHolder)it.next();
                            if (!info.hasDataModel() || info.matchesDataModel(osdatamodel)) continue;
                            it.remove();
                        }
                    }
                    if (!matches.isEmpty()) {
                        _currentId = ((PlatformInfoHolder)matches.get(0)).getId();
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error getting platform info.", e);
                _currentId = 0;
            }
        }
        _log.fine("The current platform is " + _currentId);
        return _currentId;
    }

    public String getCurrentPlatformName() {
        return this.getPlatformName(this.getCurrentPlatformId());
    }

    public int getCurrentPlatformARUId() {
        int id = this.getCurrentPlatformId();
        if (id > -1) {
            try {
                return this.getPlatformInfoHolders().get(id).getARUId();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error getting platform info.", e);
            }
        }
        return -1;
    }

    public Set<Integer> getPlatformIds() {
        HashSet<Integer> ids = new HashSet<Integer>();
        try {
            ids.addAll(this.getPlatformInfoHolders().keySet());
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error getting platform info.", e);
        }
        return ids;
    }

    public Set<Integer> getPlatformIds(String platforms) {
        HashSet<Integer> ids = new HashSet<Integer>();
        if (platforms != null && (platforms = platforms.replace("\"", "").trim()).length() > 0) {
            String[] plats;
            for (String plat : plats = platforms.split(",")) {
                if ((plat = plat.trim()).length() <= 0) continue;
                int id = this.getPlatformIdByName(plat);
                if (id == 2000) {
                    ids.clear();
                    ids.add(id);
                    break;
                }
                ids.add(id);
            }
        }
        return ids;
    }

    public Map<Integer, String> getPlatformIds(Collection<String> platforms) throws GdrException {
        LinkedHashMap<Integer, String> ids = new LinkedHashMap<Integer, String>();
        if (platforms != null && !platforms.isEmpty()) {
            for (String platform : platforms) {
                if ((platform = platform.trim()).length() <= 0) continue;
                PlatformInfoHolder holder = this.getPlatformInfoHolder(platform);
                if (holder != null) {
                    ids.put(holder.getId(), holder.getName());
                    continue;
                }
                throw new GdrException("Unable to locate platform for platform name " + platform);
            }
        }
        return ids;
    }

    public Map<Integer, String> getIds(Collection<String> platformsOrGroups) throws GdrException {
        return this.getIds(platformsOrGroups, false);
    }

    public Map<Integer, String> getIds(Collection<String> platformsOrGroups, boolean replaceAliases) throws GdrException {
        LinkedHashMap<Integer, String> ids = new LinkedHashMap<Integer, String>();
        if (platformsOrGroups != null && !platformsOrGroups.isEmpty()) {
            for (String name : platformsOrGroups) {
                InfoHolder holder = this.getInfoHolder(name);
                if (holder == null) continue;
                Alias alias = null;
                if (holder instanceof PlatformInfoHolder) {
                    alias = ((PlatformInfoHolder)holder).getAlias(name);
                }
                String holderName = alias == null || replaceAliases || alias.isReplace() ? holder.getName() : alias.getName();
                ids.put(holder.getId(), holderName);
            }
        }
        return ids;
    }

    public Integer getId(String platformsOrGroup) throws GdrException {
        return this.getInfoHolder(platformsOrGroup).getId();
    }

    public InfoHolder getInfoHolder(String platformsOrGroup) throws GdrException {
        if (!StringUtil.isNullOrEmpty(platformsOrGroup, true) && (platformsOrGroup = platformsOrGroup.trim()).length() > 0) {
            InfoHolder holder = this.getPlatformInfoHolder(platformsOrGroup);
            if (holder != null) {
                return holder;
            }
            holder = this.getGroupInfoHolder(platformsOrGroup);
            if (holder != null) {
                return holder;
            }
            throw new GdrException("Unable to locate platform or group for name " + platformsOrGroup);
        }
        return null;
    }

    public Set<PlatformInfoHolder> getPlatformInfoHolders(Collection<String> names) throws GdrException {
        LinkedHashSet<PlatformInfoHolder> platformInfoHolders = new LinkedHashSet<PlatformInfoHolder>();
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                PlatformInfoHolder holder = this.getPlatformInfoHolder(name);
                if (holder != null) {
                    platformInfoHolders.add(holder);
                    continue;
                }
                throw new GdrException("Unable to locate platform info holder with name " + name);
            }
        }
        return platformInfoHolders;
    }

    public Set<PlatformInfoHolder> getPlatformInfoHoldersById(Collection<Integer> ids) throws GdrException {
        LinkedHashSet<PlatformInfoHolder> platformInfoHolders = new LinkedHashSet<PlatformInfoHolder>();
        if (ids != null && !ids.isEmpty()) {
            for (Integer id : ids) {
                if (id == null) continue;
                PlatformInfoHolder holder = this.getPlatformInfoHolder(id);
                if (holder != null) {
                    platformInfoHolders.add(holder);
                    continue;
                }
                throw new GdrException("Unable to locate platform info holder with id " + id);
            }
        }
        return platformInfoHolders;
    }

    public Set<InfoHolder> getInfoHoldersFromTarget(String targetString) {
        LinkedHashSet<InfoHolder> infoHolders = new LinkedHashSet<InfoHolder>();
        if (!StringUtil.isNullOrEmpty(targetString, true)) {
            String[] targets;
            for (String target : targets = targetString.split("\\.")) {
                if (target.startsWith(PLATFORM_ENCODING_PREFIX)) {
                    Set<Integer> platforms = EncodingService.decode(target.substring(PLATFORM_ENCODING_PREFIX.length()));
                    for (Integer id : platforms) {
                        if (id < 0) {
                            infoHolders.add(this.getGroupInfoHolder(id));
                            continue;
                        }
                        infoHolders.add(this.getPlatformInfoHolder(id));
                    }
                    continue;
                }
                PlatformInfoHolder platformInfoHolder = this.getPlatformInfoHolder(target);
                if (platformInfoHolder != null) {
                    infoHolders.add(platformInfoHolder);
                    continue;
                }
                GroupInfoHolder groupInfoHolder = this.getGroupInfoHolder(target);
                if (groupInfoHolder == null) continue;
                infoHolders.add(groupInfoHolder);
            }
        }
        return infoHolders;
    }

    public Collection<String> getPlatformsFromGroup(String group) throws GdrException {
        GroupInfoHolder holder = this.getGroupInfoHolder(group);
        if (holder == null) {
            throw new GdrException("Unable to locate group with name " + group + " in the platform-info.");
        }
        Collection<Integer> childGroups = this.getGroupsForGroup(holder.getId());
        LinkedHashSet<String> platforms = new LinkedHashSet<String>();
        platforms.addAll(this.getPlatformNames(holder.getPlatforms()));
        if (childGroups != null && !childGroups.isEmpty()) {
            for (Integer groupId : childGroups) {
                platforms.addAll(this.getPlatformNames(this.getGroupInfoHolder(groupId).getPlatforms()));
            }
        }
        return platforms;
    }

    public static void main(String[] args) {
        PlatformInfoHolder infoHolder;
        int id;
        String methodName;
        if (args.length != 2 || !args[0].trim().equals("-c")) {
            System.out.println("Usage: " + PlatformInfoHelper.class.getName() + " -c <getMethod>");
            System.exit(-1);
        }
        if (!(methodName = args[1]).startsWith("get")) {
            System.err.println("The method specified did not start with \"get\" : " + methodName);
            System.exit(-1);
        }
        if ((id = PlatformInfoHelper.getInstance().getCurrentPlatformId()) < 1) {
            System.err.println("Failed to determine current platform.");
            System.exit(-1);
        }
        if ((infoHolder = PlatformInfoHelper.getInstance().getPlatformInfoHolder(id)) == null) {
            System.err.println("Unable to locate platform info for current platform id : " + id);
            System.exit(-1);
        }
        try {
            Method method = infoHolder.getClass().getMethod(methodName, new Class[0]);
            System.out.println(method.invoke((Object)infoHolder, new Object[0]));
        }
        catch (NoSuchMethodException e) {
            System.err.println("Unable to locate no-arg platform info method : " + methodName);
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception e) {
            System.err.println("Failed to execute platform info method : " + methodName);
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

