/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.common.util.IoBridge;
import com.oracle.cie.gdr.nio.NioCopy;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class NioBridge
implements IoBridge {
    @Override
    public boolean isEqual(String path1, String path2) {
        Path p1 = Paths.get(path1, new String[0]);
        Path p2 = Paths.get(path2, new String[0]);
        return p1.equals(p2);
    }

    @Override
    public String getParent(String path) {
        return Paths.get(path, new String[0]).getParent().toString();
    }

    @Override
    public String getParent(String path, boolean absolute) {
        return Paths.get(path, new String[0]).getParent().toAbsolutePath().toString();
    }

    @Override
    public String getAbsolutePath(String path) {
        return Paths.get(path, new String[0]).toAbsolutePath().toString();
    }

    @Override
    public String getFileName(String path) {
        return Paths.get(path, new String[0]).getFileName().toString();
    }

    @Override
    public String resolve(String parentDir, String fileName) {
        if (fileName != null) {
            fileName = fileName.replace('\\', '/');
            while (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
        }
        return Paths.get(parentDir, new String[0]).resolve(fileName).toString();
    }

    @Override
    public boolean exists(String path) {
        return Files.exists(NioHelper.getInstance().getPath(path, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean canWrite(String path) {
        return Files.isWritable(NioHelper.getInstance().getPath(path, new String[0]));
    }

    @Override
    public boolean canRead(String path) {
        return Files.isReadable(NioHelper.getInstance().getPath(path, new String[0]));
    }

    @Override
    public String[] list(String path) {
        return this.list(path, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] list(String path, FilenameFilter filter) {
        Path p = NioHelper.getInstance().getPath(path, new String[0]);
        Path parent = p.getParent();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
            ArrayList<String> paths = new ArrayList<String>();
            for (Path child : stream) {
                if (filter != null && !filter.accept(new File(parent.toString()), child.getFileName().toString())) continue;
                paths.add(p.getFileName().toString());
            }
            String[] stringArray = paths.toArray(new String[paths.size()]);
            return stringArray;
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    @Override
    public boolean isFile(String path) {
        return Files.isRegularFile(NioHelper.getInstance().getPath(path, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(String path) {
        return Files.isDirectory(NioHelper.getInstance().getPath(path, new String[0]), new LinkOption[0]);
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return Files.newInputStream(NioHelper.getInstance().getPath(path, new String[0]), new OpenOption[0]);
    }

    @Override
    public OutputStream getOutputStream(String path) throws IOException {
        return Files.newOutputStream(NioHelper.getInstance().getPath(path, new String[0]), new OpenOption[0]);
    }

    @Override
    public BufferedReader getBufferedReader(String path) throws IOException {
        return Files.newBufferedReader(NioHelper.getInstance().getPath(path, new String[0]), Charset.defaultCharset());
    }

    @Override
    public BufferedReader getBufferedReader(String path, String charSet) throws IOException {
        return Files.newBufferedReader(NioHelper.getInstance().getPath(path, new String[0]), Charset.forName(charSet));
    }

    @Override
    public BufferedWriter getBufferedWriter(String path) throws IOException {
        return Files.newBufferedWriter(NioHelper.getInstance().getPath(path, new String[0]), Charset.defaultCharset(), new OpenOption[0]);
    }

    @Override
    public BufferedWriter getBufferedWriter(String path, String charSet) throws IOException {
        return Files.newBufferedWriter(NioHelper.getInstance().getPath(path, new String[0]), Charset.forName(charSet), new OpenOption[0]);
    }

    @Override
    public boolean mkdirs(String dir) {
        try {
            Files.createDirectories(NioHelper.getInstance().getPath(dir, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getCanonicalPath(String path) throws IOException {
        return NioHelper.getInstance().getPath(path, new String[0]).toRealPath(new LinkOption[0]).toString();
    }

    @Override
    public void copyFile(String srcPath, String destPath) throws IOException {
        NioCopy.copyFile(NioHelper.getInstance().getPath(srcPath, new String[0]), NioHelper.getInstance().getPath(destPath, new String[0]));
    }

    @Override
    public boolean delete(String path) {
        try {
            Files.delete(NioHelper.getInstance().getPath(path, new String[0]));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

