/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.nio;

import com.oracle.cie.common.util.ManifestInfo;
import com.oracle.cie.gdr.nio.NioHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.jar.JarFile;

public class NioJdkHelper {
    public static final String HOTSPOT = "HotSpot";
    public static final String JROCKIT = "JRockit";
    public static final double JDK_VERSION_1_8 = 1.8;
    public static final String JDK_D64_OPTION = "-d64";
    public static final String JDK_MAX_PERM_SIZE_OPTION = "-XX:MaxPermSize";
    public static final String JDK_MAX_MEMORY_OPTION = "-Xmx";
    public static final String HP_FULLNAME = "Hewlett-Packard";
    public static final String HP_ABBREVIATION = "HP";

    public static boolean isJavaHome(String javaHome) {
        if (javaHome == null || "".equals(javaHome)) {
            return false;
        }
        return NioJdkHelper.isJavaHome(NioHelper.getInstance().getPath(javaHome, new String[0]));
    }

    public static boolean isJRVE(String jrve) {
        if (jrve == null || "".equals(jrve)) {
            return false;
        }
        return NioJdkHelper.isJRVE(NioHelper.getInstance().getPath(jrve, new String[0]));
    }

    public static boolean isJRVE(Path jrve) {
        if (jrve == null || !Files.exists(jrve, new LinkOption[0])) {
            return false;
        }
        return jrve.toAbsolutePath().toString().endsWith("jrockitve.bin");
    }

    public static boolean isJavaHome(Path javaHome) {
        Path rtJar;
        if (javaHome == null || !Files.exists(javaHome, new LinkOption[0])) {
            return false;
        }
        Path jreFile = javaHome;
        if (Files.exists(javaHome.resolve("jre"), new LinkOption[0])) {
            jreFile = javaHome.resolve("jre");
        }
        return Files.exists(rtJar = jreFile.resolve("lib/rt.jar"), new LinkOption[0]) || Files.exists(rtJar = jreFile.resolve("lib/core.jar"), new LinkOption[0]) || Files.exists(jreFile.resolve("release"), new LinkOption[0]);
    }

    public static String getJdkVendor(String javaHome) {
        if (javaHome == null || "".equals(javaHome)) {
            return "Unknown";
        }
        return NioJdkHelper.getJdkVendor(NioHelper.getInstance().getPath(javaHome, new String[0]));
    }

    public static String getJdkVendor(Path javaHome) {
        String vendor;
        block21: {
            Path rtFile;
            if (javaHome == null || !Files.exists(javaHome, new LinkOption[0])) {
                return "Unknown";
            }
            vendor = null;
            Path jreFile = javaHome;
            if (Files.exists(javaHome.resolve("jre"), new LinkOption[0])) {
                jreFile = javaHome.resolve("jre");
            }
            if (!Files.exists(rtFile = jreFile.resolve("lib/rt.jar"), new LinkOption[0])) {
                rtFile = jreFile.resolve("lib/core.jar");
            }
            if (Files.exists(rtFile, new LinkOption[0])) {
                try {
                    if (NioJdkHelper.isJrockit(javaHome)) {
                        vendor = "Oracle";
                        break block21;
                    }
                    try (JarFile rtJar = new JarFile(rtFile.toFile());){
                        vendor = ManifestInfo.getAttributeValue(rtJar, "Implementation-Vendor");
                        if (vendor != null && !vendor.equals("") && vendor.contains(" ")) {
                            vendor = vendor.substring(0, vendor.indexOf(" "));
                        }
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        if (HP_FULLNAME.equalsIgnoreCase(vendor)) {
            vendor = HP_ABBREVIATION;
        }
        return vendor == null ? "Unknown" : vendor;
    }

    public static String getVMType(Path javaHome) {
        String vendor = NioJdkHelper.getJdkVendor(javaHome);
        if (vendor != null && vendor.equalsIgnoreCase("Oracle")) {
            if (javaHome != null && NioJdkHelper.isJrockit(javaHome)) {
                return JROCKIT;
            }
            return HOTSPOT;
        }
        if (vendor != null && vendor.equalsIgnoreCase("Sun")) {
            return HOTSPOT;
        }
        return "";
    }

    public static String getJdkVersion(String javaHome) {
        if (javaHome == null || "".equals(javaHome)) {
            return "";
        }
        return NioJdkHelper.getJdkVersion(NioHelper.getInstance().getPath(javaHome, new String[0]));
    }

    public static String getJdkVersion(Path javaHome) {
        Path rtFile;
        if (javaHome == null || !Files.exists(javaHome, new LinkOption[0])) {
            return "";
        }
        String version = "";
        Path jreFile = javaHome;
        if (Files.exists(javaHome.resolve("jre"), new LinkOption[0])) {
            jreFile = javaHome.resolve("jre");
        }
        if (!Files.exists(rtFile = jreFile.resolve("lib/rt.jar"), new LinkOption[0])) {
            rtFile = jreFile.resolve("lib/core.jar");
        }
        if (Files.exists(rtFile, new LinkOption[0])) {
            try (JarFile rtJar = new JarFile(rtFile.toFile());){
                version = ManifestInfo.getAttributeValue(rtJar, "Implementation-Version");
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return version == null ? "" : version;
    }

    public static double getCurrentJavaVersion() {
        String version = System.getProperty("java.version");
        String versionPrefix = "99999999";
        String[] elements = version.split("[^0-9\\.]");
        if (elements.length > 0) {
            String[] majorMinorSecurity = elements[0].split("\\.");
            if (majorMinorSecurity.length > 1) {
                versionPrefix = majorMinorSecurity[0] + "." + majorMinorSecurity[1];
            } else if (majorMinorSecurity.length > 0) {
                versionPrefix = majorMinorSecurity[0];
            }
        }
        return Double.parseDouble(versionPrefix);
    }

    public static boolean isD64Required() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        return !(!osName.startsWith("sunos") && !osName.startsWith("solaris") && !osName.startsWith("hp") && !osName.startsWith("mac") || !osArch.contains("64") && !osArch.contains("sparcv9"));
    }

    public static boolean isMaxPermSizeSupported() {
        return NioJdkHelper.getCurrentJavaVersion() < 1.8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJrockit(Path javahome) {
        if (javahome == null) {
            return false;
        }
        Path f = javahome.resolve("jre" + File.separator + "bin" + File.separator + "jrockit");
        if (Files.exists(f, new LinkOption[0])) {
            return true;
        }
        f = javahome.resolve("jre" + File.separator + "lib");
        if (!Files.isDirectory(f, new LinkOption[0])) return false;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(f);){
            Path p;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!Files.exists((p = iterator.next()).resolve("jrockit"), new LinkOption[0]));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

