/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.inputs.impl;

import com.oracle.cie.nextgen.common.inputs.apis.Variable;
import com.oracle.cie.nextgen.common.inputs.enums.DataType;
import com.oracle.cie.nextgen.common.inputs.enums.ValueSourceType;
import com.oracle.cie.nextgen.common.inputs.impl.InputImpl;
import com.oracle.xmlns.oui.variables.VariableInputType;

public class VariableImpl
extends InputImpl
implements Variable {
    private VariableInputType type;
    private ValueSourceType valueSource = ValueSourceType.DEFAULT;
    private boolean secure;
    private boolean calculate = false;
    private boolean computeAtClone = false;
    private boolean validate = false;
    private boolean generate = false;
    private boolean advise = false;
    private boolean isPublish = false;
    private String varClass = null;
    private String baseClass = null;
    private boolean handleErrors = false;
    private boolean suppressedOnSilent = true;
    private String defaultResponseValue = null;

    public VariableImpl(String name, VariableInputType type) {
        super(name, VariableImpl.computeDataType(type));
        this.type = type;
    }

    @Override
    public boolean validate() {
        switch (this.type) {
            case PATH_EXISTS: 
            case FILE_EXISTS: {
                return this.validateFile((String)this.getValue());
            }
            case PATH_LIST_EXISTS: 
            case FILE_LIST_EXISTS: {
                return this.validateFile((String[])this.getValue());
            }
        }
        return true;
    }

    private static DataType computeDataType(VariableInputType type) {
        switch (type) {
            case DATETIME: {
                return DataType.DATE;
            }
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case NUMBER: {
                return DataType.INTEGER;
            }
            case PATH_LIST_EXISTS: 
            case FILE_LIST_EXISTS: 
            case STRING_LIST: 
            case FILE_LIST: 
            case PATH_LIST: {
                return DataType.STRING_ARRAY;
            }
        }
        return DataType.STRING;
    }

    public String getDefaultResponseValue() {
        return this.defaultResponseValue;
    }

    public void setDefaultResponseValue(String defaultResponseValue) {
        this.defaultResponseValue = defaultResponseValue;
    }

    public String getVarClass() {
        return this.varClass;
    }

    public void setVarClass(String varClass) {
        this.varClass = varClass;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(String baseClass) {
        this.baseClass = baseClass;
    }

    public boolean isHandleErrors() {
        return this.handleErrors;
    }

    public void setHandleErrors(boolean handleErrors) {
        this.handleErrors = handleErrors;
    }

    public boolean isSuppressedOnSilent() {
        return this.suppressedOnSilent;
    }

    public void setSuppressedOnSilent(boolean suppressedOnSilent) {
        this.suppressedOnSilent = suppressedOnSilent;
    }

    public ValueSourceType getValueSource() {
        return this.valueSource;
    }

    public void setValueSource(ValueSourceType valueSource) {
        this.valueSource = valueSource;
    }

    public boolean isCalculate() {
        return this.calculate;
    }

    public void setCalculate(boolean calculate) {
        this.calculate = calculate;
    }

    public boolean isComputeAtClone() {
        return this.computeAtClone;
    }

    public void setComputeAtClone(boolean computeAtClone) {
        this.computeAtClone = computeAtClone;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public boolean isAdvise() {
        return this.advise;
    }

    public void setAdvise(boolean advise) {
        this.advise = advise;
    }

    public void setPublish(boolean isPublish) {
        this.isPublish = isPublish;
    }

    @Override
    public boolean isPublish() {
        return this.isPublish;
    }
}

