/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.utils;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.nextgen.common.NLS;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class Bootstrap {
    private static final Logger _logger = Logger.getLogger(Bootstrap.class.getName());
    private static String _tempDir = null;
    public static final String DEFAULT_SCRATCH_PATH_PREFIX = "OraInstall";

    public static String initScratchLoc() throws IOException {
        return Bootstrap.initScratchLoc(DEFAULT_SCRATCH_PATH_PREFIX, null);
    }

    public static String initScratchLoc(String prefix) throws IOException {
        return Bootstrap.initScratchLoc(prefix, null);
    }

    public static String initScratchLoc(File rscratch) throws IOException {
        return Bootstrap.initScratchLoc(DEFAULT_SCRATCH_PATH_PREFIX, rscratch);
    }

    public static String initScratchLoc(String prefix, File rscratch) throws IOException {
        String scratchPath;
        String prop = System.getProperty("oracle.installer.scratchPath");
        if (rscratch != null) {
            scratchPath = rscratch.getPath();
        } else if (!StringUtil.isNullOrEmpty(prop)) {
            scratchPath = prop;
        } else {
            String parent;
            try {
                parent = Bootstrap.getTempDir();
            }
            catch (IOException ioe) {
                String msg = NLS.getMsg("S_NO_TEMP", ioe.getMessage());
                throw new IOException(msg);
            }
            if (StringUtil.isNullOrEmpty(prefix)) {
                prefix = DEFAULT_SCRATCH_PATH_PREFIX;
            }
            scratchPath = parent + File.separator + prefix + UtilityOps.getSessionTimeStamp();
            File f = new File(scratchPath);
            int i = 1;
            while (f.exists()) {
                if (i > 1024) {
                    String msg = NLS.getMsg("S_SCRATCH_DUPS", f.getPath());
                    throw new IOException(msg);
                }
                f = new File(scratchPath + "_" + i);
                ++i;
            }
            scratchPath = f.getPath();
        }
        scratchPath = Bootstrap.createAndValidateDirectory(scratchPath);
        if (!UtilityOps.isValidPathString(scratchPath)) {
            String msg = NLS.getMsg("S_INVALID_CHARS_IN_PATH", scratchPath);
            throw new IOException(msg);
        }
        System.setProperty("oracle.installer.scratchPath", scratchPath);
        _logger.finer("Using scratchPath: " + scratchPath);
        return scratchPath;
    }

    public static synchronized String getTempDir() throws IOException {
        if (_tempDir == null) {
            _tempDir = Bootstrap.createTempDir();
        }
        return _tempDir;
    }

    private static String createTempDir() throws IOException {
        String temp = System.getProperty("java.io.tmpdir");
        if (StringUtil.isNullOrEmpty(temp) && ComdevHelper.isWindows()) {
            temp = System.getenv("TEMP");
        }
        if (StringUtil.isNullOrEmpty(temp) && !ComdevHelper.isWindows()) {
            temp = System.getenv("TMPDIR");
        }
        if (StringUtil.isNullOrEmpty(temp)) {
            temp = ComdevHelper.isWindows() ? "c:\\temp" : "/tmp";
        }
        temp = Bootstrap.createAndValidateDirectory(temp);
        return temp;
    }

    public static String createAndValidateDirectory(String path) throws IOException {
        String result = Bootstrap.getCanonicalPath(path);
        File f = new File(result);
        if (!f.exists() && !f.mkdirs()) {
            String msg = NLS.getMsg("S_CANT_CREATE", result);
            _logger.warning(msg);
            throw new IOException(msg);
        }
        if (!f.isDirectory()) {
            String msg = NLS.getMsg("S_NOT_DIR", result);
            _logger.warning(msg);
            throw new IOException(msg);
        }
        if (!(f.canRead() && f.canWrite() && f.canExecute())) {
            String msg = NLS.getMsg("S_PERM", result);
            _logger.warning(msg);
            throw new IOException(msg);
        }
        return result;
    }

    private static String getCanonicalPath(String path) {
        String result;
        File f = new File(path);
        try {
            result = f.getCanonicalPath();
        }
        catch (IOException e) {
            result = f.getAbsolutePath();
        }
        return result;
    }
}

