/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.version;

import com.oracle.cie.common.util.StringUtil;
import java.util.logging.Logger;

public class VersionHelper {
    private static final Logger _logger = Logger.getLogger(VersionHelper.class.getName());

    public static String getVersionPrefix(String candidate) {
        if (candidate == null) {
            return null;
        }
        return VersionHelper.getVersionPrefix(candidate, Integer.MAX_VALUE);
    }

    public static String getVersionPrefix(String candidate, int positions) {
        if (candidate == null) {
            return null;
        }
        char[] arr = candidate.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            if (Character.isDigit(c)) continue;
            if (c == '.') {
                if (--positions != 0) continue;
                return candidate.substring(0, i);
            }
            return candidate.substring(0, i);
        }
        return candidate;
    }

    public static boolean isValidVersion(String version) {
        if (StringUtil.isNullOrEmpty(version)) {
            return false;
        }
        String regex = "\\d+(\\u002E\\d+)*";
        boolean result = version.matches(regex);
        _logger.finest("isValidVersion: version=" + version + " result=" + result);
        return result;
    }

    public static int compareShorter(String v1, String v2) {
        return VersionHelper.compare(v1, v2, -1);
    }

    public static int compare(String v1, String v2, int positions) {
        if (v1 == null) {
            if (v2 == null || positions < 0) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            if (positions < 0) {
                return 0;
            }
            return 1;
        }
        String[] arr1 = v1.split("\\.");
        String[] arr2 = v2.split("\\.");
        int len1 = arr1.length;
        int len2 = arr2.length;
        if (positions < 0) {
            positions = Math.min(len1, len2);
        } else if (positions > len1 && positions > len2) {
            positions = Math.max(len1, len2);
        }
        for (int i = 0; i < positions; ++i) {
            String n1 = i < len1 ? arr1[i] : "0";
            String n2 = i < len2 ? arr2[i] : "0";
            try {
                long i1 = Long.parseLong(n1);
                long i2 = Long.parseLong(n2);
                if (i1 > i2) {
                    return 1;
                }
                if (i1 >= i2) continue;
                return -1;
            }
            catch (NumberFormatException nfe) {
                _logger.warning("Invalid integer in version " + v1 + " or " + v2 + " at position " + i);
                _logger.warning("Reporting that versions are equal");
                return 0;
            }
        }
        return 0;
    }

    public static int compare(String v1, String v2) {
        return VersionHelper.compare(v1, v2, Integer.MAX_VALUE);
    }
}

