/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.util.DirectoryRestore;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.NLS;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootStrap {
    private static final Logger _logger = Logger.getLogger(BootStrap.class.getName());
    private static final String FS = File.separator;
    private String _bootstrapBase;
    private long _lBootStrapSz;
    private boolean _bPreInstallEnv;
    private String _timeLogLoc;
    private boolean _bPrintTime;
    private boolean _bNoBootStrap;
    private String _launcherBootstrap;
    private String _launcherBootstrapPlatform;
    private String _disk1Loc;
    private String _bootstrapComponents = "";

    public BootStrap(String bootstrapBase, long lBootStrapSz, boolean bPreInstallEnv, String timeLogLoc, boolean bPrintTime, boolean bNoBootStrap, String launcherBootstrap, String launcherBootstrapPlatform, String disk1Loc) {
        this._bootstrapBase = bootstrapBase;
        this._lBootStrapSz = lBootStrapSz;
        this._bPreInstallEnv = bPreInstallEnv;
        this._timeLogLoc = timeLogLoc;
        this._bPrintTime = bPrintTime;
        this._bNoBootStrap = bNoBootStrap;
        this._launcherBootstrap = launcherBootstrap;
        this._launcherBootstrapPlatform = launcherBootstrapPlatform;
        this._disk1Loc = disk1Loc;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("BootStrap: bootstrapBase=" + bootstrapBase);
            _logger.finest("BootStrap: lBootStrapSz=" + lBootStrapSz);
            _logger.finest("BootStrap: bPreInstallEnv=" + bPreInstallEnv);
            _logger.finest("BootStrap: timeLogLoc=" + timeLogLoc);
            _logger.finest("BootStrap: bPrintTime=" + bPrintTime);
            _logger.finest("BootStrap: bNoBootStrap=" + bNoBootStrap);
            _logger.finest("BootStrap: launcherBootstrap=" + launcherBootstrap);
            _logger.finest("BootStrap: launcherBootstrapPlatform=" + launcherBootstrapPlatform);
            _logger.finest("BootStrap: disk1Loc=" + disk1Loc);
        }
    }

    public static boolean unzipJars(String fromLoc, String toDir, String entry) {
        _logger.finer("unzipJars: fromLoc=" + fromLoc + " toDir=" + toDir + " entry=" + entry);
        boolean ret = false;
        File src = new File(fromLoc);
        if (!src.exists()) {
            _logger.severe("unzipJars failed: fromLoc " + fromLoc + " does not exist");
            return false;
        }
        File dest = new File(toDir);
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (!dest.isDirectory()) {
            _logger.severe("unzipJars failed: toDir " + toDir + " is not a directory");
            return false;
        }
        try {
            File[] jars = null;
            if (src.isDirectory()) {
                jars = src.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f != null && f.exists() && f.isFile() && f.getName().endsWith(".jar");
                    }
                });
            } else if (src.isFile()) {
                jars = new File[]{src};
            }
            if (jars != null) {
                for (File jar : jars) {
                    if (entry != null) {
                        ArrayList<String> entryList = new ArrayList<String>(1);
                        entryList.add(entry);
                        DirectoryRestore.performUnZip(jar, dest, entryList, null);
                        continue;
                    }
                    DirectoryRestore.performUnZip(jar, dest, null);
                }
            }
            ret = true;
        }
        catch (IOException ioe) {
            _logger.severe("unzipJars failed: fromLoc=" + fromLoc + " exception=" + ioe.getMessage());
        }
        if (ret) {
            LogUtils.writeToInstallLog("S_UNZIP_OK", fromLoc, toDir);
        }
        return ret;
    }

    public static int countFilesExtracted(String dest) {
        return BootStrap.countFiles(new File(dest));
    }

    private static int countFiles(File f) {
        int count = 0;
        if (f == null) {
            return 0;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    count += BootStrap.countFiles(file);
                }
            }
        } else {
            count = 1;
        }
        return count;
    }

    public static void logBootStrapInformation(String loc) {
        int numFiles = BootStrap.countFilesExtracted(loc);
        LogUtils.writeToInstallLog("S_NUMBER_OF_FILES_BOOTSTRAPPED", loc, Integer.toString(numFiles));
    }

    public boolean doBootStrap() {
        PrintStream timeLogStream = null;
        if (!this._bPreInstallEnv) {
            return true;
        }
        String msg = BootStrap.checkFreeSpace(this._bootstrapBase, this._lBootStrapSz, "S_BAD_FREESPACE_BOOTSTRAP");
        if (msg != null) {
            _logger.severe(msg);
            return false;
        }
        if (this._bPrintTime) {
            timeLogStream = LogUtils.openTimeLog(this._timeLogLoc);
        }
        for (String prop : new String[]{this._launcherBootstrap, this._launcherBootstrapPlatform}) {
            if (StringUtil.isNullOrEmpty(prop)) continue;
            for (String pair : prop.split(",")) {
                String[] arr2;
                String[] arr = pair.split(":");
                if (arr.length != 2 || arr[0].length() == 0 || arr[1].length() == 0) {
                    LogUtils.closeLog(timeLogStream);
                    _logger.finer("Invalid pair " + pair + " found in property " + prop + " in launcher.properties");
                    msg = NLS.get_mesg("S_INVALID_BOOTSTRAP_PAIR", pair);
                    _logger.severe(msg);
                    return false;
                }
                _logger.finer("pair: arr[0]=" + arr[0] + " arr[1]=" + arr[1]);
                String entry = null;
                int idx = arr[0].indexOf("!/");
                if (idx != -1) {
                    entry = arr[0].substring(idx + 2);
                    arr[0] = arr[0].substring(0, idx);
                }
                if ((arr2 = arr[0].split("/"))[0].equals("stage") && arr2[1].equals("Components")) {
                    this._bootstrapComponents = this._bootstrapComponents + arr2[2] + ":" + arr2[3] + ",";
                }
                String stgJar = Utils.getFullPath(this._disk1Loc, arr[0]);
                String toDir = this._bootstrapBase + FS + arr[1];
                long startTime = System.currentTimeMillis();
                if (!this._bNoBootStrap && !BootStrap.unzipJars(stgJar, toDir, entry)) {
                    LogUtils.closeLog(timeLogStream);
                    msg = NLS.get_mesg("S_UNZIP_JARS_FAILED", stgJar, toDir);
                    _logger.severe(msg);
                    return false;
                }
                if (!this._bPrintTime) continue;
                long endTime = System.currentTimeMillis();
                long dif = endTime - startTime;
                msg = "Bootstrap " + stgJar;
                LogUtils.printTimeMsg(timeLogStream, msg, dif, endTime);
            }
        }
        BootStrap.logBootStrapInformation(this._bootstrapBase + FS + "oui");
        LogUtils.closeLog(timeLogStream);
        return true;
    }

    public static String checkFreeSpace(String dir, long minMB, String key) {
        long freeBytes = PlatformHelper.getDiskFree(dir);
        long freeMB = freeBytes / 0x100000L + 1L;
        _logger.finer("checkFreeSpace: dir=" + dir + " minMB=" + minMB + " freeBytes=" + freeBytes + " freeMB=" + freeMB);
        if (freeMB < minMB) {
            return NLS.get_mesg(key, dir, Long.toString(freeMB), Long.toString(minMB));
        }
        return null;
    }

    public String getBootstrapComponentsList() {
        return this._bootstrapComponents;
    }
}

