/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.jni.Win32Registry;
import com.oracle.cie.common.jni.WinRegistryHelper;
import com.oracle.cie.common.util.Chmod;
import com.oracle.cie.common.util.Execute;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import com.oracle.cie.nextgen.common.inventory.InventoryUtils;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.cie.nextgen.launcher.Launcher;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.NLS;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class PlatformHelper {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    public static final String FS = File.separator;
    public static final String HOTSPOT_JVM = "HotSpot";
    public static final String IBM_JVM = "IBM";
    public static final String JROCKIT_JVM = "JRockit";
    public static final String OPENJDK_JVM = "OpenJDK";
    private static String _osversion = null;
    private static String _dataModel = null;
    private static PlatformInfoHolder _holder = null;
    private static boolean _isAIX = false;
    private static boolean _isMac = false;
    private static boolean _isLinux = false;
    private static boolean _isOSF = false;
    private static boolean _isOSDI390 = false;
    private static boolean _isSolaris = false;
    private static boolean _isHpux = false;
    private static boolean _isLinuxSparc = false;
    private static boolean _isWin = false;
    private static boolean _isUnix = false;
    private static Properties _props = new Properties();
    private static String[] _env = null;

    public static boolean isWin() {
        return _isWin;
    }

    public static boolean isUnix() {
        return _isUnix;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isAIX() {
        return _isAIX;
    }

    public static boolean isHpux() {
        return _isHpux;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isMac() {
        return _isMac;
    }

    public static boolean isOSDI390() {
        return _isOSDI390;
    }

    public static boolean isLinuxSparc() {
        return _isLinuxSparc;
    }

    public static boolean isOSF() {
        return _isOSF;
    }

    public static boolean doChmod(String path, String mode, boolean recursive) {
        boolean result = true;
        if (PlatformHelper.isUnix() && !(result = Chmod.chmod(path, mode, recursive))) {
            _logger.finer("chmod(" + path + "," + mode + "," + recursive + ") failed");
        }
        return result;
    }

    public static String getRegistry(String key, String regname) {
        _logger.finer("getRegistry: key=" + key + " regname=" + regname);
        return WinRegistryHelper.getRegistry(key, regname);
    }

    public static boolean isRegistryAccessible() {
        if (!PlatformHelper.isWin()) {
            return true;
        }
        String key1 = "HKEY_LOCAL_MACHINE\\Software\\Oracle";
        String regname1 = "oracle_oui_temp";
        String type1 = "REG_SZ";
        String value1 = "temp value";
        boolean result = WinRegistryHelper.createRegistry(key1, regname1, type1, value1);
        if (!result) {
            _logger.severe("createRegistry to add a value failed");
            return false;
        }
        result = WinRegistryHelper.deleteRegistry(key1, regname1);
        if (!result) {
            _logger.severe("deleteRegistry to delete a value failed");
            return false;
        }
        int handle2 = -2147483646;
        String subkey2 = "Software\\Oracle\\temp key";
        int options2 = 0;
        int samDesired2 = 131078;
        int ret = Win32Registry.RegCreateKeyExA(handle2, subkey2, options2, samDesired2);
        if (ret == -1) {
            _logger.severe("RegCreateKeyExA failed");
            return false;
        }
        String key2 = "HKEY_LOCAL_MACHINE\\Software\\Oracle\\temp key";
        result = WinRegistryHelper.deleteKey(key2);
        if (!result) {
            _logger.severe("deleteKey " + key2 + " failed");
            return false;
        }
        _logger.finer("isRegistryAccessible returns true");
        return true;
    }

    public static void allocateConsole() {
    }

    public static String getInstallPath() {
        return "install" + FS + PlatformHelper.getPlatformDirectoryName();
    }

    public static String getPlatformDirectoryName() {
        PlatformInfoHolder holder = PlatformHelper.getPlatformInfoHolder();
        if (holder == null) {
            _logger.severe("Can't get PlatformInfoHolder");
            return "unknown";
        }
        return holder.getDirectoryName();
    }

    public static String getPlatformName() {
        PlatformInfoHolder holder = PlatformHelper.getPlatformInfoHolder();
        if (holder == null) {
            _logger.severe("Can't get PlatformInfoHolder");
            return "unknown";
        }
        return holder.getName();
    }

    private static PlatformInfoHolder getPlatformInfoHolder() {
        if (_holder == null) {
            PlatformInfoHelper helper = PlatformInfoHelper.getInstance();
            int id = helper.getCurrentPlatformId();
            if (id == 0) {
                _logger.severe("Unknown platform");
            } else {
                _holder = helper.getPlatformInfoHolder(id);
            }
        }
        return _holder;
    }

    public static long getDiskFree(String path) {
        return Util.getDiskFree(path);
    }

    public static boolean isSuperUser() {
        List<String> output;
        if (!PlatformHelper.isUnix()) {
            return false;
        }
        String cmd = PlatformHelper.getPlatformProperty("ID_CMD");
        if (PlatformHelper.isExecutable(cmd) && (output = PlatformHelper.getCommandOutputInEnglish(cmd)) != null && !output.isEmpty()) {
            return "0".equals(output.get(0));
        }
        _logger.warning("Id command failed; assuming current user is not superuser");
        return false;
    }

    public static boolean setUnixEnvironment(boolean bIsSilent) {
        if (!PlatformHelper.isUnix()) {
            return true;
        }
        if (PlatformHelper.isSuperUser()) {
            String msg = MessageFormat.format(NLS.nls_mesg("S_ERPERROT"), new Object[]{null});
            LogUtils.print_error(msg, new String[0]);
            return false;
        }
        return bIsSilent || PlatformHelper.checkDisplay();
    }

    private static boolean checkDisplay() {
        if (!PlatformHelper.isUnix() || PlatformHelper.isMac()) {
            return true;
        }
        String display = System.getenv("DISPLAY");
        _logger.finer("DISPLAY: " + display);
        if (StringUtil.isNullOrEmpty(display)) {
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_1"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_2"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_3"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_4"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_5"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_6"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_7"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_8"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_9"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_10"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_11"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_12"));
            NLS.nls_out(NLS.nls_mesg("S_ERPERDSP_13"));
            String msg = MessageFormat.format(NLS.nls_mesg("S_ERPERDSPXCLOCKLOC"), PlatformHelper.getCommand("TYPICAL_XCLOCK_LOC"));
            NLS.nls_out(msg);
            return false;
        }
        return true;
    }

    public static String getOSVersion() {
        return _osversion;
    }

    public static int getMajorVersion() {
        String tmp;
        int major = 0;
        int dot = _osversion.indexOf(".");
        if (dot == -1) {
            _logger.finer("No dot separator in osversion: " + _osversion);
            tmp = _osversion;
        } else {
            tmp = _osversion.substring(0, dot);
        }
        try {
            major = Integer.parseInt(tmp);
        }
        catch (NumberFormatException nfe) {
            _logger.finer("Can't parse major version in " + tmp + "; " + nfe.toString());
        }
        return major;
    }

    public static long getDefaultBootStrapSize() {
        long sizeMB = 0L;
        String size = PlatformHelper.getPlatformProperty("DEFAULT_BOOTSTRAP_SIZE");
        try {
            sizeMB = Long.parseLong(size);
        }
        catch (NumberFormatException nfe) {
            _logger.finer("Can't parse default bootstrap size=" + size);
        }
        return sizeMB;
    }

    public static String getDefaultInventoryPointerFile() {
        return InventoryUtils.getDefaultInvPtrLoc();
    }

    public static boolean hasValidDriveLetter(String path) {
        File[] roots;
        if (StringUtil.isNullOrEmpty(path)) {
            return false;
        }
        String driveLetter = path.substring(0, 1);
        for (File root : roots = File.listRoots()) {
            String s = root.getPath().substring(0, 1);
            if (!driveLetter.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static String getServicePack() {
        if (!PlatformHelper.isWin()) {
            return null;
        }
        String key = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
        String regname = "CSDVersion";
        String servicePack = PlatformHelper.getRegistry(key, regname);
        _logger.finer("getServicePack: servicePack=" + servicePack);
        return servicePack;
    }

    public static boolean isServicePack6a() {
        if (!PlatformHelper.isWin()) {
            return false;
        }
        int handle = -2147483646;
        String key = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix\\Q246009";
        int samDesired = 1;
        int result = Win32Registry.RegOpenKeyExA(handle, key, samDesired);
        return result != -1;
    }

    public static boolean isWindowsVistaOrLater() {
        int major = PlatformHelper.getMajorVersion();
        return major >= 6;
    }

    public static long getSwap() {
        long max = -1L;
        if (!PlatformHelper.isWin()) {
            return max;
        }
        if (PlatformHelper.isWindowsVistaOrLater()) {
            _logger.finer("getSwap for Vista or later always succeeds - using max long");
            max = Long.MAX_VALUE;
        } else {
            String key = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Memory Management";
            String regname = "PagingFiles";
            String val = PlatformHelper.getRegistry(key, regname);
            if (val != null && val.length() != 0) {
                _logger.finer("regname=" + regname + " val=***" + val + "***");
                int idx = val.lastIndexOf(" ");
                if (idx != -1 && idx < val.length()) {
                    String tmp = val.substring(idx + 1);
                    try {
                        max = Long.parseLong(tmp);
                    }
                    catch (NumberFormatException nfe) {
                        _logger.finer("Can't parse " + tmp);
                    }
                }
            }
        }
        return max;
    }

    public static String getRequiredLauncherJavaVersion() {
        return _props.getProperty("LAUNCHER_JAVA_VERSION");
    }

    public static List<String> getImplicitJVMOptions() {
        ArrayList<String> result = new ArrayList<String>(2);
        if (_isSolaris || _isHpux || _isMac) {
            result.add("-d" + _dataModel);
        }
        result.add("-Djava.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        return result;
    }

    public static String getJVMType() {
        String jvmName = System.getProperty("java.vm.name");
        String result = StringUtil.isNullOrEmpty(jvmName) ? "<unknown>" : (jvmName.indexOf(HOTSPOT_JVM) != -1 ? HOTSPOT_JVM : (jvmName.indexOf(JROCKIT_JVM) != -1 ? JROCKIT_JVM : (jvmName.indexOf(IBM_JVM) != -1 ? IBM_JVM : (jvmName.indexOf(OPENJDK_JVM) != -1 ? OPENJDK_JVM : jvmName))));
        _logger.finer("JVM type: " + result);
        return result;
    }

    public static String getCommand(String iniKey) {
        return PlatformHelper.getPlatformProperty(iniKey);
    }

    public static String getOSKeyForIni() {
        return PlatformHelper.getPlatformProperty("OSNAME");
    }

    public static String getCPUSpeed() {
        if (!PlatformHelper.isWin()) {
            return null;
        }
        String key = "HKEY_LOCAL_MACHINE\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0";
        String regname = "~MHz";
        return PlatformHelper.getRegistry(key, regname);
    }

    public static int getWindowsDisplayBitsPerPixel() {
        Window window = new Window(null);
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        DisplayMode mode = gc.getDevice().getDisplayMode();
        int bitsPerPixel = mode.getBitDepth();
        _logger.finer("bitsPerPixel: " + bitsPerPixel);
        return bitsPerPixel;
    }

    public static String getProperty(String key) {
        return _props.getProperty(key);
    }

    private static String getPlatformProperty(String metakey) {
        String key = metakey + "." + PlatformHelper.getPlatformDirectoryName().toUpperCase();
        String val = _props.getProperty(key);
        if (StringUtil.isNullOrEmpty(val) && PlatformHelper.isUnix()) {
            key = metakey + "." + "UNIX";
            val = _props.getProperty(key);
        }
        _logger.finer("getPlatformProperty: key=" + key + " val=" + val);
        return val;
    }

    public static boolean isExecutable(String cmd) {
        File f;
        if (StringUtil.isNullOrEmpty(cmd)) {
            return false;
        }
        String exe = cmd;
        int idx = cmd.indexOf(" ");
        if (idx != -1) {
            exe = cmd.substring(0, idx);
        }
        if (!(f = new File(exe)).exists() || !f.canExecute()) {
            _logger.finer("Command " + exe + " is not executable because it does not exist or does not have execute permission");
            return false;
        }
        return true;
    }

    public static List<String> getCommandOutput(String cmd, String[] env) {
        if (StringUtil.isNullOrEmpty(cmd)) {
            _logger.finer("getCommandOutput: command to be executed is null or empty");
            return null;
        }
        _logger.finer("getCommandOutput: cmd is '" + cmd + "'");
        Execute e = new Execute();
        e.exec(cmd, env);
        List outputList = e.getOutputList();
        List errorList = e.getErrorList();
        if (errorList != null && errorList.size() != 0) {
            _logger.finer("Command " + cmd + " has error output:");
            for (String err : errorList) {
                _logger.finer("  " + err);
            }
        }
        return outputList;
    }

    public static List<String> getCommandOutputInEnglish(String cmd) {
        return PlatformHelper.getCommandOutput(cmd, _env);
    }

    public static boolean isUsableCommandOutput(List<String> output) {
        return output != null && !output.isEmpty() && output.get(0).indexOf("not found") == -1 && output.get(0).indexOf("cannot execute") == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        _osversion = System.getProperty("os.version");
        _dataModel = System.getProperty("sun.arch.data.model");
        _isWin = osname.startsWith("Win");
        _isLinux = osname.toLowerCase().startsWith("linux");
        _isSolaris = osname.toLowerCase().startsWith("sunos");
        _isHpux = osname.toLowerCase().startsWith("hp");
        _isOSDI390 = osarch.toLowerCase().startsWith("s390");
        _isLinuxSparc = _isLinux && osarch.toLowerCase().startsWith("sparc");
        _isAIX = osname.toLowerCase().startsWith("aix");
        _isMac = osname.toLowerCase().startsWith("mac");
        _isUnix = _isLinux || _isSolaris || _isHpux || _isAIX || _isMac;
        InputStream is = null;
        try {
            is = Launcher.class.getResourceAsStream("platformhelper.properties");
            if (is != null) {
                _props.load(is);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        Map<String, String> map = System.getenv();
        _env = new String[map.size() + 1];
        int i = 0;
        for (String key : map.keySet()) {
            PlatformHelper._env[i++] = key + "=" + map.get(key);
        }
        PlatformHelper._env[i] = "LC_ALL=C";
    }
}

