/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.NLS;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.PrereqException;
import com.oracle.cie.nextgen.launcher.checker.AIXPatchCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import com.oracle.cie.nextgen.launcher.checker.HPBundleCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.HPFilesetCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.JVMDataModelCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.LinuxGlibcVersionCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.LinuxKernelVersionCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.LinuxPatchCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixCPUCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixGmakeVersionCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixMinColorsCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixPackageCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixPatchCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixPerlVersionCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixProcessorCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixSwapCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.UnixTempCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.WindowsCPUCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.WindowsMinColorsCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.WindowsServicePackCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.WindowsSwapCheckerImpl;
import com.oracle.cie.nextgen.launcher.checker.WindowsTempCheckerImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;

public class PrereqChecks {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    private static String LS = System.getProperty("line.separator");
    protected SimpleOraparamIni _ini;
    protected String _scratchLoc;
    protected boolean _bIgnoreSysPrereqs;
    protected boolean _bExecuteSysPrereqs;
    protected boolean _bNoConsole;
    protected boolean _bSilent;
    protected String _logLoc;
    protected AbstractChecker _unixPatchChecker = null;
    protected HPBundleCheckerImpl _hpBundleChecker = null;
    protected HPFilesetCheckerImpl _hpFilesetChecker = null;
    protected JVMDataModelCheckerImpl _java64BitChecker = null;
    protected LinuxGlibcVersionCheckerImpl _linuxGlibcVersionChecker = null;
    protected LinuxKernelVersionCheckerImpl _linuxKernelVersionChecker = null;
    protected UnixCPUCheckerImpl _unixCPUChecker = null;
    protected UnixGmakeVersionCheckerImpl _unixGmakeVersionChecker = null;
    protected UnixPerlVersionCheckerImpl _unixPerlVersionChecker = null;
    protected UnixMinColorsCheckerImpl _unixMinColorsChecker = null;
    protected UnixPackageCheckerImpl _unixPackageChecker = null;
    protected UnixProcessorCheckerImpl _unixProcessorChecker = null;
    protected UnixSwapCheckerImpl _unixSwapChecker = null;
    protected UnixTempCheckerImpl _unixTempChecker = null;
    protected WindowsCPUCheckerImpl _windowsCPUChecker = null;
    protected WindowsMinColorsCheckerImpl _windowsMinColorsChecker = null;
    protected WindowsServicePackCheckerImpl _windowsServicePackChecker = null;
    protected WindowsSwapCheckerImpl _windowsSwapChecker = null;
    protected WindowsTempCheckerImpl _windowsTempChecker = null;

    protected PrereqChecks(SimpleOraparamIni ini, String scratchLoc, boolean bIgnoreSysPrereqs, boolean bExecuteSysPrereqs, boolean bNoConsole, boolean bSilent, String logLoc) {
        this._ini = ini;
        this._scratchLoc = scratchLoc;
        this._bIgnoreSysPrereqs = bIgnoreSysPrereqs;
        this._bExecuteSysPrereqs = bExecuteSysPrereqs;
        this._bNoConsole = bNoConsole;
        this._bSilent = bSilent;
        this._logLoc = logLoc;
        this._java64BitChecker = new JVMDataModelCheckerImpl(this._ini, "64", "JAVA_USE_64BIT", "S_CHECKING_FOR_JAVA_USE_64BIT", "S_SPASSED_JAVA_USE_64BIT_NOT_REQUIRED");
        if (PlatformHelper.isHpux()) {
            this._hpBundleChecker = new HPBundleCheckerImpl(this._ini);
            this._hpFilesetChecker = new HPFilesetCheckerImpl(this._ini);
        }
        if (PlatformHelper.isLinux()) {
            this._linuxGlibcVersionChecker = new LinuxGlibcVersionCheckerImpl(this._ini);
            this._linuxKernelVersionChecker = new LinuxKernelVersionCheckerImpl(this._ini);
        }
        if (PlatformHelper.isOSDI390()) {
            this._unixGmakeVersionChecker = new UnixGmakeVersionCheckerImpl(this._ini);
            this._unixPerlVersionChecker = new UnixPerlVersionCheckerImpl(this._ini);
        }
        if (PlatformHelper.isWin()) {
            this._windowsCPUChecker = new WindowsCPUCheckerImpl(this._ini);
            this._windowsMinColorsChecker = new WindowsMinColorsCheckerImpl(this._ini);
            this._windowsServicePackChecker = new WindowsServicePackCheckerImpl(this._ini);
            this._windowsSwapChecker = new WindowsSwapCheckerImpl(this._ini);
            this._windowsTempChecker = new WindowsTempCheckerImpl(this._ini, this._scratchLoc);
        }
        if (PlatformHelper.isUnix()) {
            this._unixCPUChecker = new UnixCPUCheckerImpl(this._ini);
            this._unixMinColorsChecker = new UnixMinColorsCheckerImpl(this._ini);
            this._unixPackageChecker = new UnixPackageCheckerImpl(this._ini);
            this._unixPatchChecker = PlatformHelper.isAIX() ? new AIXPatchCheckerImpl(this._ini, this._logLoc) : (PlatformHelper.isLinux() ? new LinuxPatchCheckerImpl(this._ini) : new UnixPatchCheckerImpl(this._ini, this._logLoc));
            this._unixProcessorChecker = new UnixProcessorCheckerImpl(this._ini);
            this._unixSwapChecker = new UnixSwapCheckerImpl(this._ini);
            this._unixTempChecker = new UnixTempCheckerImpl(this._ini, this._scratchLoc);
        }
    }

    private PrereqResult checkPrerequisitesForInstall() throws PrereqException {
        return this.checkBySection("Generic Prereqs");
    }

    private PrereqResult checkBySection(String section) {
        PrereqResult retval = PrereqResult.PREREQ_SUCCESS;
        _logger.finer("Checking section " + section);
        if (PlatformHelper.isUnix()) {
            if (this._unixCPUChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (!this._bSilent && !PlatformHelper.isMac() && this._unixMinColorsChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._unixPackageChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._unixPatchChecker.check(section, null, null) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._unixProcessorChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._unixSwapChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._java64BitChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._unixTempChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (PlatformHelper.isHpux()) {
                if (this._hpBundleChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                    retval = PrereqResult.REQUIRED_FAIL;
                }
                if (this._hpFilesetChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                    retval = PrereqResult.REQUIRED_FAIL;
                }
            }
            if (PlatformHelper.isLinux()) {
                if (this._linuxKernelVersionChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                    retval = PrereqResult.REQUIRED_FAIL;
                }
                if (this._linuxGlibcVersionChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                    retval = PrereqResult.REQUIRED_FAIL;
                }
            }
            if (PlatformHelper.isOSDI390()) {
                if (this._unixGmakeVersionChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                    retval = PrereqResult.REQUIRED_FAIL;
                }
                if (this._unixPerlVersionChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                    retval = PrereqResult.REQUIRED_FAIL;
                }
            }
        } else if (PlatformHelper.isWin()) {
            if (this._windowsCPUChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (!this._bSilent && this._windowsMinColorsChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._windowsServicePackChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._windowsSwapChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._java64BitChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
            if (this._windowsTempChecker.check(section) == PrereqResult.REQUIRED_FAIL) {
                retval = PrereqResult.REQUIRED_FAIL;
            }
        }
        return retval;
    }

    private static String getUserInput() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        try {
            while ((input = br.readLine()) == null) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return input;
    }

    private static boolean isNo(String response) {
        return response != null && (response.length() == 0 || response.substring(0, 1).equalsIgnoreCase("n"));
    }

    private static boolean isYes(String response) {
        return response != null && response.length() != 0 && response.substring(0, 1).equalsIgnoreCase("y");
    }

    private boolean promptContinue() {
        String reply;
        if (this._bSilent || this._bNoConsole) {
            return false;
        }
        do {
            LogUtils.logAndShowMsg("S_CONTINUE", new String[0]);
            reply = PrereqChecks.getUserInput();
            if (!PrereqChecks.isYes(reply)) continue;
            LogUtils.logAndShowMsg("S_CERTIFIED_YES", new String[0]);
            return true;
        } while (!PrereqChecks.isNo(reply));
        LogUtils.logAndShowMsg("S_CERTIFIED_NO", new String[0]);
        return false;
    }

    public static void checkPrereqs(SimpleOraparamIni ini, String scratchLoc, boolean bSilent, boolean bExecuteSysPrereqs, boolean bIgnoreSysPrereqs, boolean bNoConsole, String logLoc) throws PrereqException {
        PrereqChecks pre = new PrereqChecks(ini, scratchLoc, bIgnoreSysPrereqs, bExecuteSysPrereqs, bNoConsole, bSilent, logLoc);
        pre.execute();
    }

    private void execute() throws PrereqException {
        _logger.finer("Starting prerequisite checks");
        PrereqResult retval = this.checkPrerequisitesForInstall();
        if (this._bExecuteSysPrereqs) {
            _logger.finer("Exiting ... generic prerequisite checks completed per -executeSysPrereqs option");
            if (retval != PrereqResult.PREREQ_SUCCESS && retval != PrereqResult.NO_PREREQ_RUN) {
                String msg = NLS.get_mesg("S_FAILED_PRE_REQ_1", new String[0]);
                LogUtils.logAndShow(msg);
                LogUtils.logAndShowMsg("S_EXITING", new String[0]);
                throw new PrereqException(msg);
            }
            LogUtils.logAndShowMsg("S_EXITING", new String[0]);
        } else if (this._bIgnoreSysPrereqs) {
            if (retval != PrereqResult.PREREQ_SUCCESS) {
                LogUtils.logAndShowMsg("S_IGNORE_REQ_SYS_PREREQ", new String[0]);
            }
        } else if (retval != PrereqResult.PREREQ_SUCCESS && retval != PrereqResult.NO_PREREQ_RUN) {
            LogUtils.logAndShowMsg("S_FAILED_PRE_REQ_1", new String[0]);
            LogUtils.logAndShowMsg("S_FAILED_PRE_REQ_2", new String[0]);
            if (this._bSilent || this._bNoConsole || !this.promptContinue()) {
                String msg = NLS.get_mesg("S_FAILED_PRE_REQ", new String[0]);
                throw new PrereqException(msg);
            }
            LogUtils.logAndShow(LS);
        }
    }

    public static enum PrereqResult {
        PREREQ_SUCCESS(0),
        REQUIRED_FAIL(1),
        NO_PREREQ_RUN(3),
        EXIT_FAILURE(-1);

        private final int _result;

        private PrereqResult(int result) {
            this._result = result;
        }

        public int result() {
            return this._result;
        }
    }
}

