/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.ManifestInfo;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.common.inventory.InventoryUtils;
import com.oracle.cie.nextgen.common.utils.Bootstrap;
import com.oracle.cie.nextgen.common.utils.JavaHomeHelper;
import com.oracle.cie.nextgen.common.utils.Util;
import com.oracle.cie.nextgen.common.utils.UtilityOps;
import com.oracle.cie.nextgen.common.version.VersionHelper;
import com.oracle.cie.nextgen.launcher.Launcher;
import com.oracle.cie.nextgen.launcher.LauncherException;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.NLS;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.PostInstallHelper;
import com.oracle.cie.nextgen.launcher.PostInstallHelperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.logging.Logger;

public class Utils {
    private static final Logger _logger = Logger.getLogger(Utils.class.getName());
    private static final String FS = File.separator;
    private static final String POST_INSTALL_HELPER_IMPL = "com.oracle.cie.nextgen.launcher.PostInstallHelperImpl";
    private static final String GET_POST_INSTALL_HELPER = "getPostInstallHelper";
    public static final String INVENTORY_LOC_KEY = "inventory_loc";
    public static final String ORACLE_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    public static final String ORACLE_WOW64_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432NODE\\ORACLE";
    public static final String LOCVALUE = "inst_loc";
    public static final String INVENTORY_DIR = "inventory";
    public static final String ORA_INST_LOC = "oraInst.loc";
    public static final String INV_LOC = "inv.loc";

    private Utils() {
    }

    public static boolean pathWritable(String path) {
        File f = new File(path);
        if (!f.exists() && !f.mkdirs()) {
            return false;
        }
        return f.isDirectory() && f.canRead() && f.canWrite() && f.canExecute();
    }

    public static void delete(String path) {
        if (StringUtil.isNullOrEmpty(path)) {
            return;
        }
        File f = new File(path);
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        _logger.finer("Deleting directory: " + path);
        boolean ret = Delete.delete(f);
        _logger.finer("Delete returns " + ret);
    }

    public static String getCommandLineVariableValue(String arg) {
        if (StringUtil.isNullOrEmpty(arg)) {
            return null;
        }
        String[] arr = arg.split("=");
        if (arr.length < 2) {
            _logger.finer("Can't parse command line variable arg " + arg);
            return null;
        }
        String val = arr[1];
        int len = (val = val.trim()).length();
        if (len > 1 && val.charAt(0) == '\"' && val.charAt(len - 1) == '\"') {
            val = val.substring(1, len - 2);
        }
        return val;
    }

    public static String[] getDistributionToUninstall(String distributionName, String distributionVersion, String oracleHome, boolean isSilent, String logLoc) throws LauncherException {
        PostInstallHelper postInstallHelper = Utils.createPostInstallHelper(oracleHome);
        if (postInstallHelper == null) {
            _logger.severe("Unable to create PostInstallHelper");
            String msg = NLS.get_mesg("S_NO_DISTRIBUTION", oracleHome);
            throw new LauncherException(msg);
        }
        try {
            return postInstallHelper.getDistributionToUninstall(distributionName, distributionVersion, isSilent, logLoc);
        }
        catch (PostInstallHelperException e) {
            _logger.fine(StringUtil.getStackTrace(e));
            throw new LauncherException(e);
        }
    }

    public static String[] getEntitiesToUninstall(String gdrEntitiesNames, String gdrEntitiesVersions, String oracleHome, boolean isSilent, String logLoc) throws LauncherException {
        PostInstallHelper postInstallHelper = Utils.createPostInstallHelper(oracleHome);
        if (postInstallHelper == null) {
            _logger.severe("Unable to create PostInstallHelper");
            String msg = NLS.get_mesg("S_NO_DISTRIBUTION", oracleHome);
            throw new LauncherException(msg);
        }
        try {
            return postInstallHelper.getEntitiesToUninstall(gdrEntitiesNames, gdrEntitiesVersions, isSilent, logLoc);
        }
        catch (PostInstallHelperException e) {
            _logger.fine(StringUtil.getStackTrace(e));
            throw new LauncherException(e);
        }
    }

    private static PostInstallHelper createPostInstallHelper(String oracleHome) {
        String className = POST_INSTALL_HELPER_IMPL;
        try {
            Class<?> clazz = Class.forName(className);
            return (PostInstallHelper)clazz.getMethod(GET_POST_INSTALL_HELPER, String.class).invoke(null, oracleHome);
        }
        catch (InvocationTargetException e) {
            _logger.finer(StringUtil.getStackTrace(e));
            _logger.severe("Unable to invoke " + className + ": " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            _logger.finer(StringUtil.getStackTrace(e));
            _logger.severe("No method getPostInstallHelper: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            _logger.finer(StringUtil.getStackTrace(e));
            _logger.severe("Class " + className + " not found in classpath: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            _logger.finer(StringUtil.getStackTrace(e));
            _logger.severe("Unable to load class " + className + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            _logger.finer(StringUtil.getStackTrace(e));
            _logger.severe("Unable to load class " + className + ": " + e.getMessage());
        }
        return null;
    }

    public static String getFormattedNameVersion(String distributionName, String distributionVersion) {
        return distributionName.replaceAll(" ", "_") + "_" + distributionVersion;
    }

    public static String getFullPath(String basePath, String relativePath) {
        String result = null;
        if (StringUtil.isNullOrEmpty(relativePath)) {
            _logger.finer("getFullPath: relativePath is null or empty");
        } else if (StringUtil.isNullOrEmpty(basePath)) {
            _logger.finer("getFullPath: basePath is null or empty");
        } else if (new File(relativePath).isAbsolute()) {
            _logger.finer("getFullPath: relativePath is absolute: " + relativePath);
        } else {
            try {
                result = new File(basePath, relativePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        _logger.finer("getFullPath(" + basePath + "," + relativePath + ")=" + result);
        return result;
    }

    public static String getAncestorPath(String path, int generation) {
        try {
            File f = new File(path).getCanonicalFile();
            for (int i = 0; i < generation; ++i) {
                if (f == null) {
                    return null;
                }
                f = f.getParentFile();
            }
            if (f != null) {
                return f.getCanonicalPath();
            }
        }
        catch (IOException ioe) {
            _logger.fine("getAncestorPath(" + path + ") caught " + ioe.getMessage());
        }
        return null;
    }

    public static String getOracleHome(String oracleHomeVar, String startupLoc) {
        String result = null;
        result = !StringUtil.isNullOrEmpty(oracleHomeVar) ? oracleHomeVar : Utils.getAncestorPath(startupLoc, 2);
        _logger.fine("getOracleHome=" + result);
        return result;
    }

    public static String getIniDirPath(String oracleHome) {
        if (oracleHome != null) {
            return Utils.getValidDirectory(oracleHome + FS + INVENTORY_DIR + FS + "inis");
        }
        return null;
    }

    public static String getPrereqConfigLoc(String prereqConfigLocOpt, String prereqConfigLocProp, String base) {
        String result = null;
        if (!StringUtil.isNullOrEmpty(prereqConfigLocOpt)) {
            result = new File(prereqConfigLocOpt).isAbsolute() ? Utils.getCanonicalPath(prereqConfigLocOpt) : (base == null ? prereqConfigLocOpt : Utils.getFullPath(base, prereqConfigLocOpt));
        } else if (!StringUtil.isNullOrEmpty(prereqConfigLocProp)) {
            result = base == null ? prereqConfigLocProp : Utils.getFullPath(base, prereqConfigLocProp);
        }
        _logger.finest("getPrereqConfigLoc: " + result);
        return result;
    }

    public static String getCanonicalPath(String path) {
        if (StringUtil.isNullOrEmpty(path)) {
            return null;
        }
        return Util.getCanonicalPath(path);
    }

    public static String getSelfExtractLoc(String tempDir) {
        try {
            File f = File.createTempFile("orcl", ".tmp", new File(tempDir));
            String path = f.getPath();
            if (!f.delete() || !f.mkdirs()) {
                _logger.severe("Failed to delete then create the extract directory: " + path);
                return null;
            }
            if (!(f.isDirectory() && f.canRead() && f.canWrite() && f.canExecute())) {
                _logger.finer("Extract location is not a directory or does not have read/write/execute permissions: " + path);
                return null;
            }
            if (!PlatformHelper.doChmod(path, "0700", false)) {
                _logger.finer("Failed to set mode 0700 on extract location: " + path);
                return null;
            }
            return f.getAbsolutePath();
        }
        catch (IOException ioe) {
            _logger.severe(ioe.getMessage());
            return null;
        }
    }

    public static String getInvPtrLoc(String invPtrLocOpt, boolean useOraInstLocInOracleHome, String oracleHome) {
        String result = PlatformHelper.isWin() ? null : (useOraInstLocInOracleHome ? oracleHome + FS + ORA_INST_LOC : (invPtrLocOpt == null ? PlatformHelper.getDefaultInventoryPointerFile() : invPtrLocOpt));
        return result;
    }

    public static void validatePostInstallOracleHomeLoc(String oracleHome) throws LauncherException {
        if (StringUtil.isNullOrEmpty(oracleHome)) {
            String msg = NLS.get_mesg("S_INVALID_ORACLE_HOME", "null");
            throw new LauncherException(msg);
        }
        File f = new File(oracleHome);
        if (!f.isAbsolute()) {
            String msg = NLS.get_mesg("S_INVALID_ORACLE_HOME_ABS", oracleHome);
            throw new LauncherException(msg);
        }
        if (f.exists() && !f.isDirectory()) {
            String msg = NLS.get_mesg("S_INVALID_ORACLE_HOME", oracleHome);
            throw new LauncherException(msg);
        }
    }

    public static void validateInvPtrLoc(String invPtrLoc) throws LauncherException {
        if (invPtrLoc != null) {
            File f = new File(invPtrLoc);
            if (!f.isAbsolute()) {
                String msg = NLS.get_mesg("S_INVALID_INVPTRLOC_ABS", invPtrLoc);
                throw new LauncherException(msg);
            }
            if (f.isDirectory()) {
                String msg = NLS.get_mesg("S_INVALID_INVPTRLOC_DIR", invPtrLoc);
                throw new LauncherException(msg);
            }
        }
    }

    public static String getInventoryLocation(String invPtrLoc, String invLocVar, boolean centralInventoryIsFixed, String invPtrLocOpt, String oracleHome) {
        String invLoc = null;
        boolean isUnix = PlatformHelper.isUnix();
        if (centralInventoryIsFixed) {
            File f = InventoryUtils.getInvPtrFileForOracleHome(oracleHome, isUnix);
            if (f.exists()) {
                invLoc = Utils.genericGetPrivateProfileString(INVENTORY_LOC_KEY, null, f.getAbsolutePath());
            } else if (isUnix) {
                _logger.severe("Inventory pointer file does not exist: " + f.getAbsolutePath());
            } else {
                invLoc = PlatformHelper.getRegistry(ORACLE_KEY, LOCVALUE);
                if (invLoc == null) {
                    invLoc = PlatformHelper.getRegistry(ORACLE_WOW64_KEY, LOCVALUE);
                }
            }
        } else if (isUnix) {
            if (invLocVar != null) {
                invLoc = invLocVar;
                if (invPtrLocOpt != null) {
                    _logger.warning("INVENTORY_LOCATION command-line variable takes precedence over -invPtrLoc command-line option");
                }
            } else if (invPtrLoc != null) {
                invLoc = Utils.genericGetPrivateProfileString(INVENTORY_LOC_KEY, null, invPtrLoc);
            }
        } else {
            invLoc = PlatformHelper.getRegistry(ORACLE_KEY, LOCVALUE);
            if (invLoc == null) {
                invLoc = PlatformHelper.getRegistry(ORACLE_WOW64_KEY, LOCVALUE);
            }
        }
        return invLoc;
    }

    public static void validateInventoryLoc(String invLoc) throws LauncherException {
        String msg = null;
        if (!StringUtil.isNullOrEmpty(invLoc)) {
            File f = new File(invLoc);
            if (!UtilityOps.isValidPathString(invLoc)) {
                msg = NLS.get_mesg("S_INVALID_INVLOC_CHAR", invLoc);
            } else if (!f.isAbsolute()) {
                msg = NLS.get_mesg("S_INVALID_INVLOC_ABS", invLoc);
            } else if (!f.exists() && !f.mkdirs()) {
                msg = NLS.get_mesg("S_INVALID_INVLOC_CREATE", invLoc);
            } else if (!f.isDirectory()) {
                msg = NLS.get_mesg("S_INVALID_INVLOC_DIR", invLoc);
            } else if (!f.canRead() || !f.canExecute()) {
                msg = NLS.get_mesg("S_INVALID_INVLOC_ACCESS", invLoc);
            } else if (!f.canWrite()) {
                _logger.warning("Can't write Central Inventory directory " + invLoc);
            }
            if (msg == null) {
                for (File file : f.listFiles()) {
                    if (file.canRead() && (!file.isDirectory() || file.canExecute())) continue;
                    msg = NLS.get_mesg("S_INVALID_INVLOC_SUBACCESS", invLoc, file.getAbsolutePath());
                    break;
                }
            }
        }
        if (msg != null) {
            _logger.severe(msg);
            throw new LauncherException(msg);
        }
    }

    public static String getScratchLoc(String rscratchPath) {
        String result;
        try {
            if (!StringUtil.isNullOrEmpty(rscratchPath)) {
                result = Bootstrap.initScratchLoc(new File(rscratchPath));
            } else {
                result = Bootstrap.initScratchLoc();
                if (!PlatformHelper.doChmod(result, "0700", false)) {
                    LogUtils.print_error("S_CANT_CHMOD_SCRATCH", result);
                    result = null;
                }
            }
        }
        catch (IOException e) {
            LogUtils.print_error(e.getMessage(), new String[0]);
            result = null;
        }
        return result;
    }

    public static boolean checkJavaVersion(String requiredVersion, String actualVersion) {
        return VersionHelper.compare(actualVersion = VersionHelper.getVersionPrefix(actualVersion), requiredVersion, 2) >= 0;
    }

    protected static String getJavaHomeForTargetClass(boolean bUseJreOnly, boolean bUseJdkOnly, boolean bPreInstallEnv) throws LauncherException {
        String javaHome = null;
        String msg = null;
        String candidate = System.getProperty("java.home");
        if (!JavaHomeHelper.isJavaHome(candidate)) {
            msg = NLS.get_mesg("S_INVALID_JAVAHOME", candidate);
        } else if (bUseJdkOnly) {
            if (JavaHomeHelper.isJdkHome(candidate)) {
                javaHome = candidate;
            } else {
                String jdkHome = JavaHomeHelper.getJdkHomeFromJreHome(candidate);
                if (jdkHome != null) {
                    javaHome = jdkHome;
                } else {
                    msg = NLS.get_mesg(bPreInstallEnv ? "S_JDK_REQUIRED" : "S_JDK_REQUIRED_POST_INSTALL", candidate);
                }
            }
        } else if (bUseJreOnly) {
            if (JavaHomeHelper.isJdkHome(candidate)) {
                msg = NLS.get_mesg(bPreInstallEnv ? "S_JRE_ONLY_REQUIRED" : "S_JRE_ONLY_REQUIRED_POST_INSTALL", candidate);
            } else {
                String jdkHome = JavaHomeHelper.getJdkHomeFromJreHome(candidate);
                if (jdkHome != null) {
                    msg = NLS.get_mesg(bPreInstallEnv ? "S_JRE_ONLY_REQUIRED" : "S_JRE_ONLY_REQUIRED_POST_INSTALL", jdkHome);
                } else {
                    javaHome = candidate;
                }
            }
        } else {
            javaHome = candidate;
        }
        _logger.fine("getJavaHomeForTargetClass: javaHome=" + javaHome + " msg=" + msg);
        if (javaHome != null) {
            return javaHome;
        }
        if (msg == null) {
            msg = NLS.get_mesg("S_NULL_JAVA_HOME", new String[0]);
        }
        _logger.severe(msg);
        throw new LauncherException(msg);
    }

    static boolean isGenericSfx() {
        return Utils.isGenericSfxJar(ManifestInfo.getRunningJarName(Launcher.class));
    }

    static boolean isPreInstallEnv() {
        if (Utils.isNativeSfx()) {
            return true;
        }
        if (Utils.isGenericSfx()) {
            return true;
        }
        return Utils.isPreInstallShiphome();
    }

    public static String getStartupLoc(String extractLoc, boolean bPreInstallEnv) {
        String startupLoc;
        if (!StringUtil.isNullOrEmpty(extractLoc)) {
            startupLoc = extractLoc + FS + "Disk1" + FS + PlatformHelper.getInstallPath();
        } else {
            String userDir = System.getProperty("user.dir");
            startupLoc = bPreInstallEnv ? userDir + FS + PlatformHelper.getInstallPath() : userDir;
        }
        File f = new File(startupLoc);
        if (!f.exists() && !PlatformHelper.isWin()) {
            _logger.finer("Startup location " + startupLoc + " does not exist; platform is unknown or not supported by this product");
        } else if (!(f.isDirectory() && f.canRead() && f.canExecute())) {
            _logger.severe("Startup location " + startupLoc + " does not exist or is not a directory or does not have sufficient access permission");
            return null;
        }
        return Utils.getCanonicalPath(startupLoc);
    }

    public static String getParamFileLoc(String paramFileLoc, String startupLoc, boolean preInstallEnv, String distributionName, String distributionVersion, String oracleHome) {
        File parent;
        File f;
        String result = null;
        String userDir = null;
        boolean userParamFileError = false;
        if (!StringUtil.isNullOrEmpty(paramFileLoc) && (result = Utils.getValidParamFile(f = new File(paramFileLoc))) == null) {
            LogUtils.logAndShowMsg("S_ERUSR_PARAMFILE_NOT_FOUND", paramFileLoc);
            userParamFileError = true;
        }
        if (preInstallEnv) {
            if (!StringUtil.isNullOrEmpty(startupLoc)) {
                if (result == null) {
                    f = new File(startupLoc, "oraparam.ini");
                    result = Utils.getValidParamFile(f);
                }
                if (result == null && (parent = new File(startupLoc).getParentFile()) != null) {
                    f = new File(parent, "oraparam.ini");
                    result = Utils.getValidParamFile(f);
                }
            }
        } else {
            String iniDir;
            if (result == null && (iniDir = Utils.getIniDirPath(oracleHome)) != null && distributionName != null && distributionVersion != null) {
                String iniName = Utils.getFormattedNameVersion(distributionName, distributionVersion) + ".ini";
                f = new File(iniDir, iniName);
                result = Utils.getValidParamFile(f);
            }
            if (result == null) {
                f = new File(oracleHome + FS + "oui", "oraparam.ini");
                result = Utils.getValidParamFile(f);
            }
        }
        if (result == null) {
            userDir = System.getProperty("user.dir");
            f = new File(userDir, "oraparam.ini");
            result = Utils.getValidParamFile(f);
        }
        if (result == null && (parent = new File(userDir).getParentFile()) != null) {
            f = new File(parent, "oraparam.ini");
            result = Utils.getValidParamFile(f);
        }
        if (result != null) {
            if (userParamFileError) {
                LogUtils.logAndShowMsg("S_DEF_PARAMFILE", result);
            } else {
                LogUtils.writeToInstallLog("S_USING_PARAMFILE", result);
            }
        }
        return result;
    }

    public static void populateVariablesLocForHelp() {
        String variablesLoc;
        String extractLoc = System.getProperty("sfx.extract.path");
        if (!StringUtil.isNullOrEmpty(extractLoc) && (variablesLoc = Utils.getVariablesLoc(extractLoc + FS + "Disk1", true, null, null, null)) != null) {
            System.setProperty("variables.xml.location", variablesLoc);
        }
    }

    public static String getVariablesLoc(String disk1Loc, boolean preInstallEnv, String distributionName, String distributionVersion, String oracleHome) {
        if (preInstallEnv) {
            String variablesDir;
            File[] files;
            if (!StringUtil.isNullOrEmpty(disk1Loc) && (files = Util.getXMLFiles(variablesDir = disk1Loc + FS + "stage" + FS + "variables")) != null) {
                if (files.length == 1) {
                    return files[0].getAbsolutePath();
                }
                if (files.length > 1) {
                    _logger.warning("Unexpected " + files.length + " files in Disk1/stage/variables");
                }
            }
        } else if (!StringUtil.isNullOrEmpty(oracleHome)) {
            String variablesDir = oracleHome + FS + INVENTORY_DIR + FS + "variables";
            if (distributionName != null && distributionVersion != null) {
                File f = new File(variablesDir, Utils.getFormattedNameVersion(distributionName, distributionVersion) + ".xml");
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
            } else {
                File[] files = Util.getXMLFiles(variablesDir);
                if (files != null) {
                    if (files.length == 1) {
                        return files[0].getAbsolutePath();
                    }
                    if (files.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(files[0].getAbsolutePath());
                        for (int i = 1; i < files.length; ++i) {
                            sb.append(",").append(files[i].getAbsolutePath());
                        }
                        return sb.toString();
                    }
                }
            }
        }
        return null;
    }

    private static String getValidParamFile(File f) {
        String path = f.getAbsolutePath();
        if (f.exists() && f.isFile() && f.canRead()) {
            return path;
        }
        LogUtils.writeToInstallLog("S_ERORAPARAMNFD_LOC", path);
        return null;
    }

    public static boolean isValidDirectory(String path) {
        if (StringUtil.isNullOrEmpty(path)) {
            return false;
        }
        File f = new File(path);
        return f.isDirectory() && f.canRead();
    }

    public static String getValidDirectory(String path) {
        String canonical = Utils.getCanonicalPath(path);
        if (Utils.isValidDirectory(canonical)) {
            return canonical;
        }
        _logger.finer("getValidDirectory: invalid path " + path);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromResource(String resource) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = Utils.class.getResourceAsStream(resource);
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException ioe) {
            _logger.finer("Caught exception " + ioe + " trying to load properties from resource " + resource);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName) {
        FileInputStream is = null;
        Properties props = new Properties();
        try {
            is = new FileInputStream(fileName);
            props.load(is);
        }
        catch (FileNotFoundException fnfe) {
            _logger.finer("File not found: " + fileName);
        }
        catch (IOException ioe) {
            _logger.finer("Caught exception " + ioe + " trying to load properties from " + fileName);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
        return props;
    }

    public static String genericGetPrivateProfileString(String key, String defaultValue, String fileName) {
        Properties props = Utils.loadProperties(fileName);
        return props.getProperty(key, defaultValue);
    }

    static boolean isNativeSfx() {
        return !StringUtil.isNullOrEmpty(System.getProperty("sfx.extract.path"));
    }

    static boolean isPreInstallShiphome() {
        String runningJarLoc = ManifestInfo.getRunningJarName(Launcher.class);
        return Utils.isPreInstallShiphome(runningJarLoc);
    }

    static boolean isPreInstallShiphome(String runningJarLoc) {
        String disk1 = Utils.getAncestorPath(runningJarLoc, 3);
        String componentsDir = Utils.getComponentsDir(disk1);
        return componentsDir != null && new File(componentsDir, "oracle.nginst.common").exists();
    }

    static String getComponentsDir(String disk1) {
        if (disk1 != null) {
            return disk1 + FS + "stage" + FS + "Components";
        }
        return null;
    }

    public static boolean isGenericSfxJar(String jar) {
        boolean result = false;
        try {
            JarHelper jarHelper = new JarHelper(jar, 0);
            JarEntry disk1 = jarHelper.getJar().getJarEntry("Disk1/");
            result = disk1 != null && disk1.isDirectory();
        }
        catch (Exception e) {
            _logger.finer("Error accessing jar: " + jar + ", exception " + e);
        }
        _logger.finer("isGenericSfxJar(" + jar + ")=" + result);
        return result;
    }

    public static String stripTrim(String str) {
        if (str == null) {
            return null;
        }
        return StringUtil.stripQuotes(str).trim();
    }

    public static boolean isJavaw() {
        try {
            System.in.available();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public static String getMergedExtClasspath(String extClasspathProp, String oracleHome) {
        File[] iniFiles = null;
        try {
            File iniDir;
            String iniDirPath = Utils.getIniDirPath(oracleHome);
            if (iniDirPath != null && (iniDir = new File(iniDirPath)).exists()) {
                iniFiles = iniDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".ini");
                    }
                });
            }
        }
        catch (SecurityException e) {
            _logger.warning(e.getMessage());
        }
        return Utils.getMergedExtClasspath(iniFiles, extClasspathProp);
    }

    private static String getMergedExtClasspath(File[] iniFiles, String extClasspathProp) {
        String separator = ",";
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        if (!StringUtil.isNullOrEmpty(extClasspathProp)) {
            for (String string : extClasspathProp.split(",")) {
                paths.add(string.trim());
            }
        }
        if (iniFiles != null) {
            for (File file : iniFiles) {
                SimpleOraparamIni ini;
                try {
                    ini = new SimpleOraparamIni(file.getAbsolutePath());
                }
                catch (Exception e) {
                    _logger.warning("Ignoring " + file.getPath() + ": " + e.getMessage());
                    continue;
                }
                HashMap<String, String> map = ini.getSectionMap("Oracle");
                String prop = map.get("EXT_CLASSPATH");
                if (StringUtil.isNullOrEmpty(prop)) continue;
                for (String path : prop.split(",")) {
                    paths.add(path.trim());
                }
            }
        }
        String result = "";
        if (!paths.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String string : paths) {
                builder.append(",");
                builder.append(string);
            }
            result = builder.toString().substring(1);
        }
        return result;
    }

    protected static String getPostInstallOuiLoc(String runningJarLoc) {
        String result = null;
        if (!StringUtil.isNullOrEmpty(runningJarLoc)) {
            result = Utils.getAncestorPath(runningJarLoc, 2);
        }
        return result;
    }
}

