/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;

public class CertifiedVersionCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    protected String _actual;

    public CertifiedVersionCheckerImpl(SimpleOraparamIni ini, String oskey) {
        super(ini, oskey, "S_CHECKING_FOR_OS_VERSION", "S_INVALID_OS_VERSION_REQ");
    }

    @Override
    protected boolean isValid(String required) {
        for (String version : required.split(",")) {
            if (!PlatformHelper.isLinux() || version.indexOf("-") != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getActual(String required) {
        this._actual = this.getActualVersion(required);
        if (this._actual == null) {
            LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
        }
        return this._actual;
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        if (!(actual instanceof String)) {
            return false;
        }
        if (PlatformHelper.isAIX()) {
            String[] arr = ((String)actual).split("-");
            String aixVersion = arr[0];
            int aixMaint = 0;
            if (arr.length > 1) {
                try {
                    aixMaint = Integer.parseInt(arr[1]);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            for (String req : required.split(",")) {
                arr = req.trim().split("-");
                String reqVersion = arr[0];
                int reqMaint = 0;
                if (arr.length > 1) {
                    try {
                        reqMaint = Integer.parseInt(arr[1]);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (!reqVersion.equals(aixVersion) || aixMaint < reqMaint) continue;
                this._actual = req;
                return true;
            }
        } else {
            for (String req : required.split(",")) {
                if (!req.trim().equals(actual)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getActualVersion(String certifiedVersions) {
        _logger.finer("getActualVersion: certifiedVersions=" + certifiedVersions);
        String actual = null;
        if (PlatformHelper.isUnix()) {
            String unixVersion = this.getUnixVersionForIni();
            _logger.finer("unixVersion: " + unixVersion);
            if (PlatformHelper.isLinux()) {
                for (String cert : certifiedVersions.split(",")) {
                    boolean useNewCheck;
                    cert = cert.trim();
                    String[] arr = cert.trim().split("-");
                    String linuxVendor = arr[0];
                    String linuxVersion = arr[1];
                    char initial = linuxVersion.charAt(0);
                    boolean bl = useNewCheck = initial >= '0' && initial <= '9';
                    if (useNewCheck) {
                        if (!linuxVersion.equals(unixVersion)) continue;
                        actual = cert;
                    } else {
                        String vendorFile = String.format("/etc/%1$s-release", linuxVendor);
                        File f = new File(vendorFile);
                        if (!f.exists()) continue;
                        actual = cert;
                    }
                    break;
                }
            } else {
                actual = unixVersion;
            }
        } else {
            actual = System.getProperty("os.version");
        }
        _logger.finer("Actual OS version: " + actual);
        return actual;
    }

    public String getActual() {
        return this._actual;
    }

    protected String getUnixVersionForIni() {
        String[] arr;
        String unixVersion = System.getProperty("os.version");
        if (PlatformHelper.isSolaris()) {
            return unixVersion;
        }
        String cmd = PlatformHelper.getCommand("OSVERSION_CMD");
        if (!PlatformHelper.isExecutable(cmd)) {
            return unixVersion;
        }
        _logger.finer("Executing OS version command=" + cmd);
        List<String> output = PlatformHelper.getCommandOutputInEnglish(cmd);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            _logger.finer("Command output not usable, using default value: " + unixVersion);
            return unixVersion;
        }
        String line1 = output.get(0);
        if (PlatformHelper.isLinux()) {
            int idx = line1.indexOf(":");
            if (idx != -1) {
                unixVersion = line1.substring(idx + 1).trim();
            }
        } else if (PlatformHelper.isAIX()) {
            if (line1.indexOf("-") != -1) {
                unixVersion = line1;
            } else {
                cmd = PlatformHelper.getCommand("OSVERSION_CMD2");
                if (!PlatformHelper.isExecutable(cmd)) {
                    return unixVersion;
                }
                _logger.finer("Executing OS version command=" + cmd);
                output = PlatformHelper.getCommandOutputInEnglish(cmd);
                if (!PlatformHelper.isUsableCommandOutput(output)) {
                    return unixVersion;
                }
                line1 = output.get(0);
                unixVersion = line1.replaceAll("\\D", "");
            }
        } else if (PlatformHelper.isOSF() && (arr = line1.split("\\s+")).length > 3) {
            unixVersion = arr[3];
        }
        return unixVersion;
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        LogUtils.logAndShowMsg("S_SFAILED_ON_NEWLINE", new String[0]);
        String msg = this.getFromIni(section, "CERTIFIED_VERSION_FAILURE_MESSAGE");
        if (msg != null) {
            LogUtils.logMsg(msg);
        }
    }
}

