/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractCommandPerRequirementChecker;
import java.util.List;
import java.util.logging.Logger;

public class HPBundleCheckerImpl
extends AbstractCommandPerRequirementChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    private String _bundleName;
    private String _bundleVersion;

    public HPBundleCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "BUNDLE", "S_CHECKING_FOR_BUNDLE", "S_INVALID_BUNDLE_FORMAT");
        this._failedMsgKey = "S_CHECK_FOR_BUNDLE_FAILED";
    }

    @Override
    protected boolean isValid(String required) {
        String[] arr = required.split(":");
        if (arr.length != 2) {
            LogUtils.logAndShowMsg(this._invalidRequirementMsgKey, required);
            return false;
        }
        this._bundleName = arr[0];
        this._bundleVersion = arr[1];
        return true;
    }

    @Override
    protected Object getActual(String required) {
        List<String> output = this.getCommandOutput(this._iniKey, this._bundleName, true);
        if (PlatformHelper.isUsableCommandOutput(output)) {
            return output;
        }
        return null;
    }

    @Override
    protected boolean meetsRequirement(String required, Object output) {
        for (String line : (List)output) {
            if (!line.contains(this._bundleVersion)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        LogUtils.printLS();
        for (String req : this._failed) {
            String[] arr = req.split(":");
            LogUtils.logAndShowMsg("S_CHECK_FOR_BUNDLE_FAILED", arr[0], arr[1]);
        }
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
    }
}

