/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.PrereqChecks;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class UnixPatchCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    protected String _logLoc;

    public UnixPatchCheckerImpl(SimpleOraparamIni ini, String logLoc) {
        super(ini, "PATCHES", "S_CHECKING_FOR_PATCHES", null);
        this._failedMsgKey = null;
        this._logLoc = logLoc;
        this._choiceList = false;
    }

    @Override
    public PrereqChecks.PrereqResult check(String section, String reqSection, String optSection) {
        this._logToConsole = Boolean.parseBoolean(this.getFromIni("LOG_PATCHES_TO_CONSOLE", section, reqSection, optSection));
        _logger.finer("section=" + section + " reqSection=" + reqSection + " optSection=" + optSection + " _logToConsole=" + this._logToConsole);
        this._checkingMsgKey = !this._logToConsole ? "S_CHECKING_FOR_PATCHES_NO_LIST" : "S_CHECKING_FOR_PATCHES";
        this._reqSection = reqSection;
        this._optSection = optSection;
        return this.check(section);
    }

    @Override
    protected Object getActual(String required) {
        List<String> output = this.getCommandOutput(this._iniKey, true);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
            return null;
        }
        _logger.finest("Command output:");
        for (String line : output) {
            _logger.finest("line: " + line);
        }
        return output;
    }

    @Override
    protected boolean meetsRequirement(String required, Object output) {
        boolean retval = true;
        if (PlatformHelper.isHpux() || PlatformHelper.isOSF()) {
            for (String patch : required.split(",")) {
                boolean found = false;
                for (String line : (List)output) {
                    if (line.indexOf(patch) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                retval = false;
                LogUtils.logAndShowMsg("S_CHECK_FOR_PATCH_FAILED", patch);
            }
        } else {
            if (PlatformHelper.isLinux()) {
                return true;
            }
            ArrayList<String> actPatches = new ArrayList<String>();
            ArrayList<String> obsoletePatches = new ArrayList<String>();
            for (String line : (List)output) {
                _logger.finest("Considering line: " + line);
                if (!line.startsWith("Patch: ")) continue;
                String[] arr = line.split(" ");
                String patchId = arr[1];
                actPatches.add(patchId);
                if (arr.length <= 3 || !arr[2].equals("Obsoletes:")) continue;
                for (int i = 3; i < arr.length && !(patchId = arr[i]).equals("Requires:"); ++i) {
                    if (patchId.endsWith(",")) {
                        patchId = patchId.substring(0, patchId.length() - 1);
                    }
                    obsoletePatches.add(patchId);
                }
            }
            LogUtils.printLS();
            for (String patch : required.split(",")) {
                LogUtils.logAndShowMsg("S_CHECKING_FOR_PATCH", patch);
                if (actPatches.contains(patch)) {
                    LogUtils.logAndShowMsg("S_FOUND_PATCH", patch);
                    continue;
                }
                if (obsoletePatches.contains(patch)) {
                    LogUtils.logAndShowMsg("S_OBSOLETED_PATCH", patch);
                    continue;
                }
                String found = this.isHigherPatchInstalled(patch, actPatches);
                if (found != null) {
                    LogUtils.logAndShowMsg("S_FOUND_PATCH", found);
                    continue;
                }
                found = this.isHigherPatchInstalled(patch, obsoletePatches);
                if (found != null) {
                    LogUtils.logAndShowMsg("S_OBSOLETED_PATCH", found);
                    continue;
                }
                retval = false;
                LogUtils.logAndShowMsg("S_NOT_FOUND_PATCH", patch);
            }
        }
        return retval;
    }

    protected String isHigherPatchInstalled(String requiredPatch, List<String> actualPatches) {
        String[] arr = requiredPatch.split("-");
        String reqBase = arr[0];
        String reqSuffix = null;
        if (arr.length > 1) {
            reqSuffix = arr[1];
        }
        for (String actualPatch : actualPatches) {
            arr = actualPatch.split("-");
            String actBase = arr[0];
            String actSuffix = null;
            if (arr.length > 1) {
                actSuffix = arr[1];
            }
            if (!reqBase.equals(actBase) || reqSuffix != null && reqSuffix.compareTo(actSuffix) > 0) continue;
            _logger.finer("isHigherPatchInstalled: requiredPatch=" + requiredPatch + "actualPatch=" + actualPatch);
            return actualPatch;
        }
        return null;
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        String msg = this.getFromIni("PATCHES_FAILURE_MESSAGE", section, this._reqSection, this._optSection);
        if (msg != null) {
            LogUtils.logMsg(msg);
        }
    }
}

