/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.List;
import java.util.logging.Logger;

public class UnixPerlVersionCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    protected UnixPerlVersionCheckerImpl() {
    }

    public UnixPerlVersionCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "PERL", "S_CHECKING_FOR_PERL_VERSION", null);
    }

    @Override
    protected String getActual(String required) {
        List<String> output = this.getCommandOutput("WHENCE", "perl", false);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        String perlPath = output.get(0);
        if (!PlatformHelper.isUsableCommandOutput(output = this.getCommandOutput(this._iniKey, perlPath, false))) {
            LogUtils.logAndShowMsg("S_UNKNOWN_ACTUAL", new String[0]);
            return null;
        }
        String[] arr = required.split(",");
        for (String line : output) {
            if (line.indexOf("This is perl") == -1) continue;
            for (String req : arr) {
                if (line.indexOf(req) == -1) continue;
                _logger.info("Found matching version on line: " + line);
                return req;
            }
        }
        LogUtils.logAndShowMsg("S_PERL_WRONG_VERSION_MSG", required);
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
        return null;
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        return true;
    }
}

