/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractLongChecker;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class UnixSwapCheckerImpl
extends AbstractLongChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");
    public static final String TOTAL_SWAP_MESSAGE = "Total swap allocation";

    public UnixSwapCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "SWAP_SPACE", "S_CHECKING_FOR_SWAP_SPACE", "S_INVALID_SWAP_SPACE_REQ");
        this._actualMsgKey = "S_ACTUAL_SWAP";
    }

    @Override
    protected String getActual(String required) {
        List<String> output = this.getCommandOutput(this._iniKey);
        if (!PlatformHelper.isUsableCommandOutput(output)) {
            return null;
        }
        this._act = this.parseSwapOutput(output);
        return Long.toString(this._act);
    }

    private long parseSwapOutput(List<String> output) {
        if (PlatformHelper.isHpux()) {
            return this.parseSwapOutputForHpux(output);
        }
        if (PlatformHelper.isLinux()) {
            return this.parseSwapOutputForLinux(output);
        }
        if (PlatformHelper.isOSF()) {
            return this.parseSwapOutputForOSF(output);
        }
        if (PlatformHelper.isAIX()) {
            return this.parseSwapOutputForAIX(output);
        }
        if (PlatformHelper.isMac()) {
            return this.parseSwapOutputForMac(output);
        }
        return this.parseSwapOutputForOtherUnix(output);
    }

    private long parseSwapOutputForHpux(List<String> output) {
        long swap;
        block2: {
            swap = 0L;
            Iterator<String> iterator = output.iterator();
            if (!iterator.hasNext()) break block2;
            String line = iterator.next();
            try {
                swap += (long)Integer.parseInt(line);
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse swap on line " + line);
            }
        }
        return swap;
    }

    private long parseSwapOutputForLinux(List<String> output) {
        long swap = 0L;
        for (int i = 1; i < output.size(); ++i) {
            String[] arr = output.get(i).split("\\s+");
            if (arr.length <= 2) continue;
            try {
                swap += (long)Integer.parseInt(arr[2]);
                continue;
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse swap on line " + output.get(i));
            }
        }
        return swap / 1024L;
    }

    private long parseSwapOutputForOSF(List<String> output) {
        long swap = 0L;
        int len = output.size();
        for (int i = 0; i < len; ++i) {
            String[] arr;
            if (output.get(i).indexOf(TOTAL_SWAP_MESSAGE) == -1) continue;
            if (i + 3 >= len || (arr = output.get(i + 3).split("\\s+")).length <= 2) break;
            try {
                swap += (long)Integer.parseInt(arr[2]);
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse swap on line " + output.get(i + 3));
            }
            break;
        }
        return swap;
    }

    private long parseSwapOutputForAIX(List<String> output) {
        long swap = 0L;
        for (int i = 1; i < output.size(); ++i) {
            String line = output.get(i);
            String[] arr = line.split("\\s+");
            if (arr.length <= 3 || !arr[3].contains("MB")) continue;
            String token = arr[3];
            try {
                swap += (long)Integer.parseInt(token.substring(0, token.length() - 2));
                continue;
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse swap on line " + line);
            }
        }
        return swap;
    }

    private long parseSwapOutputForMac(List<String> output) {
        String[] arr;
        long swap = 0L;
        if (output.size() == 2 && (arr = output.get(1).split("\\s+")).length > 3) {
            try {
                swap = Integer.parseInt(arr[3]);
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse swap on line " + output.get(1));
            }
        }
        return swap;
    }

    private long parseSwapOutputForOtherUnix(List<String> output) {
        long swap = 0L;
        String line = output.get(0);
        String[] arr = line.split("\\s+");
        for (int i = 0; i < arr.length; ++i) {
            String token = arr[i];
            if (!token.equals("=") && !token.equals("used,") || i + 1 >= arr.length) continue;
            token = arr[i + 1];
            int kidx = token.indexOf("k");
            int midx = token.indexOf("m");
            int gidx = token.indexOf("g");
            if (kidx != -1) {
                token = token.substring(0, kidx);
            } else if (midx != -1) {
                token = token.substring(0, midx);
            } else if (gidx != -1) {
                token = token.substring(0, gidx);
            }
            try {
                int tmp = Integer.parseInt(token);
                if (kidx != -1) {
                    swap += (long)(tmp / 1024);
                    continue;
                }
                if (gidx != -1) {
                    swap += (long)(tmp * 1024);
                    continue;
                }
                swap += (long)tmp;
                continue;
            }
            catch (NumberFormatException nfe) {
                _logger.finer("Can't parse swap on line " + line);
            }
        }
        return swap;
    }
}

