/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractLongChecker;

public class WindowsCPUCheckerImpl
extends AbstractLongChecker {
    protected WindowsCPUCheckerImpl() {
    }

    public WindowsCPUCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "CPU", "S_CHECKING_FOR_CPU", "S_INVALID_CPU_REQ");
    }

    @Override
    protected Object getActual(String required) {
        String actual = PlatformHelper.getCPUSpeed();
        try {
            this._act = Long.parseLong(actual);
            return actual;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        String msg = this.getFromIni("CPU_FAILURE_MESSAGE", section, this._reqSection, this._optSection);
        if (msg != null) {
            LogUtils.logMsg(msg);
        }
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
    }
}

