/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractLongChecker;
import java.util.logging.Logger;

public class WindowsMinColorsCheckerImpl
extends AbstractLongChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    public WindowsMinColorsCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "MIN_DISPLAY_COLORS", "S_CHECKING_FOR_DISP_COL", "S_INVALID_DISP_COL_REQ");
    }

    @Override
    protected String getActual(String required) {
        int bitsPerPixel = PlatformHelper.getWindowsDisplayBitsPerPixel();
        this._act = Math.round(Math.pow(2.0, bitsPerPixel));
        _logger.finer("Windows bitsPerPixel=" + this._act + " required=" + required);
        return Long.toString(this._act);
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        String msg = this.getFromIni("MIN_DISPLAY_COLORS_FAILURE_MESSAGE", section, this._reqSection, this._optSection);
        if (msg != null) {
            LogUtils.logMsg(msg);
        }
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
    }
}

