/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.launcher.checker;

import com.oracle.cie.nextgen.common.ini.SimpleOraparamIni;
import com.oracle.cie.nextgen.launcher.LogUtils;
import com.oracle.cie.nextgen.launcher.PlatformHelper;
import com.oracle.cie.nextgen.launcher.checker.AbstractChecker;
import java.util.logging.Logger;

public class WindowsServicePackCheckerImpl
extends AbstractChecker {
    private static final Logger _logger = Logger.getLogger("com.oracle.cie");

    public WindowsServicePackCheckerImpl(SimpleOraparamIni ini) {
        super(ini, "SERVICE_PACK", "S_CHECKING_FOR_SERVICE_PACK", "not used");
    }

    @Override
    protected String getActual(String required) {
        int majorVersion = PlatformHelper.getMajorVersion();
        String tmp = PlatformHelper.getServicePack();
        _logger.finer("getServicePack: " + tmp);
        String[] arr = tmp.split(" ");
        String actual = arr[2];
        if (majorVersion == 4 && tmp.equals("Service Pack 6") && PlatformHelper.isServicePack6a()) {
            actual = "6a";
        }
        return actual;
    }

    @Override
    protected boolean meetsRequirement(String required, Object actual) {
        String[] arr;
        if (!(actual instanceof String)) {
            return false;
        }
        for (String req : arr = required.split(",")) {
            if (!req.equalsIgnoreCase((String)actual)) continue;
            return true;
        }
        return arr.length == 1 && ((String)actual).compareTo(required) > 0;
    }

    @Override
    protected void emitFinalFailedMsg(String section) {
        String msg = this.getFromIni("SERVICE_PACK_FAILURE_MESSAGE", section, this._reqSection, this._optSection);
        if (msg != null) {
            LogUtils.logMsg(msg);
        }
        LogUtils.logAndShowMsg("S_SFAILED", new String[0]);
    }
}

