/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.wizard.gui.tasks;

import com.oracle.cie.common.ui.gui.GUIHelper;
import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.selection.Selectable;
import com.oracle.cie.gdr.selection.SelectableDistribution;
import com.oracle.cie.gdr.selection.SelectableFeatureSet;
import com.oracle.cie.gdr.selection.SelectableFeatureSetGroup;
import com.oracle.cie.nextgen.launcher.PostInstallHelperException;
import com.oracle.cie.nextgen.launcher.PostInstallHelperImpl;
import com.oracle.cie.nextgen.wizard.gui.components.FeatureSetUninstallSelectionTree;
import com.oracle.cie.nextgen.wizard.gui.listeners.FeatureUninstallSelectedCountListener;
import com.oracle.cie.nextgen.wizard.gui.listeners.FeatureUninstallSelectionListener;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import com.oracle.cie.wizard.gui.tasks.AbstractGUITask;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@TaskDescription(name="uninstall_gui")
public class DistributionUninstallTask
extends AbstractGUITask
implements FeatureUninstallSelectionListener,
FeatureUninstallSelectedCountListener {
    private String _oracleHome;
    private JPanel _featuresPanel;
    private JPanel _distributionPanel;
    private Distribution _currentDistribution;
    private Distribution _refreshedDistribution;
    private Set<QuickReference> _selectedDistributions = new HashSet<QuickReference>();
    private Map<QuickReference, Set<QuickReference>> _selectedFeatureSets = new HashMap<QuickReference, Set<QuickReference>>();
    private HashMap<Distribution, FeatureSetUninstallSelectionTree> _distributionTrees = new HashMap();
    private Map<Distribution, JLabel> _countSelectedFeaturesLabels;
    private PostInstallHelperImpl _helper;
    private JButton _selectAllButton;
    private JButton _unselectAllButton;
    private ButtonGroup _distributionsGroup;
    private List<JRadioButton> _distButtons = new ArrayList<JRadioButton>();
    private boolean hasMessagePanelWarning = false;
    private boolean _selectAll = false;
    private boolean _useOldSelectionGUI = true;
    private boolean _uninstallButtonEnabled = false;
    private JComboBox _distributionsCombo;
    private Distribution _selectedDistribution;

    public void configure(GUITaskContext context) throws TaskExecutionException {
        super.configure((TaskContext)context);
        this._oracleHome = ObjectStoreManager.getObjectStore().getString("ORACLE_HOME");
        try {
            this._helper = PostInstallHelperImpl.getPostInstallHelperImpl(this._oracleHome);
        }
        catch (PostInstallHelperException e) {
            this._logger.log(Level.SEVERE, "Could not load the inventory for the Oracle Home: " + this._oracleHome, e);
            throw new TaskExecutionException((Task)this, e.getMessage());
        }
        if (this._helper.isEnhancedUninstallSupported()) {
            this._useOldSelectionGUI = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JComponent createUI() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        if (this._useOldSelectionGUI) {
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.insets.top = 6;
            gbc.insets.left = 10;
            gbc.insets.bottom = 4;
            gbc.insets.right = 10;
            this._featuresPanel = new JPanel(new GridBagLayout());
            JPanel distributionPanel = this.buildOldDistributionPanel();
            panel.add((Component)distributionPanel, gbc);
            ++gbc.gridy;
            panel.add((Component)new JSeparator(0), gbc);
            gbc.insets.bottom = 0;
            gbc.insets.top = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            ++gbc.gridy;
            gbc.ipady = 0;
            gbc.fill = 1;
            Distribution distribution = this.getDefaultUninstallableDistribution();
            if (distribution == null) {
                distribution = this.getAnyDistribution();
                if (distribution == null) throw new IllegalStateException("No distributions are installed in Oracle Home " + this._oracleHome);
                this._distributionsCombo.setSelectedItem(distribution);
                if (this._distributionsCombo.getSelectedIndex() == 0) {
                    this.buildCannotUninstallPanel(distribution);
                }
            } else {
                this._distributionsCombo.setSelectedItem(distribution);
                if (this._distributionsCombo.getSelectedIndex() == 0) {
                    this.buildOldFeaturesPanel(distribution);
                }
            }
            this._selectedDistribution = distribution;
            JScrollPane pane = new JScrollPane(this._featuresPanel);
            pane.setWheelScrollingEnabled(true);
            pane.setBorder(null);
            gbc.weighty = 1.0;
            gbc.fill = 1;
            panel.add((Component)pane, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            return panel;
        }
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.fill = 3;
        gbc.insets.top = 6;
        gbc.insets.left = 10;
        gbc.insets.bottom = 4;
        gbc.insets.right = 10;
        this._featuresPanel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.label.chooseDistribution.text")), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 3;
        gbc.gridwidth = 2;
        gbc.fill = 3;
        this._distributionPanel = this.buildDistributionPanel();
        JScrollPane distributionPane = new JScrollPane(this._distributionPanel);
        distributionPane.setWheelScrollingEnabled(true);
        distributionPane.setBorder(null);
        distributionPane.setHorizontalScrollBarPolicy(31);
        panel.add((Component)this._distributionPanel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 6;
        gbc.gridwidth = 1;
        gbc.fill = 3;
        gbc.anchor = 17;
        JSeparator separator = new JSeparator(1);
        Dimension d = new Dimension(1, 1);
        d.height = panel.getPreferredSize().height;
        separator.setPreferredSize(d);
        panel.add((Component)separator, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipady = 0;
        gbc.fill = 1;
        gbc.insets.top = 6;
        gbc.insets.left = 10;
        gbc.insets.bottom = 4;
        gbc.insets.right = 10;
        this.init();
        int uninstablableIndex = 0;
        for (Distribution distribution : this._helper.getInstalledDistributions()) {
            QuickReference distReference = new QuickReference(distribution.getName(), distribution.getVersion());
            try {
                if (this._helper.isDistributionUninstallable(this._selectedFeatureSets, this._selectedDistributions, distReference)) {
                    this._currentDistribution = distribution;
                    this._distButtons.get(uninstablableIndex).setSelected(true);
                    break;
                }
            }
            catch (PostInstallHelperException e) {
                this._logger.log(Level.SEVERE, "Could not verify if distribution " + distReference + " is Uninstallable", e);
            }
            ++uninstablableIndex;
        }
        if (this._currentDistribution == null) {
            this._currentDistribution = this._helper.getInstalledDistributions().get(0);
            this._distButtons.get(0).setSelected(true);
        }
        this.buildFeaturesPanel(this._currentDistribution);
        JScrollPane featuresetsPane = new JScrollPane(this._featuresPanel);
        featuresetsPane.setWheelScrollingEnabled(true);
        featuresetsPane.setBorder(null);
        panel.add((Component)featuresetsPane, gbc);
        JPanel buttonsPanel = this.getSelectAndUnselectAllButtonsPanel();
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weighty = 0.1;
        gbc.anchor = 16;
        gbc.fill = 0;
        panel.add((Component)buttonsPanel, gbc);
        return panel;
    }

    public void postConfigureUI() {
        ((GUITaskContext)this._context).setEnabledButtonState(GUITaskContext.ButtonType.FINISH, this._uninstallButtonEnabled);
    }

    public boolean okPrev() {
        return true;
    }

    public boolean okNext() {
        if (this._useOldSelectionGUI) {
            ObjectStoreManager.getObjectStore().storeObject("DISTRIBUTION_NAME", this._selectedDistribution.getName());
            ObjectStoreManager.getObjectStore().storeObject("DISTRIBUTION_VERSION", this._selectedDistribution.getVersion());
        } else {
            if (this._selectedFeatureSets.isEmpty() && this._selectedDistributions.isEmpty()) {
                JComponent[] list = null;
                ((GUITaskContext)this._context).addValidationMessage(MessageType.WARNING, ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.message.noSelectedDistributions.text"), ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.message.noSelectedDistributions.text"), list);
                this.hasMessagePanelWarning = true;
                return false;
            }
            Map<QuickReference, Set<QuickReference>> featureSets = this.getIndividualSelectedFeatureSets();
            String featuresetName = "";
            String featuresetVersion = "";
            String distributionName = "";
            String distributionVersion = "";
            ArrayList<QuickReference> allDistributions = new ArrayList<QuickReference>();
            for (Distribution dist : this._helper.getInstalledDistributions()) {
                allDistributions.add(new QuickReference(dist.getName(), dist.getVersion()));
            }
            if (featureSets != null && !featureSets.isEmpty()) {
                for (QuickReference selection : featureSets.keySet()) {
                    for (QuickReference distributionSelection : featureSets.get(selection)) {
                        featuresetName = featuresetName + distributionSelection.getName() + ":" + selection.getName() + ",";
                        featuresetVersion = featuresetVersion + distributionSelection.getVersion() + ":" + selection.getVersion() + ",";
                    }
                }
                featuresetName = featuresetName.substring(0, featuresetName.length() - 1);
                featuresetVersion = featuresetVersion.substring(0, featuresetVersion.length() - 1);
                ObjectStoreManager.getObjectStore().storeObject("FEATURESET_NAME", featuresetName);
                ObjectStoreManager.getObjectStore().storeObject("FEATURESET_VERSION", featuresetVersion);
            }
            if (this._selectedDistributions != null && !this._selectedDistributions.isEmpty()) {
                for (QuickReference distributionSelection : this._selectedDistributions) {
                    distributionName = distributionName + distributionSelection.getName() + ",";
                    distributionVersion = distributionVersion + distributionSelection.getVersion() + ",";
                }
                distributionName = distributionName.substring(0, distributionName.length() - 1);
                distributionVersion = distributionVersion.substring(0, distributionVersion.length() - 1);
                ObjectStoreManager.getObjectStore().storeObject("DISTRIBUTION_NAME", distributionName);
                ObjectStoreManager.getObjectStore().storeObject("DISTRIBUTION_VERSION", distributionVersion);
            }
        }
        return true;
    }

    protected JPanel buildDistributionPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel distributionPanel = new JPanel(new GridBagLayout());
        distributionPanel.setFocusable(true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.insets.left = 10;
        gbc.fill = 1;
        gbc.insets.bottom = 6;
        this._distributionsGroup = new ButtonGroup();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (JRadioButton button : DistributionUninstallTask.this._distButtons) {
                    if ((JRadioButton)e.getSource() != button) continue;
                    DistributionUninstallTask.this._currentDistribution = DistributionUninstallTask.this._helper.getInstalledDistributions().get(DistributionUninstallTask.this._distButtons.indexOf(button));
                    DistributionUninstallTask.this.buildFeaturesPanel(DistributionUninstallTask.this._currentDistribution);
                }
            }
        };
        this._countSelectedFeaturesLabels = new HashMap<Distribution, JLabel>();
        for (Distribution distribution : this._helper.getInstalledDistributions()) {
            JRadioButton item = new JRadioButton(distribution.getDescription() + " " + distribution.getVersion());
            item.addActionListener(listener);
            this._distButtons.add(item);
            this._distributionsGroup.add(item);
            distributionPanel.add((Component)item, gbc);
            ++gbc.gridy;
            gbc.insets.left = 20;
            JLabel fsCountLabel = new JLabel(((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.label.selectedFeatures.text"));
            Font labelFont = UIManager.getDefaults().getFont("Label.font");
            fsCountLabel.setFont(labelFont.deriveFont(11.0f));
            fsCountLabel.setForeground(Color.gray);
            fsCountLabel.setVisible(false);
            this._countSelectedFeaturesLabels.put(distribution, fsCountLabel);
            distributionPanel.add((Component)fsCountLabel, gbc);
            ++gbc.gridy;
            gbc.insets.left = 10;
        }
        return distributionPanel;
    }

    protected JPanel getSelectAndUnselectAllButtonsPanel() {
        this.buildSelectAllButton();
        this.buildUnselectAllButton();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.fill = 0;
        buttonsPanel.add((Component)this._unselectAllButton, gbc);
        ++gbc.gridx;
        gbc.insets.left = 8;
        buttonsPanel.add((Component)this._selectAllButton, gbc);
        return buttonsPanel;
    }

    protected void buildSelectAllButton() {
        this._selectAllButton = new JButton();
        GUIUtilities.configureButton(this._selectAllButton, ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.button.selectAll.text"), ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.button.selectAll.tooltip.text"));
        ActionListener selectAllListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributionUninstallTask.this.unselectAllDistributions();
                List<Distribution> installedDists = DistributionUninstallTask.this._helper.getInstalledDistributions();
                ListIterator<Distribution> li = installedDists.listIterator(installedDists.size());
                DistributionUninstallTask.this._selectAll = true;
                HashSet<QuickReference> installedDistsRefs = new HashSet<QuickReference>();
                for (Distribution distro : installedDists) {
                    installedDistsRefs.add(new QuickReference(distro.getName(), distro.getVersion()));
                }
                while (li.hasPrevious()) {
                    FeatureSetUninstallSelectionTree tree = (FeatureSetUninstallSelectionTree)DistributionUninstallTask.this._distributionTrees.get(li.previous());
                    tree.toggleSelected(new TreePath(tree.getModel().getRoot()));
                }
                DistributionUninstallTask.this._selectAll = false;
                if (DistributionUninstallTask.this._selectedFeatureSets.isEmpty() && !DistributionUninstallTask.this._selectedDistributions.containsAll(installedDistsRefs)) {
                    ((GUITaskContext)DistributionUninstallTask.this._context).addValidationMessage(MessageType.WARNING, ((GUITaskContext)DistributionUninstallTask.this._context).getI18nString(DistributionUninstallTask.this._namespace, "DistributionUninstallTask.warning.selectAll.text"), ((GUITaskContext)DistributionUninstallTask.this._context).getI18nString(DistributionUninstallTask.this._namespace, "DistributionUninstallTask.warning.selectAll.text"), new JComponent[1]);
                    DistributionUninstallTask.this.unselectAllDistributions();
                }
                DistributionUninstallTask.this.updateMessagePanel();
            }
        };
        this._selectAllButton.addActionListener(selectAllListener);
    }

    protected void buildUnselectAllButton() {
        this._unselectAllButton = new JButton();
        GUIUtilities.configureButton(this._unselectAllButton, ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.button.unselectAll.text"), ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.button.unselectAll.tooltip.text"));
        ActionListener unselectAllListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DistributionUninstallTask.this.unselectAllDistributions();
                DistributionUninstallTask.this.updateMessagePanel();
            }
        };
        this._unselectAllButton.addActionListener(unselectAllListener);
    }

    protected void buildFeaturesPanel(Distribution distribution) {
        if (this._featuresPanel == null) {
            throw new IllegalStateException("_featuresPanel is null");
        }
        this._featuresPanel.setVisible(false);
        this._featuresPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.insets.top = 6;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.insets.left = 10;
        gbc.fill = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets.bottom = 6;
        this._featuresPanel.add((Component)new JLabel(((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.label.distributionContent.text")), gbc);
        if (distribution != null) {
            ++gbc.gridy;
            if (this._distributionTrees.get(distribution) == null) {
                this.createFeatureSetUninstallSelectionTree(distribution);
            }
            FeatureSetUninstallSelectionTree tree = this._distributionTrees.get(distribution);
            this.refreshDisabledSelectables();
            this._featuresPanel.add((Component)tree, gbc);
        }
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.weighty = 0.5;
        this._featuresPanel.add(Box.createHorizontalGlue(), gbc);
        this._featuresPanel.setVisible(true);
        this._featuresPanel.validate();
        ((GUITaskContext)this._context).setEnabledButtonState(GUITaskContext.ButtonType.FINISH, true);
        this._uninstallButtonEnabled = true;
        this.updateMessagePanel();
    }

    public void init() {
        this.loadDistributionTrees();
        this._helper.getOracleHomeFeatureDependencies();
        this._helper.getOracleHomeDependents();
        this._helper.getOracleHomeFeatureSetGroupDependents(this._distributionTrees);
    }

    private void loadDistributionTrees() {
        List<Distribution> distributions = this._helper.getInstalledDistributions();
        for (Distribution dist : distributions) {
            this.createFeatureSetUninstallSelectionTree(dist);
        }
    }

    private void createFeatureSetUninstallSelectionTree(Distribution distribution) {
        TreeModel model = this._helper.getFeatureSelectionTreeModel(distribution);
        FeatureSetUninstallSelectionTree tree = new FeatureSetUninstallSelectionTree(model);
        tree.addFeatureSelectionListener(this);
        tree.addFeatureSelectedCountListener(this);
        tree.setShowsRootHandles(true);
        GUIHelper.expandJTreeNode(tree, tree.getModel().getRoot(), -1, 2);
        this._distributionTrees.put(distribution, tree);
    }

    private void unselectAllDistributions() {
        Distribution currentDist = this._currentDistribution;
        Iterator<Distribution> iterator = this._helper.getInstalledDistributions().iterator();
        while (iterator.hasNext()) {
            Distribution distribution;
            this._currentDistribution = distribution = iterator.next();
            FeatureSetUninstallSelectionTree tree = this._distributionTrees.get(distribution);
            for (SelectableFeatureSet featureSet : tree.getAllFeatureSets()) {
                if (!featureSet.isSelectedCheckBox()) continue;
                tree.setSelected((Selectable)featureSet, false, false, true);
            }
            tree.getModel().valueForPathChanged(new TreePath(tree.getModel().getRoot()), null);
        }
        this.refreshDisabledSelectables();
        this._currentDistribution = currentDist;
    }

    @Override
    public void updateSelectableState(Selectable selectable, boolean state) {
        if (selectable instanceof SelectableFeatureSet) {
            QuickReference featureRef = (QuickReference)((SelectableFeatureSet)selectable).getReference();
            QuickReference distributionRef = ((SelectableFeatureSet)selectable).getParentDistribution();
            if (state && (!this._selectedFeatureSets.containsKey(featureRef) || this._selectedFeatureSets.containsKey(featureRef) && !this._selectedFeatureSets.get(featureRef).contains(distributionRef))) {
                this.addFeatureToSelected(featureRef, distributionRef);
            } else if (!state && this._selectedFeatureSets.containsKey(featureRef) && this._selectedFeatureSets.get(featureRef).contains(distributionRef)) {
                this.removeFeatureFromSelected(featureRef);
                this.removeDependenciesFromSelected(featureRef);
            }
        }
        if (selectable instanceof SelectableDistribution) {
            QuickReference distRef = new QuickReference(selectable.getName(), selectable.getVersion());
            if (state && !this._selectedDistributions.contains(distRef)) {
                this._selectedDistributions.add(distRef);
            } else if (!state && this._selectedDistributions.contains(distRef)) {
                this._selectedDistributions.remove(distRef);
                this.removeDependenciesFromSelected(distRef);
            }
        }
        if (this.hasMessagePanelWarning) {
            ((GUITaskContext)this._context).clearAllValidationMessages();
        }
    }

    private void addFeatureToSelected(QuickReference featureRef, QuickReference distributionRef) {
        if (this._selectedFeatureSets.containsKey(featureRef)) {
            this._selectedFeatureSets.get(featureRef).add(distributionRef);
        } else {
            HashSet<QuickReference> distributions = new HashSet<QuickReference>();
            distributions.add(distributionRef);
            this._selectedFeatureSets.put(featureRef, distributions);
        }
    }

    private void removeFeatureFromSelected(QuickReference featureRef) {
        if (this._selectedFeatureSets.containsKey(featureRef)) {
            QuickReference distToRemove = this._refreshedDistribution == null ? new QuickReference(this._currentDistribution.getName(), this._currentDistribution.getVersion()) : new QuickReference(this._refreshedDistribution.getName(), this._refreshedDistribution.getVersion());
            this._selectedFeatureSets.get(featureRef).remove(distToRemove);
            if (this._selectedFeatureSets.get(featureRef).isEmpty()) {
                this._selectedFeatureSets.remove(featureRef);
            }
        }
    }

    @Override
    public void refreshDisabledSelectables() {
        if (this._currentDistribution != null) {
            int startIndex;
            for (int i = startIndex = this._helper.getInstalledDistributions().indexOf(this._currentDistribution); i >= 0; --i) {
                this._refreshedDistribution = this._helper.getInstalledDistributions().get(i);
                FeatureSetUninstallSelectionTree tree = this._distributionTrees.get(this._refreshedDistribution);
                if (tree == null) continue;
                SelectableDistribution dist = tree.getDistribution();
                this.validateDisableDistribution(dist);
                for (SelectableFeatureSet fs : tree.getAllFeatureSets()) {
                    this.validateDisableSelectable((Selectable)fs, dist, true);
                }
                for (SelectableFeatureSetGroup fsGroup : tree.getAllFeatureSetGroups()) {
                    this.validateDisableSelectable((Selectable)fsGroup, dist, false);
                }
            }
            this._refreshedDistribution = null;
        }
    }

    private void validateDisableSelectable(Selectable selectable, SelectableDistribution distribution, boolean isFeatureSet) {
        QuickReference selectableRef;
        Map<QuickReference, Set<QuickReference>> dependentsMap = isFeatureSet ? this._helper.getOracleHomeDependents() : this._helper.getOracleHomeFeatureSetGroupDependents(this._distributionTrees);
        if (dependentsMap.containsKey(selectableRef = new QuickReference(selectable.getName(), selectable.getVersion()))) {
            Set<QuickReference> dependents = dependentsMap.get(selectableRef);
            if (dependents != null && !dependents.isEmpty()) {
                if (!this._helper.isFeatureUninstallable(this._selectedFeatureSets, this._selectedDistributions, selectableRef, dependents) && !distribution.isSelected()) {
                    if (selectable.isSelectedCheckBox()) {
                        this._distributionTrees.get(this._currentDistribution).setSelected(selectable, false, false, false);
                    }
                    if (!selectable.isDisabled()) {
                        selectable.setDisabled(true);
                    }
                } else if (this._helper.isFeatureUninstallable(this._selectedFeatureSets, this._selectedDistributions, selectableRef, dependents) && (!(selectable instanceof SelectableFeatureSetGroup) || !((SelectableFeatureSetGroup)selectable).hasRequiredChildren()) && selectable.isDisabled()) {
                    selectable.setDisabled(false);
                }
            }
            if (selectable instanceof SelectableFeatureSetGroup && ((SelectableFeatureSetGroup)selectable).hasRequiredChildren() && !selectable.isDisabled()) {
                selectable.setDisabled(true);
            }
        }
        if (selectable instanceof SelectableFeatureSet && selectable.isSelectedCheckBox() && (!this._selectedFeatureSets.keySet().contains(new QuickReference(selectable.getName(), selectable.getVersion())) || selectable.isRequired() && !distribution.isSelected())) {
            this._distributionTrees.get(this._currentDistribution).setSelected(selectable, false, false, false);
        }
    }

    private void validateDisableDistribution(SelectableDistribution distribution) {
        QuickReference distReference = new QuickReference(distribution.getName(), distribution.getVersion());
        if (!this._helper.isUninstallable(distReference)) {
            try {
                if (this._helper.isDistributionUninstallable(this._selectedFeatureSets, this._selectedDistributions, distReference)) {
                    if (distribution.isDisabled()) {
                        distribution.setDisabled(false);
                    }
                } else {
                    if (!distribution.isDisabled() && !this._selectAll) {
                        distribution.setDisabled(true);
                    }
                    if (distribution.isSelected() && !this._selectAll) {
                        this._distributionTrees.get(this._currentDistribution).setSelected((Selectable)distribution, false, false, false);
                    }
                }
            }
            catch (PostInstallHelperException e) {
                this._logger.log(Level.SEVERE, "Could not verify if distribution " + distReference + " is Uninstallable", e);
                e.printStackTrace();
            }
        }
    }

    private void removeDependenciesFromSelected(QuickReference feature) {
        if (this._helper.getOracleHomeFeatureDependencies().containsKey(feature) && !this._helper.getOracleHomeFeatureDependencies().get(feature).isEmpty()) {
            Set<QuickReference> dependencies = this._helper.getOracleHomeFeatureDependencies().get(feature);
            this._selectedFeatureSets.keySet().removeAll(dependencies);
            for (QuickReference dependentFs : dependencies) {
                if (dependentFs == feature) continue;
                this.removeDependenciesFromSelected(dependentFs);
            }
        }
        if (this._helper.getDistributionDependencyDistributionsMap().containsKey(feature) && !this._helper.getDistributionDependencyDistributionsMap().get(feature).isEmpty()) {
            this._selectedDistributions.removeAll((Collection)this._helper.getDistributionDependencyDistributionsMap().get(feature));
            for (QuickReference dependentDist : this._helper.getDistributionDependencyDistributionsMap().get(feature)) {
                if (dependentDist == feature) continue;
                this.removeDependenciesFromSelected(dependentDist);
            }
        }
    }

    @Override
    public void updateCountOfSelectedFeatureSets() {
        for (Distribution distribution : this._helper.getInstalledDistributions()) {
            int count = this.getCountOfSelectedFeatureSets(distribution);
            JLabel numSelectedLabel = this._countSelectedFeaturesLabels.get(distribution);
            if (count == 0) {
                numSelectedLabel.setVisible(false);
                continue;
            }
            if (!numSelectedLabel.isVisible()) {
                numSelectedLabel.setVisible(true);
            }
            numSelectedLabel.setText(((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.label.selectedFeatures.text") + " " + count);
            numSelectedLabel.revalidate();
        }
        this.updateMessagePanel();
    }

    public int getCountOfSelectedFeatureSets(Distribution distribution) {
        QuickReference distributionReference = new QuickReference(distribution.getName(), distribution.getVersion());
        int count = 0;
        for (Set<QuickReference> distributions : this._selectedFeatureSets.values()) {
            if (!distributions.contains(distributionReference)) continue;
            ++count;
        }
        return count;
    }

    private void updateMessagePanel() {
        this.showSelectedFeatureSetsInMessagePanel();
        this.showDependentDistributionsInMessagePanel();
    }

    private void showSelectedFeatureSetsInMessagePanel() {
        Map<QuickReference, Set<QuickReference>> featureSets;
        JComponent[] list = null;
        ((GUITaskContext)this._context).clearAllValidationMessages();
        if (this._selectedDistributions != null && !this._selectedDistributions.isEmpty()) {
            ((GUITaskContext)this._context).addValidationMessage(MessageType.INFORMATION, ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.message.selectedDistributions.text"), this._selectedDistributions.toString(), list);
        }
        if ((featureSets = this.getIndividualSelectedFeatureSets()) != null && !featureSets.isEmpty()) {
            ((GUITaskContext)this._context).addValidationMessage(MessageType.INFORMATION, ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.message.selectedFeatureSets.text"), featureSets.keySet().toString(), list);
        }
    }

    private void showDependentDistributionsInMessagePanel() {
        JComponent[] list = null;
        SelectableDistribution currentDist = this._distributionTrees.get(this._currentDistribution).getDistribution();
        if (currentDist.isDisabled()) {
            QuickReference currentDistReference = new QuickReference(currentDist.getName(), currentDist.getVersion());
            Set<QuickReference> dependentDistributions = this._helper.getDistributionDependentDistributions(currentDistReference);
            ((GUITaskContext)this._context).addValidationMessage(MessageType.INFORMATION, ((GUITaskContext)this._context).getI18nString(this._namespace, "DistributionUninstallTask.warning.disabledDistribution.text"), dependentDistributions.toString(), list);
        }
    }

    private Map<QuickReference, Set<QuickReference>> getIndividualSelectedFeatureSets() {
        if (this._selectedDistributions == null || this._selectedDistributions.isEmpty()) {
            return this._selectedFeatureSets;
        }
        HashMap<QuickReference, Set<QuickReference>> _individualSelectedFeatures = new HashMap<QuickReference, Set<QuickReference>>();
        for (Map.Entry<QuickReference, Set<QuickReference>> entry : this._selectedFeatureSets.entrySet()) {
            _individualSelectedFeatures.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Set distributions : _individualSelectedFeatures.values()) {
            distributions.removeAll(this._selectedDistributions);
        }
        HashSet featuresToRemove = new HashSet();
        for (Map.Entry entry : _individualSelectedFeatures.entrySet()) {
            if (!((Set)entry.getValue()).isEmpty()) continue;
            featuresToRemove.add(entry.getKey());
        }
        _individualSelectedFeatures.keySet().removeAll(featuresToRemove);
        return _individualSelectedFeatures;
    }

    public void setHelper(PostInstallHelperImpl helper) {
        this._helper = helper;
    }

    public void setCurrentDistribution(Distribution distribution) {
        this._currentDistribution = distribution;
    }

    public Distribution getCurrentDistribution() {
        return this._currentDistribution;
    }

    public HashMap<Distribution, FeatureSetUninstallSelectionTree> getDistributionTrees() {
        return (HashMap)this._distributionTrees.clone();
    }

    private Distribution getAnyDistribution() {
        List<Distribution> all = this._helper.getInstalledDistributions();
        if (all.isEmpty()) {
            return null;
        }
        return all.get(0);
    }

    private Distribution getDefaultUninstallableDistribution() {
        for (Distribution d : this._helper.getInstalledDistributions()) {
            if (!this._helper.isDistributionUninstallable(d.getName(), d.getVersion())) continue;
            return d;
        }
        return null;
    }

    protected JPanel buildOldDistributionPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel distributionPanel = new JPanel(new GridBagLayout());
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.insets.bottom = 6;
        JLabel selectLabel = new JLabel(((GUITaskContext)this._context).getI18nString(this._namespace, "UninstallGUITask.label.selectDistribution.text"));
        selectLabel.setLabelFor(this._distributionsCombo);
        distributionPanel.add((Component)selectLabel, gbc);
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this._distributionsCombo = new JComboBox(model);
        this._distributionsCombo.setEditable(false);
        for (Distribution d : this._helper.getInstalledDistributions()) {
            this._distributionsCombo.addItem(d);
        }
        this._distributionsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int index;
                if (e.getStateChange() == 1 && (index = ((JComboBox)e.getSource()).getSelectedIndex()) >= 0) {
                    DistributionUninstallTask.this._selectedDistribution = DistributionUninstallTask.this._helper.getInstalledDistributions().get(index);
                    DistributionUninstallTask.this.refreshFeaturesPanel(DistributionUninstallTask.this._selectedDistribution);
                }
            }
        });
        gbc.insets.bottom = 0;
        gbc.gridy = 1;
        distributionPanel.add((Component)this._distributionsCombo, gbc);
        return distributionPanel;
    }

    protected void buildOldFeaturesPanel(Distribution distribution) {
        if (this._featuresPanel == null) {
            throw new IllegalStateException("_featuresPanel is null");
        }
        this._featuresPanel.setVisible(false);
        this._featuresPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        JTextPane messagePane = new JTextPane();
        HTMLEditorKit kit = GUIUtilities.getHTMLEditorKit(false);
        messagePane.setEditorKit(kit);
        messagePane.setEditable(false);
        messagePane.setOpaque(false);
        messagePane.setFocusable(true);
        StringBuilder sBuilder = new StringBuilder();
        gbc.gridy = 0;
        gbc.insets.top = 6;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.insets.left = 10;
        gbc.fill = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets.bottom = 6;
        JLabel distContentLabel = new JLabel(((GUITaskContext)this._context).getI18nString(this._namespace, "UninstallGUITask.label.distributionContent.text"));
        distContentLabel.setFocusable(true);
        this._featuresPanel.add((Component)distContentLabel, gbc);
        List<String> feats = this._helper.getInstalledFeatureSets(distribution);
        if (feats != null) {
            gbc.insets.left = 24;
            gbc.insets.top = 0;
            ++gbc.gridy;
            for (String feat : feats) {
                sBuilder.append("\u2022 ");
                sBuilder.append(feat);
                sBuilder.append("<br><div style='height: 3px; font-size:0;'></div>");
            }
            messagePane.setText(sBuilder.toString());
            this._featuresPanel.add((Component)messagePane, gbc);
        }
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.weighty = 0.5;
        this._featuresPanel.add(Box.createHorizontalGlue(), gbc);
        this._featuresPanel.setVisible(true);
        this._featuresPanel.validate();
        ((GUITaskContext)this._context).setEnabledButtonState(GUITaskContext.ButtonType.FINISH, true);
        this._uninstallButtonEnabled = true;
    }

    protected void refreshFeaturesPanel(Distribution distribution) {
        if (!this._helper.isDistributionUninstallable(distribution.getName(), distribution.getVersion())) {
            this.buildCannotUninstallPanel(distribution);
        } else {
            this.buildOldFeaturesPanel(distribution);
        }
    }

    protected void buildCannotUninstallPanel(Distribution distribution) {
        if (this._featuresPanel == null) {
            throw new IllegalStateException("_featuresPanel is null");
        }
        this._featuresPanel.setVisible(false);
        this._featuresPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.insets.top = 6;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.insets.bottom = 6;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this._featuresPanel.add((Component)new JLabel(GUIUtilities.loadIcon("resources/nginst/images/info.png")), gbc);
        gbc.weightx = 0.5;
        ++gbc.gridx;
        this._featuresPanel.add((Component)new JLabel(((GUITaskContext)this._context).getI18nString(this._namespace, "UninstallGUITask.label.cannotUninstall.text")), gbc);
        ++gbc.gridx;
        gbc.fill = 0;
        this._featuresPanel.add(Box.createVerticalGlue(), gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 3;
        HashSet<Distribution> deps = this._helper.getDistributionDependents(distribution);
        gbc.insets.left = 24;
        if (deps != null) {
            for (Distribution dep : deps) {
                ++gbc.gridy;
                this._featuresPanel.add((Component)new JLabel(dep.toString()), gbc);
            }
        }
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.weighty = 0.5;
        this._featuresPanel.add(Box.createHorizontalGlue(), gbc);
        this._featuresPanel.setVisible(true);
        this._featuresPanel.validate();
        ((GUITaskContext)this._context).setEnabledButtonState(GUITaskContext.ButtonType.FINISH, false);
        this._uninstallButtonEnabled = false;
    }
}

