/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.wizard.gui.tasks;

import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.nextgen.launcher.PostInstallHelperException;
import com.oracle.cie.nextgen.launcher.PostInstallHelperImpl;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="uninstaller_config_gui_task")
public class UninstallerConfigurationGUITask
extends AbstractSilentTask {
    private static final String COMPLETE_GUI_CONFIGURATION = "complete";
    private PostInstallHelperImpl _helper;

    public void execute() throws TaskExecutionException {
        String oracleHome = ObjectStoreManager.getObjectStore().getString("ORACLE_HOME");
        try {
            this._helper = PostInstallHelperImpl.getPostInstallHelperImpl(oracleHome);
        }
        catch (PostInstallHelperException e) {
            this._logger.log(Level.SEVERE, "Could not load the inventory for the Oracle Home: " + oracleHome, e);
            throw new TaskExecutionException((Task)this, e.getMessage());
        }
        this._context.setWorkflowProperty(COMPLETE_GUI_CONFIGURATION, String.valueOf(this.isSupported()));
    }

    private boolean isSupported() {
        return this._helper.isEnhancedUninstallSupported();
    }
}

