/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.announcementsservice.AnnouncementAsync;
import com.oracle.bmc.announcementsservice.internal.http.GetAnnouncementConverter;
import com.oracle.bmc.announcementsservice.internal.http.GetAnnouncementUserStatusConverter;
import com.oracle.bmc.announcementsservice.internal.http.ListAnnouncementsConverter;
import com.oracle.bmc.announcementsservice.internal.http.UpdateAnnouncementUserStatusConverter;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementRequest;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementsRequest;
import com.oracle.bmc.announcementsservice.requests.UpdateAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementResponse;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementUserStatusResponse;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementsResponse;
import com.oracle.bmc.announcementsservice.responses.UpdateAnnouncementUserStatusResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncementAsyncClient
implements AnnouncementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(AnnouncementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANNOUNCEMENT").serviceEndpointPrefix("announcements").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public AnnouncementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AnnouncementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AnnouncementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AnnouncementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AnnouncementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AnnouncementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AnnouncementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<GetAnnouncementResponse> getAnnouncement(GetAnnouncementRequest request, AsyncHandler<GetAnnouncementRequest, GetAnnouncementResponse> handler) {
        LOG.trace("Called async getAnnouncement");
        final GetAnnouncementRequest interceptedRequest = GetAnnouncementConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAnnouncementConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAnnouncementResponse> transformer = GetAnnouncementConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAnnouncementRequest, GetAnnouncementResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAnnouncementRequest, GetAnnouncementResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAnnouncementRequest, GetAnnouncementResponse> onSuccess = new SuccessConsumer<GetAnnouncementRequest, GetAnnouncementResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAnnouncementRequest> onError = new ErrorConsumer<GetAnnouncementRequest>(this, interceptedRequest);
                    AnnouncementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAnnouncementRequest, GetAnnouncementResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAnnouncementRequest, GetAnnouncementResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAnnouncementRequest> onError = handler == null ? null : new ErrorConsumer<GetAnnouncementRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAnnouncementResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AnnouncementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAnnouncementResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAnnouncementUserStatusResponse> getAnnouncementUserStatus(GetAnnouncementUserStatusRequest request, AsyncHandler<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse> handler) {
        LOG.trace("Called async getAnnouncementUserStatus");
        final GetAnnouncementUserStatusRequest interceptedRequest = GetAnnouncementUserStatusConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAnnouncementUserStatusConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAnnouncementUserStatusResponse> transformer = GetAnnouncementUserStatusConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse> onSuccess = new SuccessConsumer<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAnnouncementUserStatusRequest> onError = new ErrorConsumer<GetAnnouncementUserStatusRequest>(this, interceptedRequest);
                    AnnouncementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAnnouncementUserStatusRequest, GetAnnouncementUserStatusResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAnnouncementUserStatusRequest> onError = handler == null ? null : new ErrorConsumer<GetAnnouncementUserStatusRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAnnouncementUserStatusResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AnnouncementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAnnouncementUserStatusResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAnnouncementsResponse> listAnnouncements(ListAnnouncementsRequest request, AsyncHandler<ListAnnouncementsRequest, ListAnnouncementsResponse> handler) {
        LOG.trace("Called async listAnnouncements");
        final ListAnnouncementsRequest interceptedRequest = ListAnnouncementsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAnnouncementsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAnnouncementsResponse> transformer = ListAnnouncementsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAnnouncementsRequest, ListAnnouncementsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAnnouncementsRequest, ListAnnouncementsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAnnouncementsRequest, ListAnnouncementsResponse> onSuccess = new SuccessConsumer<ListAnnouncementsRequest, ListAnnouncementsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAnnouncementsRequest> onError = new ErrorConsumer<ListAnnouncementsRequest>(this, interceptedRequest);
                    AnnouncementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAnnouncementsRequest, ListAnnouncementsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAnnouncementsRequest, ListAnnouncementsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAnnouncementsRequest> onError = handler == null ? null : new ErrorConsumer<ListAnnouncementsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAnnouncementsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AnnouncementAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAnnouncementsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAnnouncementUserStatusResponse> updateAnnouncementUserStatus(UpdateAnnouncementUserStatusRequest request, AsyncHandler<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse> handler) {
        LOG.trace("Called async updateAnnouncementUserStatus");
        final UpdateAnnouncementUserStatusRequest interceptedRequest = UpdateAnnouncementUserStatusConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAnnouncementUserStatusConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAnnouncementUserStatusResponse> transformer = UpdateAnnouncementUserStatusConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse> onSuccess = new SuccessConsumer<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAnnouncementUserStatusRequest> onError = new ErrorConsumer<UpdateAnnouncementUserStatusRequest>(this, interceptedRequest);
                    AnnouncementAsyncClient.this.client.put(ib, interceptedRequest.getStatusDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAnnouncementUserStatusRequest, UpdateAnnouncementUserStatusResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAnnouncementUserStatusRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAnnouncementUserStatusRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getStatusDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAnnouncementUserStatusResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AnnouncementAsyncClient.this.client.put(ib, interceptedRequest.getStatusDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAnnouncementUserStatusResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnnouncementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public AnnouncementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new AnnouncementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

