/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.announcementsservice.model.Announcement;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAnnouncementConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAnnouncementConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAnnouncementRequest interceptRequest(GetAnnouncementRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAnnouncementRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAnnouncementId(), (String)"announcementId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180904").path("announcements").path(HttpUtils.encodePathSegment(request.getAnnouncementId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetAnnouncementResponse> fromResponse() {
        Function<Response, GetAnnouncementResponse> transformer = new Function<Response, GetAnnouncementResponse>(){

            public GetAnnouncementResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetAnnouncementResponse");
                Function<Response, WithHeaders<Announcement>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Announcement.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetAnnouncementResponse.Builder builder = GetAnnouncementResponse.builder();
                builder.announcement((Announcement)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetAnnouncementResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

