/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.announcementsservice.model.AnnouncementsCollection;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementsRequest;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListAnnouncementsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListAnnouncementsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListAnnouncementsRequest interceptRequest(ListAnnouncementsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListAnnouncementsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180904").path("announcements");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        target = target.queryParam("compartmentId", HttpUtils.attemptEncodeQueryParam(request.getCompartmentId()));
        if (request.getAnnouncementType() != null) {
            target = target.queryParam("announcementType", HttpUtils.attemptEncodeQueryParam(request.getAnnouncementType()));
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", HttpUtils.attemptEncodeQueryParam(request.getLifecycleState().getValue()));
        }
        if (request.getIsBanner() != null) {
            target = target.queryParam("isBanner", HttpUtils.attemptEncodeQueryParam(request.getIsBanner()));
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", HttpUtils.attemptEncodeQueryParam(request.getSortBy().getValue()));
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", HttpUtils.attemptEncodeQueryParam(request.getSortOrder().getValue()));
        }
        if (request.getTimeOneEarliestTime() != null) {
            target = target.queryParam("timeOneEarliestTime", HttpUtils.attemptEncodeQueryParam(request.getTimeOneEarliestTime()));
        }
        if (request.getTimeOneLatestTime() != null) {
            target = target.queryParam("timeOneLatestTime", HttpUtils.attemptEncodeQueryParam(request.getTimeOneLatestTime()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListAnnouncementsResponse> fromResponse() {
        Function<Response, ListAnnouncementsResponse> transformer = new Function<Response, ListAnnouncementsResponse>(){

            public ListAnnouncementsResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListAnnouncementsResponse");
                Function<Response, WithHeaders<AnnouncementsCollection>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AnnouncementsCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListAnnouncementsResponse.Builder builder = ListAnnouncementsResponse.builder();
                builder.announcementsCollection((AnnouncementsCollection)response.getItem());
                Optional<List<String>> opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListAnnouncementsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

