/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.responses;

import com.oracle.bmc.announcementsservice.model.Announcement;
import java.beans.ConstructorProperties;

public class GetAnnouncementResponse {
    private String opcRequestId;
    private Announcement announcement;

    @ConstructorProperties(value={"opcRequestId", "announcement"})
    GetAnnouncementResponse(String opcRequestId, Announcement announcement) {
        this.opcRequestId = opcRequestId;
        this.announcement = announcement;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Announcement getAnnouncement() {
        return this.announcement;
    }

    public static class Builder {
        private String opcRequestId;
        private Announcement announcement;

        public Builder copy(GetAnnouncementResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.announcement(o.getAnnouncement());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder announcement(Announcement announcement) {
            this.announcement = announcement;
            return this;
        }

        public GetAnnouncementResponse build() {
            return new GetAnnouncementResponse(this.opcRequestId, this.announcement);
        }

        public String toString() {
            return "GetAnnouncementResponse.Builder(opcRequestId=" + this.opcRequestId + ", announcement=" + this.announcement + ")";
        }
    }
}

