/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.responses;

import com.oracle.bmc.announcementsservice.model.AnnouncementsCollection;
import java.beans.ConstructorProperties;

public class ListAnnouncementsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private AnnouncementsCollection announcementsCollection;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "announcementsCollection"})
    ListAnnouncementsResponse(String opcNextPage, String opcRequestId, AnnouncementsCollection announcementsCollection) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.announcementsCollection = announcementsCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AnnouncementsCollection getAnnouncementsCollection() {
        return this.announcementsCollection;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private AnnouncementsCollection announcementsCollection;

        public Builder copy(ListAnnouncementsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.announcementsCollection(o.getAnnouncementsCollection());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder announcementsCollection(AnnouncementsCollection announcementsCollection) {
            this.announcementsCollection = announcementsCollection;
            return this;
        }

        public ListAnnouncementsResponse build() {
            return new ListAnnouncementsResponse(this.opcNextPage, this.opcRequestId, this.announcementsCollection);
        }

        public String toString() {
            return "ListAnnouncementsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", announcementsCollection=" + this.announcementsCollection + ")";
        }
    }
}

