/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.audit.AuditAsync;
import com.oracle.bmc.audit.internal.http.GetConfigurationConverter;
import com.oracle.bmc.audit.internal.http.ListEventsConverter;
import com.oracle.bmc.audit.internal.http.UpdateConfigurationConverter;
import com.oracle.bmc.audit.requests.GetConfigurationRequest;
import com.oracle.bmc.audit.requests.ListEventsRequest;
import com.oracle.bmc.audit.requests.UpdateConfigurationRequest;
import com.oracle.bmc.audit.responses.GetConfigurationResponse;
import com.oracle.bmc.audit.responses.ListEventsResponse;
import com.oracle.bmc.audit.responses.UpdateConfigurationResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditAsyncClient
implements AuditAsync {
    private static final Logger LOG = LoggerFactory.getLogger(AuditAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AUDIT").serviceEndpointPrefix("audit").serviceEndpointTemplate("https://audit.{region}.oraclecloud.com").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public AuditAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AuditAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AuditAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AuditAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request, AsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handler) {
        LOG.trace("Called async getConfiguration");
        final GetConfigurationRequest interceptedRequest = GetConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetConfigurationResponse> transformer = GetConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetConfigurationRequest, GetConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetConfigurationRequest, GetConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetConfigurationRequest, GetConfigurationResponse> onSuccess = new SuccessConsumer<GetConfigurationRequest, GetConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetConfigurationRequest> onError = new ErrorConsumer<GetConfigurationRequest>(this, interceptedRequest);
                    AuditAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetConfigurationRequest, GetConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetConfigurationRequest, GetConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<GetConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AuditAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetConfigurationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListEventsResponse> listEvents(ListEventsRequest request, AsyncHandler<ListEventsRequest, ListEventsResponse> handler) {
        LOG.trace("Called async listEvents");
        final ListEventsRequest interceptedRequest = ListEventsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListEventsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListEventsResponse> transformer = ListEventsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListEventsRequest, ListEventsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListEventsRequest, ListEventsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListEventsRequest, ListEventsResponse> onSuccess = new SuccessConsumer<ListEventsRequest, ListEventsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListEventsRequest> onError = new ErrorConsumer<ListEventsRequest>(this, interceptedRequest);
                    AuditAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListEventsRequest, ListEventsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListEventsRequest, ListEventsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListEventsRequest> onError = handler == null ? null : new ErrorConsumer<ListEventsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListEventsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AuditAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListEventsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request, AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handler) {
        LOG.trace("Called async updateConfiguration");
        final UpdateConfigurationRequest interceptedRequest = UpdateConfigurationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateConfigurationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateConfigurationResponse> transformer = UpdateConfigurationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateConfigurationRequest, UpdateConfigurationResponse> onSuccess = new SuccessConsumer<UpdateConfigurationRequest, UpdateConfigurationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateConfigurationRequest> onError = new ErrorConsumer<UpdateConfigurationRequest>(this, interceptedRequest);
                    AuditAsyncClient.this.client.put(ib, interceptedRequest.getUpdateConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateConfigurationRequest, UpdateConfigurationResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateConfigurationRequest, UpdateConfigurationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateConfigurationRequest> onError = handler == null ? null : new ErrorConsumer<UpdateConfigurationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateConfigurationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateConfigurationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return AuditAsyncClient.this.client.put(ib, interceptedRequest.getUpdateConfigurationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateConfigurationResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AuditAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public AuditAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new AuditAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

