/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.audit;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.audit.Audit;
import com.oracle.bmc.audit.model.AuditEvent;
import com.oracle.bmc.audit.requests.ListEventsRequest;
import com.oracle.bmc.audit.responses.ListEventsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class AuditPaginators {
    private final Audit client;

    public Iterable<ListEventsResponse> listEventsResponseIterator(final ListEventsRequest request) {
        return new ResponseIterable<ListEventsRequest.Builder, ListEventsRequest, ListEventsResponse>(new Supplier<ListEventsRequest.Builder>(){

            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, new Function<ListEventsResponse, String>(){

            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListEventsRequest, ListEventsResponse>(){

            public ListEventsResponse apply(ListEventsRequest request) {
                return AuditPaginators.this.client.listEvents(request);
            }
        });
    }

    public Iterable<AuditEvent> listEventsRecordIterator(final ListEventsRequest request) {
        return new ResponseRecordIterable<ListEventsRequest.Builder, ListEventsRequest, ListEventsResponse, AuditEvent>(new Supplier<ListEventsRequest.Builder>(){

            public ListEventsRequest.Builder get() {
                return ListEventsRequest.builder().copy(request);
            }
        }, new Function<ListEventsResponse, String>(){

            public String apply(ListEventsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListEventsRequest.Builder>, ListEventsRequest>(){

            public ListEventsRequest apply(RequestBuilderAndToken<ListEventsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListEventsRequest, ListEventsResponse>(){

            public ListEventsResponse apply(ListEventsRequest request) {
                return AuditPaginators.this.client.listEvents(request);
            }
        }, new Function<ListEventsResponse, List<AuditEvent>>(){

            public List<AuditEvent> apply(ListEventsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public AuditPaginators(Audit client) {
        this.client = client;
    }
}

